/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartRequestStatus;
import com.t4login.messages.ChartDataResponseMessage;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class MsgChartContractData
extends Message
implements ChartDataResponseMessage {
    public String RequestID;
    public ChartRequestStatus Status;
    public int ChartDataResponseFlags;
    public boolean NoCache = false;
    public String ExchangeID;
    public String ContractID;
    public NDateTime TradeDate;
    public List<MarketData> Markets = new ArrayList<MarketData>();
    public NDateTime CacheGenerationDate = NDateTime.MinValue;

    public MsgChartContractData() {
        super(MessageType.ChartContractData);
    }

    @Override
    public String getRequestID() {
        return this.RequestID;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.ExchangeID = MsgChartContractData.readString(in);
        this.ContractID = MsgChartContractData.readString(in);
        this.TradeDate = MsgChartContractData.readDateTime(in);
        this.RequestID = MsgChartContractData.readString(in);
        int nMarkets = MsgChartContractData.readInteger(in);
        for (int i = 0; i < nMarkets; ++i) {
            MarketData mkt = new MarketData();
            mkt.MarketID = MsgChartContractData.readString(in);
            mkt.TTV = MsgChartContractData.readInteger(in);
            this.Markets.add(mkt);
        }
        this.Status = ChartRequestStatus.get(MsgChartContractData.readInteger(in));
        this.ChartDataResponseFlags = MsgChartContractData.readInteger(in);
        if ((this.ChartDataResponseFlags & 1) != 0) {
            this.NoCache = true;
        }
        this.CacheGenerationDate = MsgChartContractData.readDateTime(in);
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        MarketData activeMarket = null;
        for (MarketData mkt : this.Markets) {
            if (activeMarket != null && activeMarket.TTV >= mkt.TTV) continue;
            activeMarket = mkt;
        }
        sb.append("MsgChartContractData[");
        sb.append("RequestID: ").append(this.RequestID).append(", ");
        sb.append("Status: ").append(this.Status).append(", ");
        sb.append("ChartDataResponseFlags: ").append(this.ChartDataResponseFlags).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("ContractID: ").append(this.ContractID).append(", ");
        sb.append("tradeDate: ").append(this.TradeDate.toDateString()).append(", ");
        sb.append("Market Count: ").append(this.Markets.size()).append(", ");
        sb.append("Active Market: ").append(activeMarket != null ? activeMarket.MarketID : "-");
        sb.append("CacheGenerationDate: ").append(this.CacheGenerationDate);
        sb.append("]");
        return sb.toString();
    }

    public static final class MarketData {
        public String MarketID;
        public int TTV;
    }
}

