/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import com.t4login.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class MsgChartCacheGeneration
extends Message {
    public List<ExchangeGeneration> ExchangeGenerations = new ArrayList<ExchangeGeneration>();
    public List<ExchangeEarliestDate> ExchangeEarliestDates = new ArrayList<ExchangeEarliestDate>();

    public MsgChartCacheGeneration() {
        super(MessageType.ChartCacheGeneration);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        int nGens = MsgChartCacheGeneration.readInteger(in);
        for (int i = 0; i < nGens; ++i) {
            ExchangeGeneration gen = new ExchangeGeneration();
            gen.ExchangeID = MsgChartCacheGeneration.readShortString(in);
            gen.Generation = MsgChartCacheGeneration.readDateTime(in);
            this.ExchangeGenerations.add(gen);
        }
        if (ver > 1) {
            int nEarliestDates = MsgChartCacheGeneration.readInteger(in);
            for (int i = 0; i < nEarliestDates; ++i) {
                ExchangeEarliestDate gen = new ExchangeEarliestDate();
                gen.ExchangeID = MsgChartCacheGeneration.readShortString(in);
                gen.DataType = ChartDataType.get(MsgChartCacheGeneration.readIntBytes(in, 4));
                gen.EarliestDate = MsgChartCacheGeneration.readShortString(in);
                this.ExchangeEarliestDates.add(gen);
            }
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgChartCacheGeneration[");
        ArrayList<CallSite> gens = new ArrayList<CallSite>();
        for (ExchangeGeneration gen : this.ExchangeGenerations) {
            gens.add((CallSite)((Object)(gen.ExchangeID + ": " + String.valueOf(gen.Generation))));
        }
        sb.append(TextUtils.join((CharSequence)", ", gens));
        sb.append("]");
        return sb.toString();
    }

    public static final class ExchangeGeneration {
        public String ExchangeID;
        public NDateTime Generation;
    }

    public static final class ExchangeEarliestDate {
        public String ExchangeID;
        public ChartDataType DataType;
        public String EarliestDate;
    }
}

