/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BarIntervalBreak;
import com.t4login.definitions.ChartDataRequestApplication;
import com.t4login.definitions.ChartResetInterval;
import com.t4login.definitions.ChartType;
import com.t4login.definitions.ContinuationType;
import com.t4login.definitions.ContractMonths;
import com.t4login.messages.ChartDataRequestMessage;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Set;

public class MsgChartAggregatedDataRequest
extends Message
implements ChartDataRequestMessage {
    public String RequestID = "";
    public String ExchangeID = "";
    public String ContractID = "";
    public String MarketID = "";
    public ContinuationType ContinuationType = com.t4login.definitions.ContinuationType.Volume;
    public int RolloverThreshold = 0;
    public int ForwardMonths = 0;
    public Set<ContractMonths> ExpiryContractMonths = ContractMonths.All;
    public ChartType ChartType = com.t4login.definitions.ChartType.Bar;
    public BarIntervalBreak BarInterval = BarIntervalBreak.Minute;
    public int BarIntervalSize = 1;
    public ChartResetInterval BarResetInterval = ChartResetInterval.TradingWeek;
    public LinkedHashMap<String, String> ExConfig = new LinkedHashMap();
    public NDateTime TradeDateStart = NDateTime.MinValue;
    public NDateTime TradeDateEnd = NDateTime.MinValue;
    public NDateTime SessionStartTime = NDateTime.MinValue;
    public NDateTime SessionEndTime = NDateTime.MinValue;
    public ChartDataRequestApplication RequestingApplication;

    public MsgChartAggregatedDataRequest() {
        super(MessageType.ChartAggregatedDataRequest);
    }

    @Override
    public String getRequestID() {
        return this.RequestID;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        throw new MessageDecodingNotSupported(this.getMessageType());
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgChartAggregatedDataRequest.writeString(out, this.RequestID);
        MsgChartAggregatedDataRequest.writeString(out, this.ExchangeID);
        MsgChartAggregatedDataRequest.writeString(out, this.ContractID);
        MsgChartAggregatedDataRequest.writeString(out, this.MarketID);
        this.writeIntBytes(out, this.ContinuationType.getValue(), 1);
        this.writeIntBytes(out, this.RolloverThreshold, 1);
        this.writeIntBytes(out, this.ForwardMonths, 1);
        this.writeIntBytes(out, ContractMonths.toFlags(this.ExpiryContractMonths), 1);
        this.writeIntBytes(out, this.ChartType.getValue(), 1);
        this.writeIntBytes(out, this.BarInterval.getValue(), 1);
        this.writeIntBytes(out, this.BarIntervalSize, 4);
        this.writeIntBytes(out, this.BarResetInterval.getValue(), 1);
        MsgChartAggregatedDataRequest.writeStringDictionary(out, this.ExConfig);
        MsgChartAggregatedDataRequest.writeDateTime(out, this.TradeDateStart);
        MsgChartAggregatedDataRequest.writeDateTime(out, this.TradeDateEnd);
        MsgChartAggregatedDataRequest.writeDateTime(out, this.SessionStartTime);
        MsgChartAggregatedDataRequest.writeDateTime(out, this.SessionEndTime);
        this.writeIntBytes(out, this.RequestingApplication.getValue(), 1);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgChartAggregatedDataRequest[");
        sb.append("RequestID: ").append(this.RequestID).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("ContractID: ").append(this.ContractID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("ContinuationType: ").append(this.ContinuationType).append(", ");
        if (this.ContinuationType.equals(com.t4login.definitions.ContinuationType.Expiry)) {
            sb.append("RolloverThreshold: ").append(this.RolloverThreshold).append(", ");
            sb.append("ForwardMonths: ").append(this.ForwardMonths).append(", ");
            sb.append("ExpiryContractMonths: ").append(this.ExpiryContractMonths).append(", ");
        }
        sb.append("ChartTypeEn: ").append(this.ChartType).append(", ");
        sb.append("BarIntervalBreak: ").append(this.BarInterval).append(", ");
        sb.append("BarIntervalSize: ").append(this.BarIntervalSize).append(", ");
        sb.append("BarResetInterval: ").append(this.BarResetInterval).append(", ");
        sb.append("ExConfig: ").append(this.ExConfig);
        sb.append("TradeDateStart: ").append(this.TradeDateStart.toDateString()).append(", ");
        sb.append("TradeDateEnd: ").append(this.TradeDateEnd.toDateString()).append(", ");
        sb.append("SessionStartTime: ").append(this.TradeDateEnd.toShortTimeString()).append(", ");
        sb.append("SessionEndTime: ").append(this.TradeDateEnd.toShortTimeString()).append(", ");
        sb.append("RequestingApplication: ").append(this.RequestingApplication);
        sb.append("]");
        return sb.toString();
    }
}

