/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartRequestStatus;
import com.t4login.messages.ChartDataResponseMessage;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;

public class MsgChartAggregatedData
extends Message
implements ChartDataResponseMessage {
    public String RequestID;
    public ChartRequestStatus Status;
    public String StatusMessage;
    public int ChartDataResponseFlags;
    public NDateTime TradeDateStart;
    public NDateTime TradeDateEnd;
    public NDateTime LastTradeTime;
    public String ActiveMarket;
    public byte[] Data;

    public MsgChartAggregatedData() {
        super(MessageType.ChartAggregatedData);
    }

    @Override
    public String getRequestID() {
        return this.RequestID;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.RequestID = MsgChartAggregatedData.readShortString(in);
        this.Status = ChartRequestStatus.get(MsgChartAggregatedData.readIntBytes(in, 4));
        this.StatusMessage = MsgChartAggregatedData.readString(in);
        this.ChartDataResponseFlags = MsgChartAggregatedData.readIntBytes(in, 4);
        this.TradeDateStart = MsgChartAggregatedData.readDateTime(in);
        this.TradeDateEnd = MsgChartAggregatedData.readDateTime(in);
        this.LastTradeTime = MsgChartAggregatedData.readDateTime(in);
        this.ActiveMarket = MsgChartAggregatedData.readShortString(in);
        int dataLen = MsgChartAggregatedData.readIntBytes(in, 4);
        if (dataLen > 0) {
            this.Data = new byte[dataLen];
            in.read(this.Data);
        } else {
            this.Data = new byte[0];
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgChartAggregatedData[");
        sb.append("RequestID: ").append(this.RequestID).append(", ");
        sb.append("Status: ").append(this.Status).append(", ");
        sb.append("StatusMessage: ").append(this.StatusMessage).append(", ");
        sb.append("ChartDataResponseFlags: ").append(this.ChartDataResponseFlags).append(", ");
        sb.append("TradeDateStart: ").append(this.TradeDateStart.toDateString()).append(", ");
        sb.append("TradeDateEnd: ").append(this.TradeDateEnd.toDateString()).append(", ");
        sb.append("LastTradeTime: ").append(this.LastTradeTime.toShortTimeString()).append(", ");
        sb.append("ActiveMarket: ").append(this.ActiveMarket).append(", ");
        sb.append("Data: ").append(this.Data.length).append(" bytes");
        sb.append("]");
        return sb.toString();
    }
}

