/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.AccountStatus;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;

public class MsgAccountUpdate2
extends Message {
    public String AccountID;
    public AccountStatus Status;
    public double Balance;
    public double RPL;
    public double OvernightUPL;
    public double Margin;
    public double MP;
    public double Premium;
    public double FeesAndCommissions;
    public double LongMP;
    public double ShortMP;
    public double PrevMargin;
    public BigDecimal ImportedNetLiq;
    public NDateTime ImportedNetLiqDate;
    public BigDecimal PrevImportedNetLiq;
    public NDateTime PrevImportedNetLiqDate;
    public BigDecimal FilledDelta;
    public NDateTime MarginTime;
    public Double T500AlertingMargin;
    public NDateTime T500AlertingTime;

    public MsgAccountUpdate2() {
        super(MessageType.AccountUpdate2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.AccountID = MsgAccountUpdate2.readShortString(in);
        this.Status = AccountStatus.get(MsgAccountUpdate2.readIntBytes(in, 1));
        this.Balance = MsgAccountUpdate2.readDouble(in);
        this.RPL = MsgAccountUpdate2.readDouble(in);
        this.OvernightUPL = MsgAccountUpdate2.readDouble(in);
        this.Margin = MsgAccountUpdate2.readDouble(in);
        this.MP = MsgAccountUpdate2.readDouble(in);
        this.Premium = MsgAccountUpdate2.readDouble(in);
        this.FeesAndCommissions = MsgAccountUpdate2.readDouble(in);
        this.LongMP = MsgAccountUpdate2.readDouble(in);
        this.ShortMP = MsgAccountUpdate2.readDouble(in);
        this.PrevMargin = MsgAccountUpdate2.readDouble(in);
        if (ver > 6) {
            this.ImportedNetLiq = MsgAccountUpdate2.readDecimal(in);
            this.ImportedNetLiqDate = MsgAccountUpdate2.readDateTime(in);
            this.PrevImportedNetLiq = MsgAccountUpdate2.readDecimal(in);
            this.PrevImportedNetLiqDate = MsgAccountUpdate2.readDateTime(in);
        }
        if (ver > 7) {
            this.FilledDelta = MsgAccountUpdate2.read7BitDecimalN(in);
            MsgAccountUpdate2.read7BitDecimalN(in);
        }
        if (ver > 8) {
            MsgAccountUpdate2.read7BitDecimalN(in);
            MsgAccountUpdate2.read7BitDecimalN(in);
        }
        if (ver > 9) {
            MsgAccountUpdate2.read7BitDecimalN(in);
            MsgAccountUpdate2.read7BitDecimalN(in);
        }
        if (ver > 10) {
            this.MarginTime = MsgAccountUpdate2.read7BitDateTime(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
        }
        if (ver > 11) {
            MsgAccountUpdate2.readDoubleN(in);
            MsgAccountUpdate2.readDoubleN(in);
        }
        if (ver > 12) {
            this.T500AlertingMargin = MsgAccountUpdate2.readDouble(in);
            this.T500AlertingTime = MsgAccountUpdate2.read7BitDateTime(in);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgAccountUpdate2[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("Status: ").append(this.Status).append(", ");
        sb.append("Balance: ").append(this.Balance).append(", ");
        sb.append("RPL: ").append(this.RPL).append(", ");
        sb.append("OvernightUPL: ").append(this.OvernightUPL).append(", ");
        sb.append("Margin: ").append(this.Margin).append(", ");
        sb.append("MP: ").append(this.MP).append(", ");
        sb.append("Premium: ").append(this.Premium).append(", ");
        sb.append("FeesAndCommissions: ").append(this.FeesAndCommissions).append(", ");
        sb.append("LongMP: ").append(this.LongMP).append(", ");
        sb.append("ShortMP: ").append(this.ShortMP).append(", ");
        sb.append("PrevMargin: ").append(this.PrevMargin).append(", ");
        sb.append("ImportedNetLiq: ").append(this.ImportedNetLiq).append(", ");
        sb.append("ImportedNetLiqDate: ").append(this.ImportedNetLiqDate).append(", ");
        sb.append("PrevImportedNetLiq: ").append(this.PrevImportedNetLiq).append(", ");
        sb.append("PrevImportedNetLiqDate: ").append(this.PrevImportedNetLiqDate).append(", ");
        sb.append("FilledDelta: ").append(this.FilledDelta).append(", ");
        sb.append("MarginTime: ").append(this.MarginTime).append(", ");
        sb.append("T500AlertingMargin: ").append(this.T500AlertingMargin).append(", ");
        sb.append("T500AlertingTime: ").append(this.T500AlertingTime);
        sb.append("]");
        return sb.toString();
    }
}

