/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.definitions.AccountStatus;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MsgAccountSnapshot
extends Message
implements Iterable<Message> {
    static final String TAG = "MsgAccountSnapshot";
    public String AccountID;
    public long LastUpdateRequested;
    public long LastUpdateSupplied;
    public AccountStatus Status;
    public boolean DueToConnection;
    public List<Message> Messages = new ArrayList<Message>();

    public MsgAccountSnapshot() {
        super(MessageType.AccountSnapshot);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        this.AccountID = MsgAccountSnapshot.readShortString(in);
        this.LastUpdateRequested = MsgAccountSnapshot.readLong(in);
        this.LastUpdateSupplied = MsgAccountSnapshot.readLong(in);
        this.Status = AccountStatus.get(MsgAccountSnapshot.readIntBytes(in, 1));
        this.DueToConnection = MsgAccountSnapshot.readBooleanAlt(in);
        this.Messages.clear();
        int numMessages = MsgAccountSnapshot.readShort(in);
        for (int i = 0; i < numMessages; ++i) {
            Message msg = Message.getMessage(in);
            if (msg == null) continue;
            this.Messages.add(msg);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgAccountSnapshot[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("LastUpdateRequested: ").append(this.LastUpdateRequested).append(", ");
        sb.append("LastUpdateSupplied: ").append(this.LastUpdateSupplied).append(", ");
        sb.append("DueToConnection: ").append(this.DueToConnection).append(", ");
        sb.append("n messages: ").append(this.Messages.size()).append("]");
        return sb.toString();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.Messages.iterator();
    }
}

