/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractRiskStatus;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class MsgAccountPosition2
extends Message {
    public String AccountID;
    public String MarketID;
    public int Buys;
    public int Sells;
    public int WorkingBuys;
    public int WorkingSells;
    public double RPL;
    public double OvernightUPL;
    public double Margin;
    public double MP;
    private double AverageOpenTicks;
    private double TotalBuyFillTicks;
    private double TotalSellFillTicks;
    private double DayTotalBuyFillTicks;
    private double DayTotalSellFillTicks;
    public int OvernightPosition;
    public int DayBuys;
    public int DaySells;
    public double CurrencyRate;
    public NDateTime TradeDate;
    public double Premium;
    private double TotalOpenTicks;
    public int TotalOpenVolume;
    public double LongMP;
    public double ShortMP;
    public double FeesAndCommissions;
    public int PrevPosition;
    public double PrevMargin;
    public double PrevRPL;
    public double PrevUPL;
    public Price AverageOpenPrice;
    public Price TotalOpenPrice;
    public Price TotalBuyFillPrice;
    public Price TotalSellFillPrice;
    public Price DayTotalBuyFillPrice;
    public Price DayTotalSellFillPrice;
    public Price TotalOvernightPrice;
    public ContractRiskStatus RiskStatus = ContractRiskStatus.None;
    public NDateTime MarginTime;
    public double T500AlertingMargin;
    public NDateTime T500AlertingTime;

    public MsgAccountPosition2() {
        super(MessageType.AccountPosition2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.AccountID = MsgAccountPosition2.readShortString(in).toUpperCase(Locale.US);
        this.MarketID = MsgAccountPosition2.readShortString(in);
        this.Buys = MsgAccountPosition2.readInteger(in);
        this.Sells = MsgAccountPosition2.readInteger(in);
        this.WorkingBuys = MsgAccountPosition2.readInteger(in);
        this.WorkingSells = MsgAccountPosition2.readInteger(in);
        this.RPL = MsgAccountPosition2.readDouble(in);
        this.OvernightUPL = MsgAccountPosition2.readDouble(in);
        this.Margin = MsgAccountPosition2.readDouble(in);
        this.AverageOpenTicks = MsgAccountPosition2.readDouble(in);
        this.OvernightPosition = MsgAccountPosition2.readInteger(in);
        this.CurrencyRate = MsgAccountPosition2.readDouble(in);
        this.TotalBuyFillTicks = MsgAccountPosition2.readDouble(in);
        this.TotalSellFillTicks = MsgAccountPosition2.readDouble(in);
        this.TradeDate = MsgAccountPosition2.readDateTime(in);
        this.MP = MsgAccountPosition2.readDouble(in);
        this.Premium = MsgAccountPosition2.readDouble(in);
        this.TotalOpenTicks = MsgAccountPosition2.readDouble(in);
        this.TotalOpenVolume = MsgAccountPosition2.readInteger(in);
        this.FeesAndCommissions = MsgAccountPosition2.readDouble(in);
        this.LongMP = MsgAccountPosition2.readDouble(in);
        this.ShortMP = MsgAccountPosition2.readDouble(in);
        this.PrevPosition = MsgAccountPosition2.readInteger(in);
        this.PrevMargin = MsgAccountPosition2.readDouble(in);
        this.PrevRPL = MsgAccountPosition2.readDouble(in);
        this.PrevUPL = MsgAccountPosition2.readDouble(in);
        this.DayBuys = MsgAccountPosition2.readInteger(in);
        this.DaySells = MsgAccountPosition2.readInteger(in);
        if (ver > 8) {
            this.DayTotalBuyFillTicks = MsgAccountPosition2.readDouble(in);
            this.DayTotalSellFillTicks = MsgAccountPosition2.readDouble(in);
        }
        if (ver > 9) {
            this.AverageOpenPrice = MsgAccountPosition2.readPrice(in);
            this.TotalOpenPrice = MsgAccountPosition2.readPrice(in);
            this.TotalBuyFillPrice = MsgAccountPosition2.readPrice(in);
            this.TotalSellFillPrice = MsgAccountPosition2.readPrice(in);
            this.DayTotalBuyFillPrice = MsgAccountPosition2.readPrice(in);
            this.DayTotalSellFillPrice = MsgAccountPosition2.readPrice(in);
        }
        if (ver > 10) {
            MsgAccountPosition2.read7BitInteger(in);
            this.TotalOvernightPrice = MsgAccountPosition2.readPrice(in);
        }
        if (ver > 11) {
            this.RiskStatus = ContractRiskStatus.get(MsgAccountPosition2.read7BitInteger(in));
        }
        if (ver > 12) {
            this.MarginTime = MsgAccountPosition2.read7BitDateTime(in);
            this.T500AlertingMargin = MsgAccountPosition2.readDouble(in);
            this.T500AlertingTime = MsgAccountPosition2.read7BitDateTime(in);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgAccountPosition2[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("Buys: ").append(this.Buys).append(", ");
        sb.append("Sells: ").append(this.Sells).append(", ");
        sb.append("WorkingBuys: ").append(this.WorkingBuys).append(", ");
        sb.append("WorkingSells: ").append(this.WorkingSells).append(", ");
        sb.append("RPL: ").append(this.RPL).append(", ");
        sb.append("OvernightUPL: ").append(this.OvernightUPL).append(", ");
        sb.append("Margin: ").append(this.Margin).append(", ");
        sb.append("AverageOpenTicks: ").append(this.AverageOpenTicks).append(", ");
        sb.append("OvernightPosition: ").append(this.OvernightPosition).append(", ");
        sb.append("CurrencyRate: ").append(this.CurrencyRate).append(", ");
        sb.append("TotalBuyFillTicks: ").append(this.TotalBuyFillTicks).append(", ");
        sb.append("TotalSellFillTicks: ").append(this.TotalSellFillTicks).append(", ");
        sb.append("tradeDate: ").append(this.TradeDate).append(", ");
        sb.append("MP: ").append(this.MP).append(", ");
        sb.append("Premium: ").append(this.Premium).append(", ");
        sb.append("TotalOpenTicks: ").append(this.TotalOpenTicks).append(", ");
        sb.append("TotalOpenVolume: ").append(this.TotalOpenVolume).append(", ");
        sb.append("FeesAndCommissions: ").append(this.FeesAndCommissions).append(", ");
        sb.append("LongMP: ").append(this.LongMP).append(", ");
        sb.append("ShortMP: ").append(this.ShortMP).append(", ");
        sb.append("PrevPosition: ").append(this.PrevPosition).append(", ");
        sb.append("PrevMargin: ").append(this.PrevMargin).append(", ");
        sb.append("PrevRPL: ").append(this.PrevRPL).append(", ");
        sb.append("PrevUPL: ").append(this.PrevUPL).append(", ");
        sb.append("DayBuys: ").append(this.DayBuys).append(", ");
        sb.append("DaySells: ").append(this.DaySells).append(", ");
        sb.append("DayTotalBuyFillTicks: ").append(this.DayTotalBuyFillTicks).append(", ");
        sb.append("DayTotalSellFillTicks: ").append(this.DayTotalSellFillTicks).append(", ");
        sb.append("AverageOpenPrice: ").append(this.AverageOpenPrice).append(", ");
        sb.append("TotalOpenPrice: ").append(this.TotalOpenPrice).append(", ");
        sb.append("TotalBuyFillPrice: ").append(this.TotalBuyFillPrice).append(", ");
        sb.append("TotalSellFillPrice: ").append(this.TotalSellFillPrice).append(", ");
        sb.append("DayTotalBuyFillPrice: ").append(this.DayTotalBuyFillPrice).append(", ");
        sb.append("DayTotalSellFillPrice: ").append(", ");
        sb.append("RiskStatus: ").append(this.RiskStatus).append(", ");
        sb.append("MarginTime: ").append(this.MarginTime).append(", ");
        sb.append("T500AlertingMargin: ").append(this.T500AlertingMargin).append(", ");
        sb.append("T500AlertingTime: ").append(this.T500AlertingTime);
        sb.append("]");
        return sb.toString();
    }
}

