/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.definitions.AccountEnabled;
import com.t4login.definitions.AccountMarginType;
import com.t4login.definitions.AccountMode;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import com.t4login.messages.MsgAccountDetails;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class MsgAccountDetails2
extends MsgAccountDetails {
    public MsgAccountDetails2() {
        super(MessageType.AccountDetails2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.AccountID = MsgAccountDetails2.readShortString(in).toUpperCase(Locale.US);
        this.AccountName = MsgAccountDetails2.readShortString(in);
        this.Account = MsgAccountDetails2.readShortString(in);
        this.Enabled = MsgAccountDetails2.readBooleanAlt(in) ? AccountEnabled.Enabled : AccountEnabled.Disabled;
        this.Deleted = MsgAccountDetails2.readBooleanAlt(in);
        this.MaxClipSize = MsgAccountDetails2.readInteger(in);
        this.PreTradeDisabled = MsgAccountDetails2.readBooleanAlt(in);
        this.PositionRollover = MsgAccountDetails2.readBooleanAlt(in);
        this.PLRollover = MsgAccountDetails2.readBooleanAlt(in);
        this.FirmID = MsgAccountDetails2.readShortString(in).toUpperCase(Locale.US);
        this.MinBalance = MsgAccountDetails2.readDouble(in);
        this.MarginPC = MsgAccountDetails2.readIntBytes(in, 2);
        this.LossLimit = MsgAccountDetails2.readDouble(in);
        this.LossLimitPC = MsgAccountDetails2.readIntBytes(in, 2);
        this.OvernightMarginPC = MsgAccountDetails2.readIntBytes(in, 2);
        this.OrderRouting = MsgAccountDetails2.readBooleanAlt(in);
        boolean hasTimes = MsgAccountDetails2.readBooleanAlt(in);
        if (hasTimes) {
            this.ActiveTimeStart = MsgAccountDetails2.readShortString(in);
            this.ActiveTimeStop = MsgAccountDetails2.readShortString(in);
        } else {
            this.ActiveTimeStart = "";
            this.ActiveTimeStop = "";
        }
        boolean hasWarnings = MsgAccountDetails2.readBooleanAlt(in);
        if (hasWarnings) {
            this.WarningThresholdPL = MsgAccountDetails2.readIntBytes(in, 2);
            this.WarningThresholdLossLimit = MsgAccountDetails2.readIntBytes(in, 2);
            this.WarningThresholdMargin = MsgAccountDetails2.readIntBytes(in, 2);
        } else {
            this.WarningThresholdPL = -1;
            this.WarningThresholdLossLimit = -1;
            this.WarningThresholdMargin = -1;
        }
        this.Firm = MsgAccountDetails2.readShortString(in);
        this.Mode = AccountMode.get(MsgAccountDetails2.readIntBytes(in, 1));
        this.Enabled = AccountEnabled.get(MsgAccountDetails2.readIntBytes(in, 1));
        this.MaxAccountPosition = MsgAccountDetails2.readInteger(in);
        this.DayLossLimit = MsgAccountDetails2.readDouble(in);
        this.DisplayName = MsgAccountDetails2.readShortString(in);
        this.WideMarket = MsgAccountDetails2.readInteger(in);
        this.UsePLForMargin = ver > 7 ? MsgAccountDetails2.readBooleanAlt(in) : true;
        this.MarginType = ver > 8 ? AccountMarginType.get(MsgAccountDetails2.readIntBytes(in, 1)) : AccountMarginType.Spec;
        this.RiskDetails = ver > 9 ? MsgAccountDetails2.readString(in) : "";
        this.PriceBanding = ver > 10 ? MsgAccountDetails2.readInteger(in) : -1;
        this.DayLossLimitPC = ver > 11 ? MsgAccountDetails2.read7BitInteger(in) : -1;
    }
}

