/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.definitions.AccountEnabled;
import com.t4login.definitions.AccountMarginType;
import com.t4login.definitions.AccountMode;
import com.t4login.definitions.CommissionAndFees;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Locale;

public class MsgAccountDetails
extends Message {
    public String AccountID;
    public String Account;
    public String AccountName;
    public AccountEnabled Enabled;
    public boolean Deleted;
    public int MaxClipSize;
    public boolean PreTradeDisabled;
    public boolean PositionRollover;
    public boolean PLRollover;
    public String FirmID;
    public double MinBalance;
    public int MarginPC;
    public int OvernightMarginPC;
    public double LossLimit;
    public int LossLimitPC;
    public int MaxPosition;
    public boolean OrderRouting;
    public String ActiveTimeStart;
    public String ActiveTimeStop;
    public int StrategyMaxClipSize;
    public int StrategyMaxPosition;
    public int WarningThresholdPL;
    public int WarningThresholdLossLimit;
    public int WarningThresholdMargin;
    public String Firm;
    public String ParentFirmID;
    public int TotalPitTrades;
    public int StrategyTotalPitTrades;
    public AccountMode Mode;
    public boolean RiskDebug;
    public double MaxContractMargin;
    public int BlockExpiring;
    public int BlockExpiringOptions;
    public int MaxAccountPosition;
    public boolean EditMargin;
    public boolean UsePLForMargin;
    public double DayLossLimit;
    public CommissionAndFees Fees;
    public double Commission;
    public String DisplayName;
    public boolean RiskAlerts;
    public String EMail;
    public int WideMarket;
    public double MaxContractDayMargin;
    public boolean TradeImport;
    public AccountMarginType MarginType;
    public String RiskDetails;
    public int PriceBanding;
    public BigDecimal MaxDelta;
    public BigDecimal MaxWorkingLongDelta;
    public BigDecimal MaxWorkingShortDelta;
    public boolean Delayed;
    public int DayLossLimitPC;

    public MsgAccountDetails() {
        super(MessageType.AccountDetails);
    }

    protected MsgAccountDetails(MessageType msgType) {
        super(msgType);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.AccountID = MsgAccountDetails.readString(in).toUpperCase(Locale.US);
        this.AccountName = MsgAccountDetails.readString(in);
        this.Account = MsgAccountDetails.readString(in);
        this.Enabled = MsgAccountDetails.readBoolean(in) ? AccountEnabled.Enabled : AccountEnabled.Disabled;
        this.Deleted = MsgAccountDetails.readBoolean(in);
        this.MaxClipSize = MsgAccountDetails.readInteger(in);
        this.PreTradeDisabled = MsgAccountDetails.readBoolean(in);
        this.PositionRollover = MsgAccountDetails.readBoolean(in);
        this.PLRollover = MsgAccountDetails.readBoolean(in);
        this.FirmID = MsgAccountDetails.readString(in).toUpperCase(Locale.US);
        this.MinBalance = MsgAccountDetails.readDouble(in);
        this.MarginPC = MsgAccountDetails.readInteger(in);
        this.LossLimit = MsgAccountDetails.readDouble(in);
        this.LossLimitPC = MsgAccountDetails.readInteger(in);
        this.MaxPosition = MsgAccountDetails.readInteger(in);
        this.OvernightMarginPC = MsgAccountDetails.readInteger(in);
        this.OrderRouting = MsgAccountDetails.readBoolean(in);
        this.ActiveTimeStart = MsgAccountDetails.readString(in);
        this.ActiveTimeStop = MsgAccountDetails.readString(in);
        this.StrategyMaxClipSize = MsgAccountDetails.readInteger(in);
        this.StrategyMaxPosition = MsgAccountDetails.readInteger(in);
        this.WarningThresholdPL = MsgAccountDetails.readInteger(in);
        this.WarningThresholdLossLimit = MsgAccountDetails.readInteger(in);
        this.WarningThresholdMargin = MsgAccountDetails.readInteger(in);
        this.Firm = MsgAccountDetails.readString(in);
        this.ParentFirmID = MsgAccountDetails.readString(in);
        this.TotalPitTrades = MsgAccountDetails.readInteger(in);
        this.StrategyTotalPitTrades = MsgAccountDetails.readInteger(in);
        this.Mode = AccountMode.get(MsgAccountDetails.readIntBytes(in, 1));
        this.RiskDebug = MsgAccountDetails.readBooleanAlt(in);
        MsgAccountDetails.readBooleanAlt(in);
        this.MaxContractMargin = MsgAccountDetails.readDouble(in);
        this.Enabled = AccountEnabled.get(MsgAccountDetails.readIntBytes(in, 1));
        this.BlockExpiring = MsgAccountDetails.readShort(in);
        this.MaxAccountPosition = MsgAccountDetails.readInteger(in);
        this.EditMargin = MsgAccountDetails.readBooleanAlt(in);
        this.UsePLForMargin = MsgAccountDetails.readBooleanAlt(in);
        this.RiskAlerts = MsgAccountDetails.readBooleanAlt(in);
        this.DayLossLimit = MsgAccountDetails.readDouble(in);
        this.Fees = CommissionAndFees.get(MsgAccountDetails.readIntBytes(in, 1));
        this.Commission = MsgAccountDetails.readDouble(in);
        this.DisplayName = MsgAccountDetails.readString(in);
        this.EMail = MsgAccountDetails.readShortString(in);
        this.WideMarket = MsgAccountDetails.readInteger(in);
        this.MaxContractDayMargin = MsgAccountDetails.readDouble(in);
        this.TradeImport = MsgAccountDetails.readBooleanAlt(in);
        this.MarginType = AccountMarginType.get(MsgAccountDetails.readIntBytes(in, 1));
        this.BlockExpiringOptions = MsgAccountDetails.readIntBytes(in, 2);
        this.RiskDetails = MsgAccountDetails.readString(in);
        this.PriceBanding = MsgAccountDetails.readInteger(in);
        if (ver > 22) {
            MsgAccountDetails.readIntBytes(in, 1);
        }
        if (ver > 23) {
            this.MaxDelta = MsgAccountDetails.read7BitDecimal(in);
        }
        if (ver > 24) {
            this.MaxWorkingLongDelta = MsgAccountDetails.read7BitDecimal(in);
            this.MaxWorkingShortDelta = MsgAccountDetails.read7BitDecimal(in);
        }
        if (ver > 25) {
            this.Delayed = MsgAccountDetails.readBooleanAlt(in);
        }
        if (ver > 26) {
            this.DayLossLimitPC = MsgAccountDetails.read7BitInteger(in);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgAccountDetails[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("AccountName: ").append(this.AccountName).append(", ");
        sb.append("Account: ").append(this.Account).append(", ");
        sb.append("Enabled: ").append(this.Enabled).append(", ");
        sb.append("Deleted: ").append(this.Deleted).append(", ");
        sb.append("MaxClipSize: ").append(this.MaxClipSize).append(", ");
        sb.append("PreTradeDisabled: ").append(this.PreTradeDisabled).append(", ");
        sb.append("PositionRollover: ").append(this.PositionRollover).append(", ");
        sb.append("PLRollover: ").append(this.PLRollover).append(", ");
        sb.append("FirmID: ").append(this.FirmID).append(", ");
        sb.append("MinBalance: ").append(this.MinBalance).append(", ");
        sb.append("MarginPC: ").append(this.MarginPC).append(", ");
        sb.append("LossLimit: ").append(this.LossLimit).append(", ");
        sb.append("LossLimitPC: ").append(this.LossLimitPC).append(", ");
        sb.append("MaxPosition: ").append(this.MaxPosition).append(", ");
        sb.append("OvernightMarginPC: ").append(this.OvernightMarginPC).append(", ");
        sb.append("OrderRouting: ").append(this.OrderRouting).append(", ");
        sb.append("ActiveTimeStart: ").append(this.ActiveTimeStart).append(", ");
        sb.append("ActiveTimeStop: ").append(this.ActiveTimeStop).append(", ");
        sb.append("StrategyMaxClipSize: ").append(this.StrategyMaxClipSize).append(", ");
        sb.append("StrategyMaxPosition: ").append(this.StrategyMaxPosition).append(", ");
        sb.append("WarningThresholdPL: ").append(this.WarningThresholdPL).append(", ");
        sb.append("WarningThresholdLossLimit: ").append(this.WarningThresholdLossLimit).append(", ");
        sb.append("WarningThresholdMargin: ").append(this.WarningThresholdMargin).append(", ");
        sb.append("Firm: ").append(this.Firm).append(", ");
        sb.append("ParentFirmID: ").append(this.ParentFirmID).append(", ");
        sb.append("TotalPitTrades: ").append(this.TotalPitTrades).append(", ");
        sb.append("StrategyTotalPitTrades: ").append(this.StrategyTotalPitTrades).append(", ");
        sb.append("Mode: ").append(this.Mode).append(", ");
        sb.append("RiskDebug: ").append(this.RiskDebug).append(", ");
        sb.append("MaxContractMargin: ").append(this.MaxContractMargin).append(", ");
        sb.append("Enabled: ").append(this.Enabled).append(", ");
        sb.append("BlockExpiring: ").append(this.BlockExpiring).append(", ");
        sb.append("BlockExpiringOptions: ").append(this.BlockExpiringOptions).append(", ");
        sb.append("MaxAccountPosition: ").append(this.MaxAccountPosition).append(", ");
        sb.append("EditMargin: ").append(this.EditMargin).append(", ");
        sb.append("UsePLForMargin: ").append(this.UsePLForMargin).append(", ");
        sb.append("RiskAlerts: ").append(this.RiskAlerts).append(", ");
        sb.append("DayLossLimit: ").append(this.DayLossLimit).append(", ");
        sb.append("Fees: ").append(this.Fees).append(", ");
        sb.append("Commission: ").append(this.Commission).append(", ");
        sb.append("DisplayName: ").append(this.DisplayName).append(", ");
        sb.append("EMail: ").append(this.EMail).append(", ");
        sb.append("WideMarket: ").append(this.WideMarket).append(", ");
        sb.append("PriceBanding: ").append(this.PriceBanding).append(", ");
        sb.append("MaxContractDayMargin: ").append(this.MaxContractDayMargin).append(", ");
        sb.append("TradeImport: ").append(this.TradeImport).append(", ");
        sb.append("MarginType: ").append(this.MarginType).append(", ");
        sb.append("RiskDetails: ").append(this.RiskDetails).append(", ");
        sb.append("DayLossLimitPC: ").append(this.DayLossLimitPC).append(", ");
        sb.append("Delayed: ").append(this.Delayed);
        sb.append("]");
        return sb.toString();
    }
}

