/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.messages.MessageCategory;
import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    SignalMessage(-1, MessageCategory.None, 1),
    Heartbeat(0, MessageCategory.Misc, 1),
    HeartbeatResponse(1, MessageCategory.Misc, 1),
    Disconnecting(2, MessageCategory.Misc, 1),
    Login(10, MessageCategory.Misc, 17, 17),
    TwoFactorAuthentication(11, MessageCategory.Misc, 3, 1),
    UserSettings(14, MessageCategory.Misc, 5),
    ConnectionSettings(15, MessageCategory.Misc, 3),
    ChangePassword(17, MessageCategory.Misc, 2, 1),
    ChangePasswordResponse(18, MessageCategory.Misc, 1),
    LoginResponse2(19, MessageCategory.Misc, 10, 7),
    Notification(20, MessageCategory.Misc, 3),
    ChangeSSI(30, MessageCategory.Misc, 1),
    ChangeSSIResponse(31, MessageCategory.Misc, 1),
    SSIChallenge(32, MessageCategory.Misc, 1),
    IdentityStatusUpdate(40, MessageCategory.Misc, 2),
    MessageArray(50, MessageCategory.None, 1),
    Compressed(51, MessageCategory.None, 1),
    AccountDetails(101, MessageCategory.Account, 27),
    AccountSubscribe(102, MessageCategory.Account, 4),
    AccountDayChange(105, MessageCategory.Account, 2),
    AccountNotify(108, MessageCategory.Account, 2),
    AccountComplete(122, MessageCategory.Account, 1),
    AccountCurrency(124, MessageCategory.Account, 2),
    AccountDetails2(127, MessageCategory.Account, 12),
    AccountUpdate2(128, MessageCategory.Account, 14),
    AccountPosition2(129, MessageCategory.Account, 13),
    AccountSnapshot(130, MessageCategory.Account, 1),
    FirmContract(151, MessageCategory.Account, 7),
    FirmClearingExchange(154, MessageCategory.Account, 1),
    FirmSnapshot(155, MessageCategory.Account, 2),
    OrderPerformance3(208, MessageCategory.Order, 1),
    OrderUpdateMulti(210, MessageCategory.Order, 1),
    OrderUpdate(211, MessageCategory.Order, 17, 11),
    OrderUpdateFailed(212, MessageCategory.Order, 4, 3),
    OrderUpdateStatus(213, MessageCategory.Order, 16, 10),
    OrderUpdateTrade(214, MessageCategory.Order, 4, 2),
    OrderHistoryRequest(215, MessageCategory.Order, 2),
    OrderUpdateTradeLeg(217, MessageCategory.Order, 4, 2),
    OrderUpdateMulti2(240, MessageCategory.Order, 1),
    OrderUpdate2(241, MessageCategory.Order, 12, 7),
    OrderUpdateFailed2(242, MessageCategory.Order, 4, 3),
    OrderUpdateStatus2(243, MessageCategory.Order, 13, 6),
    OrderUpdateTrade2(244, MessageCategory.Order, 4, 2),
    OrderUpdateTradeLeg2(245, MessageCategory.Order, 4, 2),
    OrderSubmission2(250, MessageCategory.Order, 10),
    OrderRevision2(251, MessageCategory.Order, 10),
    OrderPull2(252, MessageCategory.Order, 4, 3),
    OrderHistory2(253, MessageCategory.Order, 1),
    OrderHistoryItem2(254, MessageCategory.Order, 9, 5),
    OrderUpdateD(261, MessageCategory.Order, 3),
    OrderUpdateMultiD(262, MessageCategory.Order, 1, 1),
    OrderUpdateFailedD(263, MessageCategory.Order, 1, 1),
    OrderUpdateStatusD(264, MessageCategory.Order, 1, 1),
    OrderUpdateTradeD(265, MessageCategory.Order, 1, 1),
    OrderUpdateTradeLegD(266, MessageCategory.Order, 1, 1),
    ContractRequest(303, MessageCategory.Depth, 1),
    ContractDetailsMulti(305, MessageCategory.Depth, 1),
    ContractDetails2(312, MessageCategory.Depth, 14, 13),
    MarketDetails(400, MessageCategory.Depth, 17),
    MarketDetailsMulti(401, MessageCategory.Depth, 3),
    MarketDepthSubscribe(402, MessageCategory.Depth, 7),
    MarketDepthSubscribeReject(403, MessageCategory.Depth, 1),
    MarketSettlement(407, MessageCategory.Depth, 10, 7),
    MarketFilterRequest(411, MessageCategory.Depth, 2),
    MarketTradeVolume(412, MessageCategory.Depth, 4, 3),
    MarketTradeHistory(414, MessageCategory.Depth, 4, 3),
    MarketDepth2(415, MessageCategory.Depth, 9, 8),
    MarketIdent(416, MessageCategory.Depth, 1),
    MarketSettlement2(417, MessageCategory.Depth, 9, 7),
    MarketHighLow2(418, MessageCategory.Depth, 4, 3),
    MarketPriceLimits(419, MessageCategory.Depth, 5, 4),
    MarketDepthTrade2(420, MessageCategory.Depth, 6, 3),
    MarketSnapshot(422, MessageCategory.Depth, 2),
    CreateUDS(424, MessageCategory.Order, 2, 2),
    CreateUDSResponse(425, MessageCategory.Order, 2, 2),
    MarketDepthD(427, MessageCategory.Depth, 3),
    MarketDepthTradeD(428, MessageCategory.Depth, 1, 1),
    MarketSettlementD(429, MessageCategory.Depth, 1, 1),
    MarketHighLowD(430, MessageCategory.Depth, 1, 1),
    MarketTradeVolumeD(431, MessageCategory.Depth, 1, 1),
    MarketTradeHistoryD(432, MessageCategory.Depth, 1, 1),
    MarketPriceLimitsD(433, MessageCategory.Depth, 1, 1),
    MarketSnapshotD(434, MessageCategory.Depth, 1, 1),
    MarketByOrderSubscribe(440, MessageCategory.Depth, 1),
    MarketByOrderReject(441, MessageCategory.Depth, 1),
    MarketByOrderSnapshot(442, MessageCategory.Depth, 1),
    MarketByOrderUpdate(443, MessageCategory.Depth, 1),
    ChartContractDataRequest(452, MessageCategory.Misc, 1),
    ChartContractData(453, MessageCategory.Misc, 4),
    ChartDataBatchRequest(457, MessageCategory.Misc, 2),
    ChartDataBatch(458, MessageCategory.Misc, 6),
    ChartCacheGenerationRequest(461, MessageCategory.Misc, 1),
    ChartCacheGeneration(462, MessageCategory.Misc, 2, 1),
    ChartAggregatedDataRequest(463, MessageCategory.Misc, 1, 1),
    ChartAggregatedData(464, MessageCategory.Misc, 1, 1),
    UserMessagingToken(875, MessageCategory.Automation, 1),
    BannerRefresh(900, MessageCategory.Misc, 1),
    AuthenticationTokenRequest(10000, MessageCategory.Misc, 1),
    AuthenticationTokenResponse(10001, MessageCategory.Misc, 1);

    private final int value;
    private MessageCategory category;
    private final short version;
    private final short minSupportedVersion;
    private static Map<Integer, MessageType> map;

    private MessageType(int value, MessageCategory category, short version) {
        this.value = value;
        this.category = category;
        this.version = version;
        this.minSupportedVersion = version;
    }

    private MessageType(int value, MessageCategory category, short version, short minVersion) {
        this.value = value;
        this.category = category;
        this.version = version;
        this.minSupportedVersion = minVersion;
    }

    public int getValue() {
        return this.value;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public short getVersion() {
        return this.version;
    }

    public short getMinSupportedVersion() {
        return this.minSupportedVersion;
    }

    public static MessageType get(int value) {
        return map.get(value);
    }

    static {
        map = new HashMap<Integer, MessageType>();
        for (MessageType t : MessageType.values()) {
            map.put(t.getValue(), t);
        }
    }
}

