/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.messages.Message;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MessageArray
extends Message
implements Iterable<Message> {
    private final List<Message> messages = new ArrayList<Message>();

    public MessageArray() {
        super(MessageType.MessageArray);
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException {
        this.messages.clear();
        int numMessages = MessageArray.readShort(in);
        for (int i = 0; i < numMessages; ++i) {
            Message msg = Message.getMessage(in);
            if (msg == null) continue;
            this.messages.add(msg);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageArray.writeShort(out, (short)this.messages.size());
        for (Message msg : this.messages) {
            MessageArray.writeShort(out, (short)msg.getMessageType().getValue());
            MessageArray.writeShort(out, msg.getMessageType().getVersion());
            byte[] msgData = msg.getBytes();
            MessageArray.writeInteger(out, msgData.length);
            out.write(msgData);
        }
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean verbose = false;
        if (verbose) {
            sb.append("MsgArray[");
            for (Message msg : this.messages) {
                sb.append("\n");
                sb.append("   Message.").append(msg.toString());
            }
            sb.append("]");
        } else {
            sb.append("MsgArray[");
            sb.append("count: ").append(this.messages.size());
            HashMap<MessageType, Integer> msgtypes = new HashMap<MessageType, Integer>();
            for (Message msg : this.messages) {
                MessageType typ = msg.getMessageType();
                if (msgtypes.containsKey((Object)typ)) {
                    msgtypes.put(typ, (Integer)msgtypes.get((Object)typ) + 1);
                    continue;
                }
                msgtypes.put(typ, 1);
            }
            for (MessageType typ : msgtypes.keySet()) {
                sb.append(", ");
                sb.append(typ.name()).append("(").append(msgtypes.get((Object)typ)).append(")");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }
}

