/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.Log;
import com.t4login.connection.CountingInputStream;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MessageArray;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import com.t4login.messages.Msg2FactorAuthentication;
import com.t4login.messages.MsgAccountCurrency;
import com.t4login.messages.MsgAccountDayChange;
import com.t4login.messages.MsgAccountDetails;
import com.t4login.messages.MsgAccountDetails2;
import com.t4login.messages.MsgAccountNotify;
import com.t4login.messages.MsgAccountPosition2;
import com.t4login.messages.MsgAccountSnapshot;
import com.t4login.messages.MsgAccountUpdate2;
import com.t4login.messages.MsgAuthenticationTokenResponse;
import com.t4login.messages.MsgBannerRefresh;
import com.t4login.messages.MsgChangePassword;
import com.t4login.messages.MsgChangePasswordResponse;
import com.t4login.messages.MsgChangeSSI;
import com.t4login.messages.MsgChangeSSIResponse;
import com.t4login.messages.MsgChartAggregatedData;
import com.t4login.messages.MsgChartAggregatedDataRequest;
import com.t4login.messages.MsgChartCacheGeneration;
import com.t4login.messages.MsgChartCacheGenerationRequest;
import com.t4login.messages.MsgChartContractData;
import com.t4login.messages.MsgChartContractDataRequest;
import com.t4login.messages.MsgChartDataBatch;
import com.t4login.messages.MsgChartDataBatchRequest;
import com.t4login.messages.MsgCompressed;
import com.t4login.messages.MsgConnectionSettings;
import com.t4login.messages.MsgContractDetails2;
import com.t4login.messages.MsgContractDetailsMulti;
import com.t4login.messages.MsgCreateUDS;
import com.t4login.messages.MsgCreateUDSResponse;
import com.t4login.messages.MsgDisconnecting;
import com.t4login.messages.MsgFirmClearingExchange;
import com.t4login.messages.MsgFirmContract;
import com.t4login.messages.MsgFirmSnapshot;
import com.t4login.messages.MsgHeartbeat;
import com.t4login.messages.MsgHeartbeatResponse;
import com.t4login.messages.MsgIdentityStatusUpdate;
import com.t4login.messages.MsgLogin;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgMarketByOrderReject;
import com.t4login.messages.MsgMarketByOrderSnapshot;
import com.t4login.messages.MsgMarketByOrderSubscribe;
import com.t4login.messages.MsgMarketByOrderUpdate;
import com.t4login.messages.MsgMarketDepthD;
import com.t4login.messages.MsgMarketDepthSubscribeReject;
import com.t4login.messages.MsgMarketDepthTradeD;
import com.t4login.messages.MsgMarketDetails;
import com.t4login.messages.MsgMarketDetailsMulti;
import com.t4login.messages.MsgMarketHighLowD;
import com.t4login.messages.MsgMarketIdent;
import com.t4login.messages.MsgMarketPriceLimitsD;
import com.t4login.messages.MsgMarketSettlementD;
import com.t4login.messages.MsgMarketSnapshotD;
import com.t4login.messages.MsgMarketTradeHistoryD;
import com.t4login.messages.MsgMarketTradeVolumeD;
import com.t4login.messages.MsgNotification;
import com.t4login.messages.MsgOrderHistory2;
import com.t4login.messages.MsgOrderHistoryItem2;
import com.t4login.messages.MsgOrderHistoryRequest;
import com.t4login.messages.MsgOrderPerformance3;
import com.t4login.messages.MsgOrderPull2;
import com.t4login.messages.MsgOrderRevision2;
import com.t4login.messages.MsgOrderSubmission2;
import com.t4login.messages.MsgOrderUpdateD;
import com.t4login.messages.MsgOrderUpdateFailedD;
import com.t4login.messages.MsgOrderUpdateMultiD;
import com.t4login.messages.MsgOrderUpdateStatusD;
import com.t4login.messages.MsgOrderUpdateTradeD;
import com.t4login.messages.MsgOrderUpdateTradeLegD;
import com.t4login.messages.MsgSSIChallenge;
import com.t4login.messages.MsgUserMessagingToken;
import com.t4login.messages.MsgUserSettings;
import com.t4login.util.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Message {
    private static final String TAG = "T4Android.Message";
    private final MessageType mMessageType;
    private short mMessageVersion = (short)-1;
    public String TagData1 = "";
    public String TagData2 = "";
    public String TagData3 = "";
    public static final int INT_SIZE_BYTE = 1;
    public static final int INT_SIZE_SHORT = 2;
    public static final int INT_SIZE_INT = 4;
    public static final int INT_SIZE_LONG = 8;

    public static Message getMessage(MessageType type, short ver, InputStream in) throws IOException {
        Message msg = null;
        switch (type) {
            case Heartbeat: {
                msg = new MsgHeartbeat();
                break;
            }
            case HeartbeatResponse: {
                msg = new MsgHeartbeatResponse();
                break;
            }
            case Disconnecting: {
                msg = new MsgDisconnecting();
                break;
            }
            case Login: {
                msg = new MsgLogin();
                break;
            }
            case TwoFactorAuthentication: {
                msg = new Msg2FactorAuthentication();
                break;
            }
            case UserSettings: {
                msg = new MsgUserSettings();
                break;
            }
            case ConnectionSettings: {
                msg = new MsgConnectionSettings();
                break;
            }
            case ChangePassword: {
                msg = new MsgChangePassword();
                break;
            }
            case ChangePasswordResponse: {
                msg = new MsgChangePasswordResponse();
                break;
            }
            case LoginResponse2: {
                msg = new MsgLoginResponse2();
                break;
            }
            case Notification: {
                msg = new MsgNotification();
                break;
            }
            case ChangeSSI: {
                msg = new MsgChangeSSI();
                break;
            }
            case ChangeSSIResponse: {
                msg = new MsgChangeSSIResponse();
                break;
            }
            case SSIChallenge: {
                msg = new MsgSSIChallenge();
                break;
            }
            case IdentityStatusUpdate: {
                msg = new MsgIdentityStatusUpdate();
                break;
            }
            case MessageArray: {
                msg = new MessageArray();
                break;
            }
            case Compressed: {
                msg = new MsgCompressed();
                break;
            }
            case AccountDetails: {
                msg = new MsgAccountDetails();
                break;
            }
            case AccountDayChange: {
                msg = new MsgAccountDayChange();
                break;
            }
            case AccountNotify: {
                msg = new MsgAccountNotify();
                break;
            }
            case AccountCurrency: {
                msg = new MsgAccountCurrency();
                break;
            }
            case AccountDetails2: {
                msg = new MsgAccountDetails2();
                break;
            }
            case AccountUpdate2: {
                msg = new MsgAccountUpdate2();
                break;
            }
            case AccountPosition2: {
                msg = new MsgAccountPosition2();
                break;
            }
            case AccountSnapshot: {
                msg = new MsgAccountSnapshot();
                break;
            }
            case FirmContract: {
                msg = new MsgFirmContract();
                break;
            }
            case FirmClearingExchange: {
                msg = new MsgFirmClearingExchange();
                break;
            }
            case FirmSnapshot: {
                msg = new MsgFirmSnapshot();
                break;
            }
            case OrderPerformance3: {
                msg = new MsgOrderPerformance3();
                break;
            }
            case OrderHistoryRequest: {
                msg = new MsgOrderHistoryRequest();
                break;
            }
            case OrderSubmission2: {
                msg = new MsgOrderSubmission2();
                break;
            }
            case OrderRevision2: {
                msg = new MsgOrderRevision2();
                break;
            }
            case OrderPull2: {
                msg = new MsgOrderPull2();
                break;
            }
            case OrderHistory2: {
                msg = new MsgOrderHistory2();
                break;
            }
            case OrderHistoryItem2: {
                msg = new MsgOrderHistoryItem2();
                break;
            }
            case OrderUpdateD: {
                msg = new MsgOrderUpdateD();
                break;
            }
            case OrderUpdateMultiD: {
                msg = new MsgOrderUpdateMultiD();
                break;
            }
            case OrderUpdateFailedD: {
                msg = new MsgOrderUpdateFailedD();
                break;
            }
            case OrderUpdateStatusD: {
                msg = new MsgOrderUpdateStatusD();
                break;
            }
            case OrderUpdateTradeD: {
                msg = new MsgOrderUpdateTradeD();
                break;
            }
            case OrderUpdateTradeLegD: {
                msg = new MsgOrderUpdateTradeLegD();
                break;
            }
            case ContractDetailsMulti: {
                msg = new MsgContractDetailsMulti();
                break;
            }
            case ContractDetails2: {
                msg = new MsgContractDetails2();
                break;
            }
            case MarketDetails: {
                msg = new MsgMarketDetails();
                break;
            }
            case MarketDetailsMulti: {
                msg = new MsgMarketDetailsMulti();
                break;
            }
            case MarketDepthSubscribeReject: {
                msg = new MsgMarketDepthSubscribeReject();
                break;
            }
            case MarketIdent: {
                msg = new MsgMarketIdent();
                break;
            }
            case CreateUDS: {
                msg = new MsgCreateUDS();
                break;
            }
            case CreateUDSResponse: {
                msg = new MsgCreateUDSResponse();
                break;
            }
            case MarketDepthD: {
                msg = new MsgMarketDepthD();
                break;
            }
            case MarketDepthTradeD: {
                msg = new MsgMarketDepthTradeD();
                break;
            }
            case MarketSettlementD: {
                msg = new MsgMarketSettlementD();
                break;
            }
            case MarketHighLowD: {
                msg = new MsgMarketHighLowD();
                break;
            }
            case MarketTradeVolumeD: {
                msg = new MsgMarketTradeVolumeD();
                break;
            }
            case MarketTradeHistoryD: {
                msg = new MsgMarketTradeHistoryD();
                break;
            }
            case MarketPriceLimitsD: {
                msg = new MsgMarketPriceLimitsD();
                break;
            }
            case MarketSnapshotD: {
                msg = new MsgMarketSnapshotD();
                break;
            }
            case MarketByOrderSubscribe: {
                msg = new MsgMarketByOrderSubscribe();
                break;
            }
            case MarketByOrderReject: {
                msg = new MsgMarketByOrderReject();
                break;
            }
            case MarketByOrderSnapshot: {
                msg = new MsgMarketByOrderSnapshot();
                break;
            }
            case MarketByOrderUpdate: {
                msg = new MsgMarketByOrderUpdate();
                break;
            }
            case ChartContractDataRequest: {
                msg = new MsgChartContractDataRequest();
                break;
            }
            case ChartContractData: {
                msg = new MsgChartContractData();
                break;
            }
            case ChartDataBatchRequest: {
                msg = new MsgChartDataBatchRequest();
                break;
            }
            case ChartDataBatch: {
                msg = new MsgChartDataBatch();
                break;
            }
            case ChartCacheGenerationRequest: {
                msg = new MsgChartCacheGenerationRequest();
                break;
            }
            case ChartCacheGeneration: {
                msg = new MsgChartCacheGeneration();
                break;
            }
            case ChartAggregatedDataRequest: {
                msg = new MsgChartAggregatedDataRequest();
                break;
            }
            case ChartAggregatedData: {
                msg = new MsgChartAggregatedData();
                break;
            }
            case UserMessagingToken: {
                msg = new MsgUserMessagingToken();
                break;
            }
            case AuthenticationTokenResponse: {
                msg = new MsgAuthenticationTokenResponse();
                break;
            }
            case AccountComplete: 
            case OrderUpdateMulti: 
            case OrderUpdate: 
            case OrderUpdateFailed: 
            case OrderUpdateStatus: 
            case OrderUpdateTrade: 
            case OrderUpdateTradeLeg: 
            case OrderUpdateMulti2: 
            case OrderUpdate2: 
            case OrderUpdateFailed2: 
            case OrderUpdateStatus2: 
            case OrderUpdateTrade2: 
            case OrderUpdateTradeLeg2: 
            case MarketTradeVolume: 
            case MarketTradeHistory: 
            case MarketDepth2: 
            case MarketSettlement: 
            case MarketSettlement2: 
            case MarketHighLow2: 
            case MarketPriceLimits: 
            case MarketDepthTrade2: 
            case MarketSnapshot: {
                Log.e(TAG, "Message.getMessage(), Deprecated message recieved from server: %s", new Object[]{type});
                break;
            }
            case BannerRefresh: {
                msg = new MsgBannerRefresh();
                break;
            }
            default: {
                Log.e(TAG, "Message type '" + String.valueOf((Object)type) + "' not implemented in Message.getMessage()");
            }
        }
        if (msg != null) {
            msg.mMessageVersion = ver;
            try {
                msg.parseMessage(ver, in);
            }
            catch (MessageDecodingNotSupported | MessageVersionNotSupportedException vex) {
                Log.e(TAG, vex.getMessage());
                return null;
            }
        }
        return msg;
    }

    public static Message getMessage(MessageType type, short ver, byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return Message.getMessage(type, ver, in);
    }

    public static void writeMessage(OutputStream out, Message msg) throws IOException {
        Message.writeShort(out, (short)msg.getMessageType().getValue());
        Message.writeShort(out, msg.getMessageType().getVersion());
        byte[] msgData = msg.getBytes();
        Message.writeInteger(out, msgData.length);
        out.write(msgData);
    }

    public static Message getMessage(InputStream in) throws IOException {
        long msgBytesRead;
        CountingInputStream in2 = new CountingInputStream(in);
        short msgTypeVal = Message.readShort(in2);
        MessageType msgType = MessageType.get(msgTypeVal);
        short msgVer = Message.readShort(in2);
        int msgLen = Message.readInteger(in2);
        in2.resetCount();
        Message msg = null;
        if (msgType != null) {
            msg = Message.getMessage(msgType, msgVer, in2);
        }
        if ((msgBytesRead = in2.getCount()) < (long)msgLen) {
            in2.skip((long)msgLen - msgBytesRead);
        }
        if (msg == null) {
            Log.e(TAG, "Message type '" + msgTypeVal + "' not implemented in Message.getMessage()");
        }
        return msg;
    }

    public static Message getMessage2(InputStream in) throws IOException {
        long msgBytesRead;
        CountingInputStream in2 = new CountingInputStream(in);
        int msgTypeVal = Message.read7BitInteger(in2);
        MessageType msgType = MessageType.get(msgTypeVal);
        short msgVer = (short)Message.read7BitInteger(in2);
        int msgLen = Message.read7BitInteger(in2);
        in2.resetCount();
        Message msg = null;
        if (msgType != null) {
            msg = Message.getMessage(msgType, msgVer, in2);
        }
        if ((msgBytesRead = in2.getCount()) < (long)msgLen) {
            in2.skip((long)msgLen - msgBytesRead);
        }
        if (msg == null) {
            Log.e(TAG, "getMessage2(), Message type '" + msgTypeVal + "' not implemented in Message.getMessage()");
        }
        return msg;
    }

    protected Message(MessageType typ) {
        this.mMessageType = typ;
    }

    public MessageType getMessageType() {
        return this.mMessageType;
    }

    public short getVersion() {
        if (this.mMessageVersion >= 0) {
            return this.mMessageVersion;
        }
        return this.mMessageType.getVersion();
    }

    public byte[] getBytes() {
        return this.buildMessage();
    }

    private void parseMessage(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        this.parseMessageStream(ver, in);
    }

    private byte[] buildMessage() {
        byte[] msg = null;
        try {
            msg = this.buildMessageBytes();
        }
        catch (MessageEncodingNotSupported encexex) {
            Log.e(this.mMessageType.name(), "buildMessageBytes(), Encoding Error", encexex);
        }
        catch (IOException ioex) {
            Log.e(this.mMessageType.name(), "buildMessageBytes(), IO Error", ioex);
        }
        catch (Exception ex) {
            Log.e(this.mMessageType.name(), "buildMessageBytes(), Error", ex);
        }
        return msg;
    }

    protected abstract void parseMessageStream(short var1, InputStream var2) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported;

    protected abstract byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported;

    public static int fillBuffer(InputStream in, byte[] buffer) throws IOException {
        int len;
        int off = 0;
        for (int nread = buffer.length; nread > 0; nread -= len) {
            len = in.read(buffer, off, nread);
            if (len < 0) {
                return len;
            }
            off += len;
        }
        return off;
    }

    public static String readString(InputStream in) throws IOException {
        int len = Message.read7BitInteger(in);
        byte[] buffer = new byte[len];
        if (Message.fillBuffer(in, buffer) < 0) {
            throw new IOException("EOF");
        }
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public static void writeString(OutputStream out, String string) throws IOException {
        if (string != null) {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            Message.write7BitInteger(bytes.length, out);
            out.write(bytes);
        } else {
            Message.write7BitInteger(0, out);
        }
    }

    public static short readShort(InputStream in) throws IOException {
        byte[] buffer = new byte[2];
        if (Message.fillBuffer(in, buffer) < 0) {
            throw new IOException("EOF");
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.position(0);
        return bb.getShort();
    }

    public static void writeShort(OutputStream out, short value) throws IOException {
        byte[] buffer = new byte[]{(byte)value, (byte)(value >> 8)};
        out.write(buffer);
    }

    public static int readInteger(InputStream in) throws IOException {
        byte[] buffer = new byte[4];
        if (Message.fillBuffer(in, buffer) < 0) {
            throw new IOException("EOF");
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.position(0);
        return bb.getInt();
    }

    public static void writeInteger(OutputStream out, int value) throws IOException {
        byte[] buffer = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        out.write(buffer);
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] buffer = new byte[8];
        if (Message.fillBuffer(in, buffer) < 0) {
            throw new IOException("EOF");
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.position(0);
        return bb.getLong();
    }

    public static void writeLong(OutputStream out, long value) throws IOException {
        byte[] buffer = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
        out.write(buffer);
    }

    public static double readDouble(InputStream in) throws IOException {
        byte[] buffer = new byte[8];
        if (Message.fillBuffer(in, buffer) < 0) {
            throw new IOException("EOF");
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.position(0);
        return bb.getDouble();
    }

    public static void writeDouble(OutputStream out, double value) throws IOException {
        byte[] buffer = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putDouble(value);
        out.write(buffer);
    }

    public static int readIntBytes(InputStream in, int bytes) throws IOException {
        switch (bytes) {
            case 1: {
                int v = in.read();
                return v -= 128;
            }
            case 2: {
                return Message.readShort(in);
            }
            case 4: {
                return Message.readInteger(in);
            }
            case 8: {
                return (int)Message.readLong(in);
            }
        }
        throw new IOException("Invalid number of bytes specified.");
    }

    protected void writeIntBytes(OutputStream out, int value, int bytes) throws IOException {
        switch (bytes) {
            case 1: {
                out.write((byte)value + 128);
                break;
            }
            case 2: {
                Message.writeShort(out, (short)value);
                break;
            }
            case 4: {
                Message.writeInteger(out, value);
                break;
            }
            case 8: {
                Message.writeLong(out, value);
                break;
            }
            default: {
                throw new IOException("Invalid number of bytes specified.");
            }
        }
    }

    public static String readShortString(InputStream in) throws IOException {
        int len = in.read();
        byte[] buffer = new byte[len];
        if (Message.fillBuffer(in, buffer) < 0) {
            throw new IOException("EOF");
        }
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public static void writeShortString(OutputStream out, String value) throws IOException {
        value = value == null ? "" : value;
        value = value.substring(0, Math.min(255, value.length()));
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        out.write(bytes.length);
        out.write(bytes);
    }

    protected String readMediumString(InputStream in) throws IOException {
        int len = Message.readIntBytes(in, 2);
        if (len > 0) {
            byte[] buffer = new byte[len];
            if (Message.fillBuffer(in, buffer) < 0) {
                throw new IOException("EOF");
            }
            return new String(buffer, StandardCharsets.UTF_8);
        }
        return "";
    }

    protected void writeMediumString(OutputStream out, String value) throws IOException {
        value = value == null ? "" : value;
        value = value.substring(0, Math.min(65535, value.length()));
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeIntBytes(out, bytes.length, 2);
        out.write(bytes);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        return in.read() != 0;
    }

    public static void writeBoolean(OutputStream out, boolean value) throws IOException {
        out.write(value ? 1 : 0);
    }

    public static boolean readBooleanAlt(InputStream in) throws IOException {
        return in.read() == 0;
    }

    public static void writeBooleanAlt(OutputStream out, boolean value) throws IOException {
        out.write(value ? 0 : 1);
    }

    public static NDateTime readDateTime(InputStream in) throws IOException {
        long ticks = Message.readLong(in);
        return new NDateTime(ticks);
    }

    public static void writeDateTime(OutputStream out, NDateTime value) throws IOException {
        if (value == null) {
            Message.writeLong(out, 0L);
        } else {
            Message.writeLong(out, value.getTicks());
        }
    }

    public static NDateTime read7BitDateTime(InputStream in) throws IOException {
        long timeTicks = Message.read7BitLong(in);
        return new NDateTime(timeTicks);
    }

    public static NDateTime read7BitDateTime(InputStream in, NDateTime ref) throws IOException {
        long timeTicks = Message.read7BitLong(in);
        return new NDateTime(timeTicks + ref.getTicks());
    }

    public static void write7BitDateTime(NDateTime value, OutputStream out) throws IOException {
        Message.write7BitLong(value.getTicks(), out);
    }

    public static int read7BitInteger(InputStream in) throws IOException {
        int count = 0;
        int shift = 0;
        boolean more = true;
        while (more) {
            byte b = (byte)in.read();
            count |= (b & 0x7F) << shift;
            shift += 7;
            if ((b & 0x80) != 0) continue;
            more = false;
        }
        return count;
    }

    public static void write7BitInteger(int value, OutputStream out) throws IOException {
        long v;
        for (v = (long)value; v >= 128L; v >>= 7) {
            out.write((byte)(v | 0x80L));
        }
        out.write((byte)v);
    }

    public static long read7BitLong(InputStream in) throws IOException {
        byte b;
        long count = 0L;
        long shift = 0L;
        do {
            b = (byte)in.read();
            count |= (long)(b & 0x7F) << (int)shift;
            shift += 7L;
        } while ((b & 0x80) != 0);
        return count;
    }

    public static void write7BitLong(long value, OutputStream out) throws IOException {
        if (value >= 0L) {
            while (value >= 128L) {
                out.write((byte)(value | 0x80L));
                value >>= 7;
            }
            out.write((byte)value);
        } else {
            out.write((byte)(value | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) | 0x80L));
            out.write((byte)((value >>= 7) & 0xFL));
        }
    }

    public static BigInteger read7BitULong(InputStream in) throws IOException {
        byte b;
        long count = 0L;
        long shift = 0L;
        do {
            b = (byte)in.read();
            count |= (long)(b & 0x7F) << (int)shift;
            shift += 7L;
        } while ((b & 0x80) != 0);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(count);
        byte[] valueBytes = buffer.array();
        return new BigInteger(1, valueBytes);
    }

    public static int[] readIntegerArray(InputStream in) throws IOException {
        int n = Message.read7BitInteger(in);
        int[] values = new int[n];
        for (int i = 0; i < n; ++i) {
            values[i] = Message.read7BitInteger(in);
        }
        return values;
    }

    public static void writeIntegerArray(OutputStream out, int[] values) throws IOException {
        if (values == null) {
            Message.write7BitInteger(0, out);
        } else {
            Message.write7BitInteger(values.length, out);
            for (int v : values) {
                Message.write7BitInteger(v, out);
            }
        }
    }

    public static Price readPrice(InputStream in) throws IOException {
        String stringValue = Message.readShortString(in);
        try {
            if (!stringValue.isEmpty()) {
                BigDecimal decValue = new BigDecimal(stringValue).setScale(18, 6);
                return new Price(decValue);
            }
            return null;
        }
        catch (Exception ex) {
            Log.e(TAG, "readPrice(), Error converting '" + stringValue + "' to a price.");
            throw ex;
        }
    }

    public static void writePrice(OutputStream out, Price value) throws IOException {
        if (value != null) {
            String stringValue = value.getDecimalValue().stripTrailingZeros().toPlainString();
            Message.writeShortString(out, stringValue);
        } else {
            Message.writeShortString(out, "");
        }
    }

    public static Price read7BitPrice(InputStream in) throws IOException {
        return new Price(EncodingUtil.decodeDecimal(in));
    }

    public static void write7BitPrice(Price value, OutputStream out) throws IOException {
        EncodingUtil.encodeDecimal(value.getDecimalValue(), out);
    }

    public static Price read7BitPriceN(InputStream in) throws IOException {
        int hdr = in.read();
        if ((hdr & 1) == 1) {
            return new Price(EncodingUtil.decodeDecimal(in));
        }
        return null;
    }

    public static void write7BitPriceN(Price value, OutputStream out) throws IOException {
        if (value != null) {
            out.write(1);
            EncodingUtil.encodeDecimal(value.getDecimalValue(), out);
        } else {
            out.write(0);
        }
    }

    public static BigDecimal read7BitDecimal(InputStream in) throws IOException {
        return EncodingUtil.decodeDecimal(in);
    }

    public static void write7BitDecimal(BigDecimal value, OutputStream out) throws IOException {
        EncodingUtil.encodeDecimal(value, out);
    }

    public static BigDecimal read7BitDecimalN(InputStream in) throws IOException {
        int hdr = in.read();
        if ((hdr & 1) == 1) {
            return EncodingUtil.decodeDecimal(in);
        }
        return null;
    }

    public static BigDecimal readDecimal(InputStream in) throws IOException {
        byte[] buffer = new byte[16];
        Message.fillBuffer(in, buffer);
        return null;
    }

    public static Double readDoubleN(InputStream in) throws IOException {
        int hdr = in.read();
        if ((hdr & 1) == 1) {
            byte[] buffer = new byte[8];
            if (Message.fillBuffer(in, buffer) < 0) {
                throw new IOException("EOF");
            }
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.position(0);
            return bb.getDouble();
        }
        return null;
    }

    public static LinkedHashMap<String, String> readStringDictionary(InputStream in) throws IOException {
        LinkedHashMap<String, String> dictionary = new LinkedHashMap<String, String>();
        int numEntries = EncodingUtil.decode7BitInt(in);
        for (int i = 0; i < numEntries; ++i) {
            String key = Message.readString(in);
            String value = Message.readString(in);
            dictionary.put(key, value);
        }
        return dictionary;
    }

    public static void writeStringDictionary(OutputStream out, LinkedHashMap<String, String> value) throws IOException {
        EncodingUtil.encode7BitInt(value.size(), out);
        for (Map.Entry<String, String> entry : value.entrySet()) {
            Message.writeString(out, entry.getKey());
            Message.writeString(out, entry.getValue());
        }
    }
}

