/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.util;

import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;

public final class MarketUtil {
    private MarketUtil() {
    }

    public static DepthLevels depthSubscribeAtLeast(DepthLevels required, DepthLevels current) {
        if (required.getValue() > current.getValue()) {
            return required;
        }
        return current;
    }

    public static DepthBuffer depthSubscribeAtLeast(DepthBuffer required, DepthBuffer current) {
        if (required == DepthBuffer.All) {
            return DepthBuffer.All;
        }
        if (required == DepthBuffer.FastTrade) {
            if (current.equals(DepthBuffer.All)) {
                return DepthBuffer.All;
            }
            return DepthBuffer.FastTrade;
        }
        if (required == DepthBuffer.SmartTrade) {
            if (current == DepthBuffer.All) {
                return DepthBuffer.All;
            }
            if (current == DepthBuffer.FastTrade || current == DepthBuffer.FastSmart) {
                return DepthBuffer.FastTrade;
            }
            return DepthBuffer.SmartTrade;
        }
        if (required == DepthBuffer.SlowTrade) {
            if (current == DepthBuffer.All) {
                return DepthBuffer.All;
            }
            if (current == DepthBuffer.FastTrade || current == DepthBuffer.FastSmart) {
                return DepthBuffer.FastTrade;
            }
            if (current == DepthBuffer.SmartTrade || current == DepthBuffer.Smart) {
                return DepthBuffer.SmartTrade;
            }
            return DepthBuffer.SlowTrade;
        }
        if (required == DepthBuffer.TradeOnly) {
            if (current == DepthBuffer.All) {
                return DepthBuffer.All;
            }
            if (current == DepthBuffer.FastTrade || current == DepthBuffer.FastSmart) {
                return DepthBuffer.FastTrade;
            }
            if (current == DepthBuffer.SmartTrade || current == DepthBuffer.Smart) {
                return DepthBuffer.SmartTrade;
            }
            if (current == DepthBuffer.SlowTrade || current == DepthBuffer.SlowSmart) {
                return DepthBuffer.SlowTrade;
            }
            return DepthBuffer.TradeOnly;
        }
        if (required == DepthBuffer.FastSmart) {
            if (current == DepthBuffer.All) {
                return DepthBuffer.All;
            }
            if (current == DepthBuffer.FastTrade || current == DepthBuffer.SmartTrade || current == DepthBuffer.SlowTrade || current == DepthBuffer.TradeOnly) {
                return DepthBuffer.FastTrade;
            }
            return DepthBuffer.FastSmart;
        }
        if (required == DepthBuffer.Smart) {
            if (current == DepthBuffer.All) {
                return DepthBuffer.All;
            }
            if (current == DepthBuffer.FastTrade) {
                return DepthBuffer.FastTrade;
            }
            if (current == DepthBuffer.SmartTrade || current == DepthBuffer.SlowTrade || current == DepthBuffer.TradeOnly) {
                return DepthBuffer.SmartTrade;
            }
            if (current == DepthBuffer.FastSmart) {
                return DepthBuffer.FastSmart;
            }
            return DepthBuffer.Smart;
        }
        if (required == DepthBuffer.SlowSmart) {
            if (current == DepthBuffer.All) {
                return DepthBuffer.All;
            }
            if (current == DepthBuffer.FastTrade) {
                return DepthBuffer.FastTrade;
            }
            if (current == DepthBuffer.SmartTrade) {
                return DepthBuffer.SmartTrade;
            }
            if (current == DepthBuffer.SlowTrade || current == DepthBuffer.TradeOnly) {
                return DepthBuffer.SlowTrade;
            }
            if (current == DepthBuffer.FastSmart) {
                return DepthBuffer.FastSmart;
            }
            if (current == DepthBuffer.Smart) {
                return DepthBuffer.Smart;
            }
            return DepthBuffer.SlowSmart;
        }
        return current;
    }

    public static boolean isDepthBufferSet(DepthBuffer check, DepthBuffer buffer) {
        if (check == DepthBuffer.All) {
            return true;
        }
        if (check == DepthBuffer.FastTrade) {
            return buffer == DepthBuffer.FastTrade || buffer == DepthBuffer.FastSmart || buffer == DepthBuffer.SmartTrade || buffer == DepthBuffer.Smart || buffer == DepthBuffer.SlowTrade || buffer == DepthBuffer.SlowSmart || buffer == DepthBuffer.TradeOnly || buffer == DepthBuffer.NoSubscription;
        }
        if (check == DepthBuffer.FastSmart) {
            return buffer == DepthBuffer.FastTrade || buffer == DepthBuffer.FastSmart || buffer == DepthBuffer.SmartTrade || buffer == DepthBuffer.Smart || buffer == DepthBuffer.SlowTrade || buffer == DepthBuffer.SlowSmart || buffer == DepthBuffer.NoSubscription;
        }
        if (check == DepthBuffer.SmartTrade) {
            return buffer == DepthBuffer.SmartTrade || buffer == DepthBuffer.Smart || buffer == DepthBuffer.SlowTrade || buffer == DepthBuffer.SlowSmart || buffer == DepthBuffer.TradeOnly || buffer == DepthBuffer.NoSubscription;
        }
        if (check == DepthBuffer.Smart) {
            return buffer == DepthBuffer.SmartTrade || buffer == DepthBuffer.Smart || buffer == DepthBuffer.SlowTrade || buffer == DepthBuffer.SlowSmart || buffer == DepthBuffer.NoSubscription;
        }
        if (check == DepthBuffer.SlowTrade) {
            return buffer == DepthBuffer.SlowTrade || buffer == DepthBuffer.SlowSmart || buffer == DepthBuffer.TradeOnly || buffer == DepthBuffer.NoSubscription;
        }
        if (check == DepthBuffer.SlowSmart) {
            return buffer == DepthBuffer.SlowTrade || buffer == DepthBuffer.SlowSmart || buffer == DepthBuffer.NoSubscription;
        }
        if (check == DepthBuffer.TradeOnly) {
            return buffer == DepthBuffer.TradeOnly || buffer == DepthBuffer.NoSubscription;
        }
        return check == DepthBuffer.NoSubscription;
    }
}

