/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.priceconversion;

import com.t4login.Log;
import com.t4login.definitions.priceconversion.Price;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;

public class VPT {
    public static final String TAG = "VTT";
    public final String spec;
    public final String marketID;
    public final Price baseIncrement;
    public final Price minCabPrice;
    private boolean isValid;
    private VPTLimit vpt;

    public VPT(String vttSpec) {
        this(vttSpec, "", new Price(BigDecimal.ONE), null);
    }

    public VPT(String vptSpec, String marketID, Price baseIncrement, Price minCabPrice) {
        this.spec = vptSpec != null ? vptSpec : "";
        this.marketID = marketID;
        this.baseIncrement = baseIncrement;
        this.minCabPrice = minCabPrice;
        try {
            String[] parts = this.spec.split(";");
            if (parts.length == 1 && parts[0].equals("")) {
                parts = new String[]{};
            }
            if (parts.length > 0) {
                baseIncrement = new Price(new BigDecimal(parts[0]));
            }
            this.vpt = new VPTLimit(baseIncrement);
            if (minCabPrice != null && minCabPrice.compareTo(baseIncrement) < 0) {
                this.vpt.addLimit(LimitDir.GreaterThan, new Price(BigDecimal.ZERO), minCabPrice);
                this.vpt.addLimit(LimitDir.GreaterThan, minCabPrice, baseIncrement.subtract(minCabPrice));
                this.vpt.addLimit(LimitDir.GreaterThan, baseIncrement, baseIncrement);
            }
            for (int i = 1; i < parts.length; ++i) {
                String[] limParts = parts[i].split("=");
                if (limParts.length != 2) continue;
                Price limitPrice = new Price(new BigDecimal(limParts[0].substring(2)));
                Price limitIncrement = new Price(new BigDecimal(limParts[1]));
                if (limParts[0].toUpperCase(Locale.US).startsWith("P>")) {
                    this.vpt.addLimit(LimitDir.GreaterThan, limitPrice, limitIncrement);
                    continue;
                }
                if (limParts[0].toUpperCase(Locale.US).startsWith("P<")) {
                    this.vpt.addLimit(LimitDir.LessThan, limitPrice, limitIncrement);
                    continue;
                }
                this.isValid = false;
                throw new IllegalArgumentException(String.format("'%s' is an invalid condition format. Expected 'P>' or 'P<'. VTT: '%s'", limParts[0], vptSpec));
            }
            this.isValid = true;
        }
        catch (Exception ex) {
            this.isValid = false;
            Log.e(TAG, "Error parsing VTT.", ex);
        }
        if (!this.isValid) {
            this.vpt = new VPTLimit(new Price(BigDecimal.ONE));
        }
    }

    public String toString() {
        return this.spec;
    }

    public String getSpec() {
        return this.spec;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public boolean isWholeIncrement(Price price) {
        return this.vpt.isWholeIncrement(price);
    }

    public BigDecimal priceToIncrements(Price price) {
        return this.vpt.getIncrements(price);
    }

    public Price incrementsToPrice(BigDecimal increments) {
        return this.vpt.getPrice(increments);
    }

    public Price incrementsToPrice(int increments) {
        return this.vpt.getPrice(new BigDecimal(increments));
    }

    public BigDecimal getIncrementValueForPrice(Price price) {
        return this.vpt.getIncrementForPrice(price);
    }

    public BigDecimal getIncrementValueForIncrements(BigDecimal increments) {
        return this.vpt.getIncrementForIncrements(increments);
    }

    public Price addIncrements(Price price, BigDecimal increments) {
        return this.incrementsToPrice(this.priceToIncrements(price).add(increments));
    }

    private class VPTLimit {
        private VPTLimit left = null;
        private VPTLimit right = null;
        private Price minPriceIncrement;
        private Price leftLimit;
        private Price rightLimit;
        private BigDecimal leftNums;
        private BigDecimal rightNums;

        public VPTLimit(Price minPriceIncrement) {
            this.minPriceIncrement = minPriceIncrement;
            this.leftLimit = Price.MinValue;
            this.rightLimit = Price.MaxValue;
            this.leftNums = Price.MinValue.getDecimalValue();
            this.rightNums = Price.MaxValue.getDecimalValue();
        }

        public VPTLimit(LimitDir dir, Price minPriceIncrement) {
            this.minPriceIncrement = minPriceIncrement;
            if (dir.equals((Object)LimitDir.GreaterThan)) {
                this.leftLimit = null;
                this.rightLimit = Price.MaxValue;
                this.leftNums = BigDecimal.ONE;
                this.rightNums = Price.MaxValue.getDecimalValue();
            } else {
                this.leftLimit = Price.MinValue;
                this.rightLimit = null;
                this.leftNums = Price.MinValue.getDecimalValue();
                this.rightNums = BigDecimal.ONE;
            }
        }

        public void addLimit(LimitDir dir, Price limit, Price num) {
            if (dir.equals((Object)LimitDir.GreaterThan)) {
                if (this.rightLimit.equals(Price.MaxValue)) {
                    this.rightLimit = limit;
                    this.rightNums = this.rightLimit.getDecimalValue().divide(this.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
                    this.right = new VPTLimit(dir, num);
                } else if (limit.compareTo(this.rightLimit) > 0) {
                    this.right.addLimit(dir, limit.subtract(this.rightLimit), num);
                } else {
                    VPTLimit temp = this.right;
                    this.right = new VPTLimit(dir, num);
                    this.right.rightLimit = this.rightLimit.subtract(limit);
                    this.right.rightNums = this.right.rightLimit.getDecimalValue().divide(this.right.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
                    this.rightLimit = limit;
                    this.rightNums = this.rightLimit.getDecimalValue().divide(this.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
                    this.right.right = temp;
                }
            } else if (this.leftLimit.equals(Price.MinValue)) {
                this.leftLimit = limit;
                this.leftNums = this.leftLimit.getDecimalValue().divide(this.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
                this.left = new VPTLimit(dir, num);
            } else if (limit.compareTo(this.leftLimit) < 0) {
                this.left.addLimit(dir, limit.subtract(this.leftLimit), num);
            } else {
                VPTLimit temp = this.left;
                this.left = new VPTLimit(dir, num);
                this.left.leftLimit = this.leftLimit.subtract(limit);
                this.left.leftNums = this.leftLimit.getDecimalValue().divide(this.left.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
                this.leftLimit = limit;
                this.leftNums = this.leftLimit.getDecimalValue().divide(this.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
                this.left.left = temp;
            }
        }

        public BigDecimal getIncrements(Price price) {
            if (this.rightLimit != null && price.compareTo(this.rightLimit) > 0) {
                return this.rightNums.add(this.right.getIncrements(price.subtract(this.rightLimit)));
            }
            if (this.leftLimit != null && price.compareTo(this.leftLimit) < 0) {
                return this.leftNums.add(this.left.getIncrements(price.subtract(this.leftLimit)));
            }
            return price.getDecimalValue().divide(this.minPriceIncrement.getDecimalValue(), RoundingMode.HALF_EVEN);
        }

        public Price getPrice(BigDecimal increments) {
            if (increments.compareTo(this.rightNums) > 0) {
                return this.rightLimit.add(this.right.getPrice(increments.subtract(this.rightNums)));
            }
            if (increments.compareTo(this.leftNums) < 0) {
                return this.leftLimit.add(this.left.getPrice(increments.subtract(this.leftNums)));
            }
            return new Price(increments.multiply(this.minPriceIncrement.getDecimalValue()));
        }

        public BigDecimal getIncrementForPrice(Price price) {
            if (this.rightLimit != null && price.compareTo(this.rightLimit) > 0) {
                return this.right.getIncrementForPrice(price.subtract(this.rightLimit));
            }
            if (this.leftLimit != null && price.compareTo(this.leftLimit) < 0) {
                return this.left.getIncrementForPrice(price.subtract(this.leftLimit));
            }
            return this.minPriceIncrement.getDecimalValue();
        }

        public BigDecimal getIncrementForIncrements(BigDecimal increments) {
            if (increments.compareTo(this.rightNums) > 0) {
                return this.right.getIncrementForIncrements(increments.subtract(this.rightNums));
            }
            if (increments.compareTo(this.leftNums) < 0) {
                return this.left.getIncrementForIncrements(increments.subtract(this.leftNums));
            }
            return this.minPriceIncrement.getDecimalValue();
        }

        public boolean isWholeIncrement(Price price) {
            if (this.right != null && price.compareTo(this.rightLimit) > 0) {
                return this.right.isWholeIncrement(price.subtract(this.rightLimit));
            }
            if (this.left != null && price.compareTo(this.leftLimit) < 0) {
                return this.left.isWholeIncrement(price.subtract(this.leftLimit));
            }
            return price.getDecimalValue().remainder(this.minPriceIncrement.getDecimalValue()).compareTo(BigDecimal.ZERO) == 0;
        }
    }

    private static enum LimitDir {
        GreaterThan,
        LessThan;

    }
}

