/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.priceconversion;

import com.t4login.Log;
import com.t4login.application.settings.AppSettings;
import com.t4login.application.settings.PriceDisplayMode;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.IPriceFormatArgs;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.util.ContractStrikeDetails;
import com.t4login.util.VBMath;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PriceFormat {
    private static final String TAG = "PriceFormat";
    private static final Map<String, TickFormatter> tickDisplayFormatters = new HashMap<String, TickFormatter>();
    private static final Map<String, TickFormatter> displayTickFormatters;
    private static final Map<String, PriceFormatter> priceDisplayFormatters;
    private static final Map<String, PriceFormatter> displayPriceFormatters;

    public static double convertPriceToRealDecimal(Price price, IPriceFormatArgs args) {
        String formatted = PriceFormat.convertPriceToDisplayFormat(price, args, PriceDisplayMode.RealDecimal);
        return Double.parseDouble(formatted);
    }

    public static Price convertRealDecimalToPrice(double realDecimal, IPriceFormatArgs args) {
        return PriceFormat.displayToPrice(Double.toString(realDecimal), args, PriceDisplayMode.RealDecimal);
    }

    public static double convertTicksToDisplayValue(double ticks, String priceCode, int denominator) {
        TickFormatter f;
        double price = priceCode == null || priceCode.isEmpty() || priceCode.equals("0") ? ticks / (double)denominator : ((f = tickDisplayFormatters.get(priceCode.toUpperCase(Locale.US))) != null ? f.format(ticks, denominator) : ticks / (double)denominator);
        return price;
    }

    public static BigDecimal convertPriceToDisplayValue(Price price, String priceCode) {
        PriceFormatter f;
        if (price == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal decValue = price.getDecimalValue();
        if (priceCode != null && !priceCode.isEmpty() && !priceCode.equals("0") && (f = priceDisplayFormatters.get(priceCode.toUpperCase(Locale.US))) != null) {
            decValue = f.format(decValue);
        }
        return decValue;
    }

    public static String convertTicksToDisplayFormat(double ticks, IPriceFormatArgs args, PriceDisplayMode displayMode) {
        String priceCode;
        int denominator = switch (displayMode) {
            case PriceDisplayMode.Decimal -> {
                priceCode = "";
                yield args.getDenominator();
            }
            case PriceDisplayMode.RealDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.ClearingDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            case PriceDisplayMode.PriceFormatAndRealDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.PriceFormatAndClearingDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            default -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator();
            }
        };
        double price = PriceFormat.convertTicksToDisplayValue(ticks, priceCode, denominator);
        int ndec = 0;
        if (args.getPriceCode() == null || args.getPriceCode().isEmpty()) {
            if (priceCode.equals("") || priceCode.equals("0") || priceCode.equals("I0") || priceCode.equals("I1") || priceCode.equals("I2") || priceCode.equals("I3") || priceCode.equals("I4") || priceCode.equals("I5") || priceCode.equals("I6") || priceCode.equals("I7") || priceCode.equals("I8") || priceCode.equals("I9")) {
                ndec = Integer.toString(denominator).length() - 1;
                ndec = Math.max(0, ndec);
            } else {
                ndec = 0;
            }
        }
        return String.format("%." + ndec + "f", price);
    }

    public static String convertPriceToDisplayFormat(Price price, IPriceFormatArgs args) {
        return PriceFormat.convertPriceToDisplayFormat(price, args, AppSettings.instance.MarketData.PriceDisplay);
    }

    public static String convertPriceToDisplayFormat(double price, IMarketConversion market) {
        return PriceFormat.convertPriceToDisplayFormat(Price.of(price).round(market), (IPriceFormatArgs)market, AppSettings.instance.MarketData.PriceDisplay);
    }

    public static String convertPriceToDisplayFormat(double price, IPriceFormatArgs args, PriceDisplayMode displayMode) {
        return PriceFormat.convertPriceToDisplayFormat(Price.of(price), args, displayMode);
    }

    public static String convertPriceToDisplayFormat(Price price, IPriceFormatArgs args, PriceDisplayMode displayMode) {
        return PriceFormat.convertPriceToDisplayFormat(price, args, displayMode, PriceType.Price);
    }

    public static String convertPriceToDisplayFormat(Price price, IPriceFormatArgs args, PriceDisplayMode displayMode, PriceType priceType) {
        String decSep;
        int decimalPos;
        Object formatted;
        int ndec;
        String priceCode;
        if (price == null) {
            return "";
        }
        boolean isCabPrice = args.getMinCabPrice() != null && price.equals(args.getMinCabPrice());
        int denominator = switch (displayMode) {
            case PriceDisplayMode.Decimal -> {
                priceCode = "";
                yield args.getDenominator();
            }
            case PriceDisplayMode.RealDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.ClearingDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            case PriceDisplayMode.PriceFormatAndRealDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.PriceFormatAndClearingDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            default -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator();
            }
        };
        BigDecimal priceValue = PriceFormat.convertPriceToDisplayValue(price, priceCode);
        if ((priceCode.equals("") || priceCode.equals("0")) && denominator != args.getDenominator()) {
            priceValue = priceValue.multiply(BigDecimal.valueOf(args.getDenominator())).divide(new BigDecimal(denominator), 18, 6);
        }
        if (priceCode.equals("") || priceCode.equals("0")) {
            ndec = Integer.toString(denominator).length() - 1;
            ndec = Math.max(0, ndec);
        } else {
            ndec = 0;
        }
        if (priceValue.compareTo(BigDecimal.ZERO) == 0) {
            formatted = "0";
        } else {
            BigDecimal stz = priceValue.stripTrailingZeros();
            String stzStr = stz.toString();
            String ps = priceValue.toPlainString();
            formatted = ps.replaceAll("0+$", "");
        }
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char sep = symbols.getDecimalSeparator();
        if (sep != '.') {
            formatted = ((String)formatted).replace('.', sep);
        }
        if ((decimalPos = ((String)formatted).indexOf(sep)) < 0) {
            if (ndec > 0) {
                formatted = (String)formatted + sep + new String(new char[ndec]).replace('\u0000', '0');
            }
        } else if (!isCabPrice) {
            int diff = ndec - (((String)formatted).length() - decimalPos) + 1;
            if (diff > 0) {
                formatted = (String)formatted + new String(new char[diff]).replace('\u0000', '0');
            } else if (diff >= 0 && ((String)formatted).endsWith(new String(new char[]{sep}))) {
                formatted = ((String)formatted).substring(0, ((String)formatted).length() - 1);
            }
        }
        if (priceType == PriceType.StrikePrice && ((String)formatted).contains(decSep = Character.toString(sep))) {
            String r = "\\";
            String regExp = r + decSep + "?0+$";
            formatted = ((String)formatted).replaceAll(regExp, "");
        }
        return formatted;
    }

    public static int displayToTicks(double price, IPriceFormatArgs args, PriceDisplayMode displayMode) {
        TickFormatter f;
        String priceCode;
        int denominator = switch (displayMode) {
            case PriceDisplayMode.Decimal -> {
                priceCode = "";
                yield args.getDenominator();
            }
            case PriceDisplayMode.RealDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.ClearingDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            case PriceDisplayMode.PriceFormatAndRealDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.PriceFormatAndClearingDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            default -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator();
            }
        };
        double tickv = priceCode == null || priceCode.isEmpty() || priceCode.equals("0") ? (price > 0.0 ? (double)VBMath.Fix(price * (double)denominator + 1.0 / (double)(10000L * (long)denominator)) : (double)VBMath.Fix(price * (double)denominator - 1.0 / (double)(10000L * (long)denominator))) : ((f = displayTickFormatters.get(priceCode.toUpperCase(Locale.US))) != null ? f.format(price, denominator) : (double)VBMath.Fix(price * (double)denominator + 1.0 / (double)(10000L * (long)denominator)));
        return (int)tickv;
    }

    public static Price displayToPrice(String displayFormatted, IPriceFormatArgs args) {
        if (displayFormatted == null || displayFormatted.isEmpty()) {
            return null;
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.setParseBigDecimal(true);
        BigDecimal decimalValue = BigDecimal.ZERO;
        try {
            decimalValue = (BigDecimal)df.parseObject(displayFormatted);
        }
        catch (ParseException e) {
            Log.e(TAG, "displayToPrice(), Error: ", e);
            decimalValue = BigDecimal.ZERO;
        }
        return PriceFormat.displayToPrice(decimalValue, args, AppSettings.instance.MarketData.PriceDisplay);
    }

    public static Price displayToPrice(BigDecimal displayPrice, IPriceFormatArgs args) {
        return PriceFormat.displayToPrice(displayPrice, args, AppSettings.instance.MarketData.PriceDisplay);
    }

    public static Price displayToPrice(String displayFormatted, IPriceFormatArgs args, PriceDisplayMode displayMode) {
        if (displayFormatted == null || displayFormatted.isEmpty()) {
            return null;
        }
        return PriceFormat.displayToPrice(new BigDecimal(displayFormatted), args, displayMode);
    }

    public static Price displayToPrice(BigDecimal displayPrice, IPriceFormatArgs args, PriceDisplayMode displayMode) {
        String priceCode;
        int denominator = switch (displayMode) {
            case PriceDisplayMode.Decimal -> {
                priceCode = "";
                yield args.getDenominator();
            }
            case PriceDisplayMode.RealDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.ClearingDecimal -> {
                priceCode = "";
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            case PriceDisplayMode.PriceFormatAndRealDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getRealDecimals());
            }
            case PriceDisplayMode.PriceFormatAndClearingDecimal -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator() * (int)Math.pow(10.0, args.getClearingDecimals());
            }
            default -> {
                priceCode = args.getPriceCode();
                yield args.getDenominator();
            }
        };
        BigDecimal priceValue = displayPrice;
        if (priceCode == null || priceCode.isEmpty() || priceCode.equals("0")) {
            if (denominator != args.getDenominator()) {
                priceValue = displayPrice.multiply(BigDecimal.valueOf(denominator)).divide(new BigDecimal(args.getDenominator()), 18, 6);
            }
        } else {
            PriceFormatter f = displayPriceFormatters.get(priceCode.toUpperCase(Locale.US));
            if (f != null) {
                priceValue = f.format(displayPrice);
            } else if (denominator != args.getDenominator()) {
                priceValue = displayPrice.multiply(BigDecimal.valueOf(denominator)).divide(new BigDecimal(args.getDenominator()), 18, 6);
            }
        }
        return new Price(priceValue);
    }

    public static double convertTicksToCashValue(double ticks, int numerator, double tickValue) {
        return ticks / (double)numerator * tickValue;
    }

    public static BigDecimal convertPriceToCashValue(Price price, IMarketConversion mkt) {
        return price.getDecimalValue().multiply(mkt.getPointValue());
    }

    public static double convertCashValueToTicks(double cashValue, int numerator, double tickValue) {
        double tickVal = cashValue / tickValue * (double)numerator;
        return (long)tickVal;
    }

    public static double convertTicksToYield(double parValue, int years, double rate, double priceValue, double redemption, double paymentsPerYear, int basis) {
        return 0.0;
    }

    public static Price strikeToPrice(Price strikePrice, ContractStrikeDetails strikeDetails) {
        return strikePrice.multiply(strikeDetails.strikeMultiplier);
    }

    static {
        tickDisplayFormatters.put("A", (ticks, denom) -> ticks / denom * 10.0);
        tickDisplayFormatters.put("MA", (ticks, denom) -> ticks / denom * 10.0);
        tickDisplayFormatters.put("B", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 10.0 + dec * 8.0;
        });
        tickDisplayFormatters.put("C", (ticks, denom) -> VBMath.Fix(ticks / denom * 10.0));
        tickDisplayFormatters.put("MB", (ticks, denom) -> VBMath.Fix(ticks / denom * 10.0));
        tickDisplayFormatters.put("D", (ticks, denom) -> {
            double pt = (long)(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 10.0 + dec * 8.0;
        });
        tickDisplayFormatters.put("MC", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 10.0 + dec * 8.0;
        });
        tickDisplayFormatters.put("E", (ticks, denom) -> VBMath.Fix(ticks / denom * 10.0));
        tickDisplayFormatters.put("MD", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 100.0 + dec * 16.0;
        });
        tickDisplayFormatters.put("F", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 100.0 + dec * 32.0;
        });
        tickDisplayFormatters.put("ME", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 100.0 + dec * 32.0;
        });
        tickDisplayFormatters.put("G", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 100.0 + dec * 64.0;
        });
        tickDisplayFormatters.put("26", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 100.0 + dec * 64.0;
        });
        tickDisplayFormatters.put("MF", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 100.0 + dec * 64.0;
        });
        tickDisplayFormatters.put("H", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 1000.0 + dec * 320.0;
        });
        tickDisplayFormatters.put("MG", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 1000.0 + dec * 320.0;
        });
        tickDisplayFormatters.put("I", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return VBMath.Fix(pt * 1000.0 + dec * 320.0);
        });
        tickDisplayFormatters.put("MH", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            double tickVal = pt * 1000.0 + dec * 320.0;
            return VBMath.Fix(tickVal);
        });
        tickDisplayFormatters.put("J", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 1000.0 + dec * 640.0;
        });
        tickDisplayFormatters.put("MI", (ticks, denom) -> {
            double pt = VBMath.Fix(ticks / denom);
            double dec = ticks / denom - pt;
            return pt * 1000.0 + dec * 640.0;
        });
        tickDisplayFormatters.put("K", (ticks, denom) -> ticks / denom * 10.0);
        tickDisplayFormatters.put("L", (ticks, denom) -> ticks / denom * 10.0);
        tickDisplayFormatters.put("M", (ticks, denom) -> ticks / denom * 10.0);
        tickDisplayFormatters.put("N", (ticks, denom) -> ticks);
        tickDisplayFormatters.put("O", (ticks, denom) -> ticks);
        tickDisplayFormatters.put("P", (ticks, denom) -> ticks);
        tickDisplayFormatters.put("Q", (ticks, denom) -> ticks);
        tickDisplayFormatters.put("R", (ticks, denom) -> VBMath.Fix(ticks / denom * 10.0));
        tickDisplayFormatters.put("S", (ticks, denom) -> VBMath.Fix(ticks / denom * 100.0));
        tickDisplayFormatters.put("25", (ticks, denom) -> (double)VBMath.Fix(ticks / 32.0) * 100.0 + ticks % 32.0);
        tickDisplayFormatters.put("27", (ticks, denom) -> (double)VBMath.Fix(ticks / 64.0) * 1000.0 + ticks % 64.0 * 10.0 / 2.0);
        tickDisplayFormatters.put("I0", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(1.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I1", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(10.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I2", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(100.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I3", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(1000.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I4", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(10000.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I5", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(100000.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I6", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(1000000.0 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I7", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(1.0E7 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I8", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(1.0E8 / ticks * denom + 0.5) / denom;
        });
        tickDisplayFormatters.put("I9", (ticks, denom) -> {
            if (ticks == 0.0) {
                return 0.0;
            }
            return (double)VBMath.Int(1.0E9 / ticks * denom + 0.5) / denom;
        });
        displayTickFormatters = new HashMap<String, TickFormatter>();
        displayTickFormatters.put("A", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("MA", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("B", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 10.0);
            double dec = (dispVal - pt * 10.0) / 8.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("C", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("MB", (dispVal, denom) -> {
            if (dispVal % 5.0 != 0.0) {
                dispVal = dispVal > 0.0 ? (dispVal += 0.5) : (dispVal -= 0.5);
            }
            return VBMath.CInt(dispVal / 10.0 * denom);
        });
        displayTickFormatters.put("D", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 10.0);
            double dec = (dispVal - pt * 10.0) / 8.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("MC", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 10.0);
            double dec = (dispVal - pt * 10.0) / 8.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("E", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("MD", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 100.0);
            double dec = (dispVal - pt * 100.0) / 16.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("F", (dispVal, denom) -> {
            double pt = (long)(dispVal / 100.0);
            double dec = (dispVal - pt * 100.0) / 32.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("ME", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 100.0);
            double dec = (dispVal - pt * 100.0) / 32.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("G", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 100.0);
            double dec = (dispVal - pt * 100.0) / 64.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("26", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 100.0);
            double dec = (dispVal - pt * 100.0) / 64.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("MF", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 100.0);
            double dec = (dispVal - pt * 100.0) / 64.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("H", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 1000.0);
            double dec = (dispVal - pt * 1000.0) / 320.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("MG", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 1000.0);
            double dec = (dispVal - pt * 1000.0) / 320.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("I", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 1000.0);
            double dec = (dispVal - pt * 1000.0) / 320.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("MH", (dispVal, denom) -> {
            if (dispVal % 5.0 != 0.0) {
                dispVal = dispVal > 0.0 ? (dispVal += 0.5) : (dispVal -= 0.5);
            }
            double pt = VBMath.Fix(dispVal / 1000.0);
            double dec = (dispVal - pt * 1000.0) / 320.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("J", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 1000.0);
            double dec = (dispVal - pt * 1000.0) / 640.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("MI", (dispVal, denom) -> {
            double pt = VBMath.Fix(dispVal / 1000.0);
            double dec = (dispVal - pt * 1000.0) / 640.0;
            return VBMath.CInt((dec + pt) * denom);
        });
        displayTickFormatters.put("K", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("L", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("M", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("N", (dispVal, denom) -> VBMath.CInt(dispVal));
        displayTickFormatters.put("O", (dispVal, denom) -> VBMath.CInt(dispVal));
        displayTickFormatters.put("P", (dispVal, denom) -> VBMath.CInt(dispVal));
        displayTickFormatters.put("Q", (dispVal, denom) -> VBMath.CInt(dispVal));
        displayTickFormatters.put("R", (dispVal, denom) -> VBMath.CInt(dispVal / 10.0 * denom));
        displayTickFormatters.put("S", (dispVal, denom) -> VBMath.CInt(dispVal / 100.0 * denom));
        displayTickFormatters.put("25", (dispVal, denom) -> VBMath.CInt((double)(VBMath.Fix(dispVal / 100.0) * 32) + dispVal % 100.0));
        displayTickFormatters.put("27", (dispVal, denom) -> VBMath.CInt((double)(VBMath.Fix(dispVal / 1000.0) * 64) + dispVal % 1000.0 * 2.0 / 10.0));
        displayTickFormatters.put("I0", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(1.0 / dispVal));
        displayTickFormatters.put("I1", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(10.0 / dispVal));
        displayTickFormatters.put("I2", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(100.0 / dispVal));
        displayTickFormatters.put("I3", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(1000.0 / dispVal));
        displayTickFormatters.put("I4", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(10000.0 / dispVal));
        displayTickFormatters.put("I5", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(100000.0 / dispVal));
        displayTickFormatters.put("I6", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(1000000.0 / dispVal));
        displayTickFormatters.put("I7", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(1.0E7 / dispVal));
        displayTickFormatters.put("I8", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(1.0E8 / dispVal));
        displayTickFormatters.put("I9", (dispVal, denom) -> dispVal == 0.0 ? 0.0 : (double)VBMath.CInt(1.0E9 / dispVal));
        priceDisplayFormatters = new HashMap<String, PriceFormatter>();
        priceDisplayFormatters.put("A", value -> value.multiply(BigDecimal.TEN));
        priceDisplayFormatters.put("MA", value -> value.multiply(BigDecimal.TEN));
        priceDisplayFormatters.put("B", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.TEN).add(dec.multiply(BigDecimal.valueOf(8L)));
        });
        priceDisplayFormatters.put("C", value -> VBMath.Fix(value.multiply(BigDecimal.TEN)));
        priceDisplayFormatters.put("MB", value -> VBMath.Fix(value.multiply(BigDecimal.TEN)));
        priceDisplayFormatters.put("D", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.TEN).add(dec.multiply(BigDecimal.valueOf(8L)));
        });
        priceDisplayFormatters.put("MC", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.TEN).add(dec.multiply(BigDecimal.valueOf(8L)));
        });
        priceDisplayFormatters.put("E", value -> VBMath.Fix(value.multiply(BigDecimal.TEN)));
        priceDisplayFormatters.put("MD", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(100L)).add(dec.multiply(BigDecimal.valueOf(16L)));
        });
        priceDisplayFormatters.put("F", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(100L)).add(dec.multiply(BigDecimal.valueOf(32L)));
        });
        priceDisplayFormatters.put("ME", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(100L)).add(dec.multiply(BigDecimal.valueOf(32L)));
        });
        priceDisplayFormatters.put("G", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(100L)).add(dec.multiply(BigDecimal.valueOf(64L)));
        });
        priceDisplayFormatters.put("26", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(100L)).add(dec.multiply(BigDecimal.valueOf(64L)));
        });
        priceDisplayFormatters.put("MF", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(100L)).add(dec.multiply(BigDecimal.valueOf(64L)));
        });
        priceDisplayFormatters.put("H", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(320L)));
        });
        priceDisplayFormatters.put("MG", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(320L)));
        });
        priceDisplayFormatters.put("I", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(320L)));
        });
        priceDisplayFormatters.put("MH", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            BigDecimal priceValue = pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(320L)));
            return VBMath.Fix(priceValue);
        });
        priceDisplayFormatters.put("J", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(640L)));
        });
        priceDisplayFormatters.put("MI", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            return pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(640L)));
        });
        priceDisplayFormatters.put("MJ", value -> {
            BigDecimal pt = VBMath.Fix(value);
            BigDecimal dec = value.subtract(pt);
            BigDecimal priceValue = pt.multiply(BigDecimal.valueOf(1000L)).add(dec.multiply(BigDecimal.valueOf(320L)));
            return VBMath.Fix(priceValue);
        });
        priceDisplayFormatters.put("K", value -> value.multiply(BigDecimal.TEN));
        priceDisplayFormatters.put("L", value -> value.multiply(BigDecimal.TEN));
        priceDisplayFormatters.put("M", value -> value.multiply(BigDecimal.TEN));
        priceDisplayFormatters.put("N", value -> value);
        priceDisplayFormatters.put("O", value -> value);
        priceDisplayFormatters.put("P", value -> value);
        priceDisplayFormatters.put("Q", value -> value);
        displayPriceFormatters = new HashMap<String, PriceFormatter>();
        displayPriceFormatters.put("A", value -> value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN));
        displayPriceFormatters.put("MA", value -> value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN));
        displayPriceFormatters.put("B", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.TEN, RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.TEN)).divide(BigDecimal.valueOf(8L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("C", value -> value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN));
        displayPriceFormatters.put("MB", value -> {
            if (value.remainder(BigDecimal.valueOf(5L)).compareTo(BigDecimal.ZERO) != 0) {
                value = value.compareTo(BigDecimal.ZERO) > 0 ? value.add(BigDecimal.valueOf(0.5)) : value.subtract(BigDecimal.valueOf(0.5));
            }
            return value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN);
        });
        displayPriceFormatters.put("D", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.TEN, RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.TEN)).divide(BigDecimal.valueOf(8L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("MC", value -> {
            BigDecimal pt = value.divide(BigDecimal.TEN, 0, RoundingMode.DOWN);
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.TEN)).divide(BigDecimal.valueOf(8L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("E", value -> value.divide(BigDecimal.TEN, RoundingMode.DOWN));
        displayPriceFormatters.put("MD", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(100L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(100L))).divide(BigDecimal.valueOf(16L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("F", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(100L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(100L))).divide(BigDecimal.valueOf(32L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("ME", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(100L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(100L))).divide(BigDecimal.valueOf(32L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("G", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(100L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(100L))).divide(BigDecimal.valueOf(64L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("26", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(100L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(100L))).divide(BigDecimal.valueOf(64L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("MF", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(100L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(100L))).divide(BigDecimal.valueOf(64L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("H", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(320L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("MG", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(320L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("I", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(320L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("MH", value -> {
            if (value.remainder(BigDecimal.valueOf(5L)).compareTo(BigDecimal.ZERO) != 0) {
                value = value.compareTo(BigDecimal.ZERO) > 0 ? value.add(BigDecimal.valueOf(0.5)) : value.subtract(BigDecimal.valueOf(0.5));
            }
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), 18, RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(320L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("J", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(640L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("MI", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), RoundingMode.DOWN));
            BigDecimal dec = value.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(640L), 18, RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("MJ", value -> {
            BigDecimal pt = VBMath.Fix(value.divide(BigDecimal.valueOf(1000L), 18, RoundingMode.DOWN));
            BigDecimal d10 = value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN);
            BigDecimal dec = d10.subtract(VBMath.Fix(d10)).multiply(BigDecimal.TEN);
            if (dec.compareTo(BigDecimal.valueOf(4L)) > 0) {
                dec = dec.subtract(BigDecimal.ONE);
            }
            dec = dec.divide(BigDecimal.valueOf(8.0), RoundingMode.DOWN).multiply(BigDecimal.TEN);
            BigDecimal decDisplay = value.add(dec.subtract(VBMath.Fix(dec)));
            dec = decDisplay.subtract(pt.multiply(BigDecimal.valueOf(1000L))).divide(BigDecimal.valueOf(320L), RoundingMode.DOWN);
            return dec.add(pt);
        });
        displayPriceFormatters.put("K", value -> value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN));
        displayPriceFormatters.put("L", value -> value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN));
        displayPriceFormatters.put("M", value -> value.divide(BigDecimal.TEN, 18, RoundingMode.DOWN));
        displayPriceFormatters.put("N", value -> value);
        displayPriceFormatters.put("O", value -> value);
        displayPriceFormatters.put("P", value -> value);
        displayPriceFormatters.put("Q", value -> value);
    }

    private static interface TickFormatter {
        public double format(double var1, double var3);
    }

    private static interface PriceFormatter {
        public BigDecimal format(BigDecimal var1);
    }

    public static enum PriceType {
        Price,
        StrikePrice;

    }
}

