/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.priceconversion;

import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.util.VBMath;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class Price
implements Serializable,
Comparable<Price>,
Cloneable {
    public static final String TAG = "Price";
    public static final int Scale = 18;
    public static final Price MaxValue = new Price(new BigDecimal("79228162514264337593543950335"));
    public static final Price MinValue = new Price(new BigDecimal("-79228162514264337593543950335"));
    public static final Price Zero = new Price(0);
    private final BigDecimal mDecimalValue;
    private final double mDoubleValue;

    public Price(int value) {
        this.mDecimalValue = BigDecimal.valueOf(value).setScale(18, 6);
        this.mDoubleValue = value;
    }

    public Price(double value) {
        this.mDecimalValue = BigDecimal.valueOf(value).setScale(18, 6);
        this.mDoubleValue = value;
    }

    public Price(BigDecimal value) {
        this.mDecimalValue = value.setScale(18, 6);
        this.mDoubleValue = this.mDecimalValue.doubleValue();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static Price of(int value) {
        return new Price(value);
    }

    public static Price of(double value) {
        return new Price(value);
    }

    public static Price of(String value) {
        return new Price(new BigDecimal(value));
    }

    public static Price fromTicks(IMarketConversion mkt, int ticks) {
        BigDecimal decimalTicks = new BigDecimal(ticks);
        BigDecimal decimalDenominator = new BigDecimal(mkt.getDenominator());
        return new Price(decimalTicks.divide(decimalDenominator, 18, 6));
    }

    public static Price getOrConvert(Price price, IMarketConversion mkt, int ticks) {
        return null;
    }

    public BigDecimal getDecimalValue() {
        return this.mDecimalValue;
    }

    public double getDoubleValue() {
        return this.mDoubleValue;
    }

    public boolean isIntegral() {
        return this.mDecimalValue.stripTrailingZeros().scale() <= 0;
    }

    public int getIntegerValue() {
        return this.mDecimalValue.intValue();
    }

    public Price abs() {
        if (this.mDecimalValue.compareTo(BigDecimal.ZERO) < 0) {
            return new Price(this.mDecimalValue.abs());
        }
        return this;
    }

    public Price negated() {
        return new Price(this.mDecimalValue.negate());
    }

    public Price add(Price value) {
        return new Price(this.mDecimalValue.add(value.mDecimalValue));
    }

    public Price add(BigDecimal value) {
        return new Price(this.mDecimalValue.add(value));
    }

    public Price subtract(Price value) {
        return new Price(this.mDecimalValue.subtract(value.mDecimalValue));
    }

    public Price subtract(BigDecimal value) {
        return new Price(this.mDecimalValue.subtract(value));
    }

    public Price multiply(Price value) {
        return new Price(this.mDecimalValue.multiply(value.mDecimalValue));
    }

    public Price multiply(BigDecimal value) {
        return new Price(this.mDecimalValue.multiply(value));
    }

    public Price multiply(double value) {
        return new Price(this.mDecimalValue.multiply(new BigDecimal(value)));
    }

    public Price divide(Price value) {
        return new Price(this.mDecimalValue.divide(value.mDecimalValue, 18, RoundingMode.HALF_EVEN));
    }

    public Price divide(BigDecimal value) {
        return new Price(this.mDecimalValue.divide(value, 18, RoundingMode.HALF_EVEN));
    }

    public Price divide(double value) {
        return new Price(this.mDecimalValue.divide(new BigDecimal(value), 18, RoundingMode.HALF_EVEN));
    }

    public Price addIncrements(IMarketConversion market, int increments) {
        if (market.getVPT() == null || market.getVPT().getIsValid()) {
            return this.add(market.getMinPriceIncrement().multiply(new BigDecimal(increments)));
        }
        return market.getVPT().addIncrements(this, new BigDecimal(increments));
    }

    public Price addIncrements(IMarketConversion market, BigDecimal increments) {
        if (market.getVPT() == null || market.getVPT().getIsValid()) {
            return this.add(market.getMinPriceIncrement().multiply(increments));
        }
        return market.getVPT().addIncrements(this, increments);
    }

    public Price round(IMarketConversion market) {
        BigDecimal increments = this.toIncrements(market);
        int wholeIncrements = VBMath.CInt(increments);
        return Price.fromIncrements(market, wholeIncrements);
    }

    public Price round(IMarketConversion market, RoundingDirection direction) {
        if (direction.equals((Object)RoundingDirection.Down)) {
            return this.roundUp(market);
        }
        return this.roundDown(market);
    }

    public Price roundUp(IMarketConversion market) {
        BigDecimal increments = this.toIncrements(market);
        if (increments.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
            increments = increments.setScale(0, RoundingMode.CEILING);
            return Price.fromIncrements(market, increments);
        }
        return this;
    }

    public Price roundDown(IMarketConversion market) {
        BigDecimal increments = this.toIncrements(market);
        if (increments.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
            increments = increments.setScale(0, RoundingMode.FLOOR);
            return Price.fromIncrements(market, increments);
        }
        return this;
    }

    public Price roundToNearest(IMarketConversion market) {
        Price up = this.roundUp(market);
        Price down = this.roundDown(market);
        if (up.subtract(this).abs().compareTo(down.subtract(this).abs()) < 0) {
            return up;
        }
        return down;
    }

    public BigDecimal toIncrements(IMarketConversion market) {
        if (market.getVPT() == null || !market.getVPT().getIsValid()) {
            return this.mDecimalValue.divide(market.getMinPriceIncrement().getDecimalValue(), RoundingMode.HALF_EVEN);
        }
        return market.getVPT().priceToIncrements(this);
    }

    public int toWholeIncrements(IMarketConversion market) {
        if (market.getVPT() == null || !market.getVPT().getIsValid()) {
            BigDecimal incrDec = this.mDecimalValue.divide(market.getMinPriceIncrement().mDecimalValue);
            return incrDec.setScale(0, RoundingMode.HALF_EVEN).intValue();
        }
        return market.getVPT().priceToIncrements(this).setScale(0, RoundingMode.HALF_EVEN).intValue();
    }

    public int toWholeIncrements(IMarketConversion market, RoundingDirection round) {
        if (market.getVPT() == null || !market.getVPT().getIsValid()) {
            BigDecimal incrDec = this.mDecimalValue.divide(market.getMinPriceIncrement().mDecimalValue);
            if (round == RoundingDirection.Down) {
                return incrDec.setScale(0, RoundingMode.FLOOR).intValue();
            }
            return incrDec.setScale(0, RoundingMode.CEILING).intValue();
        }
        return market.getVPT().priceToIncrements(this).setScale(0, round == RoundingDirection.Down ? RoundingMode.DOWN : RoundingMode.UP).intValue();
    }

    public static Price fromIncrements(IMarketConversion market, int increments) {
        if (market.getVPT() == null || !market.getVPT().getIsValid()) {
            return new Price(new BigDecimal(increments).multiply(market.getMinPriceIncrement().getDecimalValue()));
        }
        return market.getVPT().incrementsToPrice(increments);
    }

    public static Price fromIncrements(IMarketConversion market, BigDecimal increments) {
        if (market.getVPT() == null || !market.getVPT().getIsValid()) {
            return new Price(increments.multiply(market.getMinPriceIncrement().getDecimalValue()));
        }
        return market.getVPT().incrementsToPrice(increments);
    }

    public Integer toTicks(IMarketConversion mkt) {
        return this.mDecimalValue.multiply(new BigDecimal(mkt.getDenominator())).intValue();
    }

    public Integer toTicksRounded(IMarketConversion mkt, RoundingDirection dir) {
        return null;
    }

    public boolean isWholeIncrement(IMarketConversion market) {
        if (market.getVPT() == null || !market.getVPT().getIsValid()) {
            return this.mDecimalValue.remainder(market.getMinPriceIncrement().getDecimalValue()).compareTo(BigDecimal.ZERO) == 0;
        }
        return market.getVPT().isWholeIncrement(this);
    }

    public BigDecimal toCash(IMarketConversion market) {
        return this.mDecimalValue.multiply(market.getPointValue());
    }

    public static Price fromCash(IMarketConversion market, BigDecimal cashValue) {
        return new Price(cashValue.divide(market.getPointValue(), 18, 6));
    }

    public String toString() {
        String formatted = this.mDecimalValue.compareTo(BigDecimal.ZERO) == 0 ? "0" : this.mDecimalValue.stripTrailingZeros().toPlainString();
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char sep = symbols.getDecimalSeparator();
        if (sep != '.') {
            formatted = formatted.replace('.', sep);
        }
        return formatted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Price price = (Price)o;
        return this.mDecimalValue != null ? this.mDecimalValue.compareTo(price.mDecimalValue) == 0 : price.mDecimalValue == null;
    }

    public int hashCode() {
        return Double.valueOf(this.mDoubleValue).hashCode();
    }

    @Override
    public int compareTo(Price o) {
        if (o == null) {
            return 1;
        }
        return this.mDecimalValue.compareTo(o.mDecimalValue);
    }

    public static enum RoundingDirection {
        Up,
        Down;

    }
}

