/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.chartdata;

import com.t4login.Log;
import com.t4login.connection.CountingInputStream;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.chartdata.ChartFormatAggr;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.util.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;

public class ChartDataStreamReaderAggr {
    public static final String TAG = "ChartDataStreamReaderAggr";

    private ChartDataStreamReaderAggr() {
    }

    public static void read(byte[] data, ChartDataHandler handler) {
        try {
            ChartDataStreamReaderAggr.readStream(new ByteArrayInputStream(data), handler);
        }
        catch (IOException e) {
            Log.e(TAG, "read(), Error reading chart data. ", e);
        }
    }

    public static void readStream(InputStream inputStream, ChartDataHandler handler) throws IOException {
        if (inputStream == null) {
            Log.w(TAG, "readStream(), No stream.");
            return;
        }
        if (handler == null) {
            Log.e(TAG, "readStream(), Handler is null.");
            return;
        }
        CountingInputStream in = new CountingInputStream(inputStream);
        int binVersion = 1;
        ChartFormatAggr.MarketDefinition market = null;
        NDateTime tradeDate = NDateTime.MinValue;
        String marketID = "";
        while (in.available() > 0) {
            long nRead;
            long len = EncodingUtil.decode7BitInt(in);
            in.resetCount();
            if (len > 0L) {
                int tag = EncodingUtil.decode7BitInt(in);
                switch (tag) {
                    case 1: {
                        binVersion = Message.readInteger(in);
                        tradeDate = NDateTime.MinValue;
                        marketID = "";
                        break;
                    }
                    case 2: {
                        String mktID = Message.readString(in);
                        int numerator = EncodingUtil.decode7BitInt(in);
                        int denominator = EncodingUtil.decode7BitInt(in);
                        String priceCode = Message.readString(in);
                        BigDecimal tickValue = EncodingUtil.decodeDecimal(in);
                        String vpt = Message.readString(in);
                        Price minCabPrice = EncodingUtil.decodePriceN(in);
                        market = new ChartFormatAggr.MarketDefinition(mktID, numerator, denominator, priceCode, tickValue, vpt, minCabPrice);
                        handler.onMarketDefinition(market);
                        break;
                    }
                    case 4: {
                        tradeDate = Message.read7BitDateTime(in);
                        break;
                    }
                    case 3: {
                        marketID = Message.readString(in);
                        break;
                    }
                    case 10: {
                        NDateTime time = Message.read7BitDateTime(in);
                        NDateTime closeTime = new NDateTime(time.getTicks() + EncodingUtil.decode7BitLong(in));
                        int barOpenIncrements = EncodingUtil.decode7BitInt(in);
                        int barHighIncrements = EncodingUtil.decode7BitInt(in);
                        int barLowIncrements = EncodingUtil.decode7BitInt(in);
                        int barCloseIncrements = EncodingUtil.decode7BitInt(in);
                        int volume = EncodingUtil.decode7BitInt(in);
                        int volumeAtBid = EncodingUtil.decode7BitInt(in);
                        int volumeAtOffer = EncodingUtil.decode7BitInt(in);
                        int trades = EncodingUtil.decode7BitInt(in);
                        int tradesAtBid = EncodingUtil.decode7BitInt(in);
                        int tradesAtOffer = EncodingUtil.decode7BitInt(in);
                        ChartFormatAggr.Bar bar = new ChartFormatAggr.Bar(tradeDate, time, closeTime, marketID, Price.fromIncrements((IMarketConversion)market, barOpenIncrements + barLowIncrements), Price.fromIncrements((IMarketConversion)market, barHighIncrements + barLowIncrements), Price.fromIncrements((IMarketConversion)market, barLowIncrements), Price.fromIncrements((IMarketConversion)market, barCloseIncrements + barLowIncrements), volume, volumeAtBid, volumeAtOffer, trades, tradesAtBid, tradesAtOffer);
                        handler.onBar(bar);
                        break;
                    }
                    case 11: {
                        NDateTime time = Message.read7BitDateTime(in);
                        NDateTime closeTime = new NDateTime(time.getTicks() + EncodingUtil.decode7BitLong(in));
                        Price barOpenPrice = EncodingUtil.decodePrice(in);
                        Price barHighPrice = EncodingUtil.decodePrice(in);
                        Price barLowPrice = EncodingUtil.decodePrice(in);
                        Price barClosePrice = EncodingUtil.decodePrice(in);
                        int volume = EncodingUtil.decode7BitInt(in);
                        int volumeAtBid = EncodingUtil.decode7BitInt(in);
                        int volumeAtOffer = EncodingUtil.decode7BitInt(in);
                        int trades = EncodingUtil.decode7BitInt(in);
                        int tradesAtBid = EncodingUtil.decode7BitInt(in);
                        int tradesAtOffer = EncodingUtil.decode7BitInt(in);
                        ChartFormatAggr.Bar bar = new ChartFormatAggr.Bar(tradeDate, time, closeTime, marketID, barOpenPrice, barHighPrice, barLowPrice, barClosePrice, volume, volumeAtBid, volumeAtOffer, trades, tradesAtBid, tradesAtOffer);
                        handler.onBar(bar);
                        break;
                    }
                    case 20: {
                        NDateTime time = Message.read7BitDateTime(in);
                        MarketMode mode = MarketMode.get(EncodingUtil.decode7BitInt(in));
                        handler.onModeChange(marketID, tradeDate, time, mode);
                        break;
                    }
                    case 22: {
                        NDateTime time = Message.read7BitDateTime(in);
                        Price settlementPrice = EncodingUtil.decodePrice(in);
                        boolean held = Message.readBoolean(in);
                        handler.onSettlement(marketID, tradeDate, time, settlementPrice, held);
                        break;
                    }
                    case 21: {
                        NDateTime time = Message.read7BitDateTime(in);
                        int openInterest = EncodingUtil.decode7BitInt(in);
                        handler.onOpenInterest(marketID, tradeDate, time, openInterest);
                        break;
                    }
                    default: {
                        Log.v(TAG, "readStream(), Unknown tag [" + tag + "]. Not supported.");
                    }
                }
            }
            if ((nRead = in.getCount()) >= len) continue;
            in.skip(len - nRead);
        }
    }

    public static interface ChartDataHandler {
        public void onMarketDefinition(ChartFormatAggr.MarketDefinition var1);

        public void onBar(ChartFormatAggr.Bar var1);

        public void onModeChange(String var1, NDateTime var2, NDateTime var3, MarketMode var4);

        public void onSettlement(String var1, NDateTime var2, NDateTime var3, Price var4, boolean var5);

        public void onOpenInterest(String var1, NDateTime var2, NDateTime var3, int var4);
    }
}

