/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.chartdata;

import com.t4login.Log;
import com.t4login.connection.CountingInputStream;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.chartdata.ChartDataChange;
import com.t4login.definitions.chartdata.ChartDataState;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.definitions.chartdata.ChartFormat;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.util.EncodingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ChartDataStreamReader {
    public static final String TAG = "ChartDataStreamReader";
    private final CountingInputStream mIn;
    private final ChartDataType mDataType;
    private Map<String, ChartDataState> mMarketStates = new HashMap<String, ChartDataState>();
    private Map<Integer, String> mMarketKeys = new HashMap<Integer, String>();
    private ChartDataState mState;
    private boolean mIsConsolidated = false;
    private boolean mEOF = false;
    private int mBinVersion = 1;

    public ChartDataStreamReader(InputStream in, NDateTime tradeDate, String marketID, ChartDataType dataType) {
        this.mIn = in != null ? new CountingInputStream(in) : null;
        this.mState = this.getMarketState(marketID);
        this.mState.TradeDate = tradeDate;
        this.mState.TradeDateTicks = tradeDate.getTicks();
        this.mState.MarketID = marketID;
        this.mDataType = dataType;
    }

    public void close() {
        if (this.mIn != null) {
            try {
                this.mIn.close();
            }
            catch (IOException ioex) {
                Log.e(TAG, "Error.", ioex);
            }
        }
    }

    public ChartDataState getState() {
        return this.mState;
    }

    public boolean read() throws IOException {
        return this.readT4Bin();
    }

    private boolean readT4Bin() throws IOException {
        long nRead;
        if (this.mEOF || this.mIn == null) {
            return false;
        }
        if (this.mIn.available() == 0) {
            return false;
        }
        long len = EncodingUtil.decode7BitInt(this.mIn);
        this.mIn.resetCount();
        if (len > 0L) {
            int tag = EncodingUtil.decode7BitInt(this.mIn);
            switch (tag) {
                case 7: {
                    this.mIsConsolidated = true;
                    break;
                }
                case 1: {
                    if (len > 12L) {
                        this.mBinVersion = Message.readInteger(this.mIn);
                        this.mState.TradeDate = Message.readDateTime(this.mIn);
                        this.mState.TradeDateTicks = this.mState.TradeDate.getTicks();
                    } else {
                        this.mBinVersion = 0;
                        this.mState.TradeDate = Message.readDateTime(this.mIn);
                        this.mState.TradeDateTicks = this.mState.TradeDate.getTicks();
                    }
                    this.mMarketStates.clear();
                    ChartDataState newState = new ChartDataState();
                    newState.MarketID = this.mState.MarketID;
                    newState.TradeDate = this.mState.TradeDate;
                    newState.TradeDateTicks = this.mState.TradeDateTicks;
                    this.mState = newState;
                    this.mMarketStates.put(this.mState.MarketID, this.mState);
                    this.mState.Change = ChartDataChange.TradeDate;
                    break;
                }
                case 9: {
                    int mktKey = EncodingUtil.decode7BitInt(this.mIn);
                    String mktID = Message.readString(this.mIn);
                    this.mMarketKeys.put(mktKey, mktID);
                    this.getMarketState(mktID);
                    this.mState.Change = ChartDataChange.None;
                    break;
                }
                case 8: {
                    int mktKey = EncodingUtil.decode7BitInt(this.mIn);
                    String mktID = this.mMarketKeys.get(mktKey);
                    this.getMarketState(mktID);
                    this.mState.Change = ChartDataChange.MarketSwitch;
                    break;
                }
                case 2: {
                    String mktID = Message.readString(this.mIn);
                    this.getMarketState(mktID);
                    this.mState.MarketDefined = true;
                    this.mState.Numerator = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Denominator = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.PriceCode = Message.readString(this.mIn);
                    this.mState.TickValue = Message.readDouble(this.mIn);
                    if (this.mIn.getCount() < len) {
                        this.mState.VPT = Message.readString(this.mIn);
                        this.mState.MinCabPrice = Message.readPrice(this.mIn);
                    }
                    this.mState.MinPriceIncrement = null;
                    this.mState.PointValue = null;
                    this.mState.Change = ChartDataChange.MarketDefinition;
                    break;
                }
                case 11: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastTradePrice = this.mState.LastTradePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        if (this.mState.OrderVolumes != null && this.mState.OrderVolumes.length > 0) {
                            this.mState.OrderVolumes = new int[0];
                        }
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 12: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastTradePrice = this.mState.LastTradePrice.subtract(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        if (this.mState.OrderVolumes != null && this.mState.OrderVolumes.length > 0) {
                            this.mState.OrderVolumes = new int[0];
                        }
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 60: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastPriceIncrements = this.mState.LastPriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.LastTradePrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastPriceIncrements);
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        if (this.mState.OrderVolumes != null && this.mState.OrderVolumes.length > 0) {
                            this.mState.OrderVolumes = new int[0];
                        }
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 61: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastTradePrice = Price.fromIncrements((IMarketConversion)this.mState, EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        if (this.mState.OrderVolumes != null && this.mState.OrderVolumes.length > 0) {
                            this.mState.OrderVolumes = new int[0];
                        }
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 17: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastTradePrice = this.mState.LastTradePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        int nOrderVolumes = EncodingUtil.decode7BitInt(this.mIn);
                        int[] orderVolumes = new int[nOrderVolumes];
                        for (int i = 0; i < nOrderVolumes; ++i) {
                            orderVolumes[i] = Math.abs(EncodingUtil.decode7BitInt(this.mIn));
                        }
                        this.mState.OrderVolumes = orderVolumes;
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 18: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastTradePrice = this.mState.LastTradePrice.subtract(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        int nOrderVolumes = EncodingUtil.decode7BitInt(this.mIn);
                        int[] orderVolumes = new int[nOrderVolumes];
                        for (int i = 0; i < nOrderVolumes; ++i) {
                            orderVolumes[i] = Math.abs(EncodingUtil.decode7BitInt(this.mIn));
                        }
                        this.mState.OrderVolumes = orderVolumes;
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 62: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastPriceIncrements = this.mState.LastPriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.LastTradePrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastPriceIncrements);
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        int nOrderVolumes = EncodingUtil.decode7BitInt(this.mIn);
                        int[] orderVolumes = new int[nOrderVolumes];
                        for (int i = 0; i < nOrderVolumes; ++i) {
                            orderVolumes[i] = Math.abs(EncodingUtil.decode7BitInt(this.mIn));
                        }
                        this.mState.OrderVolumes = orderVolumes;
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 63: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.TradeVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.LastTradePrice = Price.fromIncrements((IMarketConversion)this.mState, EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.LastTTV += EncodingUtil.decode7BitInt(this.mIn);
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        boolean bl = this.mState.DueToSpread = (attr & 1) != 0;
                        this.mState.AtBidOrOffer = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        int nOrderVolumes = EncodingUtil.decode7BitInt(this.mIn);
                        int[] orderVolumes = new int[nOrderVolumes];
                        for (int i = 0; i < nOrderVolumes; ++i) {
                            orderVolumes[i] = Math.abs(EncodingUtil.decode7BitInt(this.mIn));
                        }
                        this.mState.OrderVolumes = orderVolumes;
                        this.mState.Change = ChartDataChange.Trade;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 14: {
                    this.mState.BarStartTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarCloseTime = this.mState.BarStartTime + EncodingUtil.decode7BitLong(this.mIn);
                    this.mState.BarClosePrice = this.mState.BarClosePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TickChange;
                    break;
                }
                case 15: {
                    this.mState.BarStartTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarCloseTime = this.mState.BarStartTime + EncodingUtil.decode7BitLong(this.mIn);
                    this.mState.BarClosePrice = this.mState.BarClosePrice.subtract(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TickChange;
                    break;
                }
                case 140: {
                    this.mState.BarStartTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarCloseTime = this.mState.BarStartTime + EncodingUtil.decode7BitLong(this.mIn);
                    this.mState.BarClosePrice = this.mState.BarClosePrice.add(EncodingUtil.decodeDecimal(this.mIn));
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TickChange;
                    break;
                }
                case 141: {
                    this.mState.BarStartTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarCloseTime = this.mState.BarStartTime + EncodingUtil.decode7BitLong(this.mIn);
                    this.mState.BarClosePrice = new Price(EncodingUtil.decodeDecimal(this.mIn));
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TickChange;
                    break;
                }
                case 21: {
                    this.mState.BarCloseTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarStartTime = ChartFormat.getBarStartTime(this.mState.BarCloseTime, this.mState.TradeDateTicks, this.mDataType);
                    this.mState.BarOpenPrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                    this.mState.BarHighPrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                    this.mState.BarLowPrice = this.mState.BarLowPrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.BarClosePrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOpenPrice = this.mState.BarOpenPrice.add(this.mState.BarLowPrice);
                    this.mState.BarHighPrice = this.mState.BarHighPrice.add(this.mState.BarLowPrice);
                    this.mState.BarClosePrice = this.mState.BarClosePrice.add(this.mState.BarLowPrice);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TradeBar;
                    break;
                }
                case 22: {
                    this.mState.BarCloseTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarStartTime = ChartFormat.getBarStartTime(this.mState.BarCloseTime, this.mState.TradeDateTicks, this.mDataType);
                    this.mState.BarOpenPrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                    this.mState.BarHighPrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                    this.mState.BarLowPrice = this.mState.BarLowPrice.subtract(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.BarClosePrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOpenPrice = this.mState.BarOpenPrice.add(this.mState.BarLowPrice);
                    this.mState.BarHighPrice = this.mState.BarHighPrice.add(this.mState.BarLowPrice);
                    this.mState.BarClosePrice = this.mState.BarClosePrice.add(this.mState.BarLowPrice);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TradeBar;
                    break;
                }
                case 65: {
                    BigDecimal barLowIncrements;
                    this.mState.BarCloseTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarStartTime = ChartFormat.getBarStartTime(this.mState.BarCloseTime, this.mState.TradeDateTicks, this.mDataType);
                    BigDecimal barOpenIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    BigDecimal barHighIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    this.mState.LastBarLowPriceIncrements = barLowIncrements = this.mState.LastBarLowPriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn));
                    BigDecimal barCloseIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    this.mState.BarOpenPrice = Price.fromIncrements((IMarketConversion)this.mState, barOpenIncrements.add(barLowIncrements));
                    this.mState.BarHighPrice = Price.fromIncrements((IMarketConversion)this.mState, barHighIncrements.add(barLowIncrements));
                    this.mState.BarLowPrice = Price.fromIncrements((IMarketConversion)this.mState, barLowIncrements);
                    this.mState.BarClosePrice = Price.fromIncrements((IMarketConversion)this.mState, barCloseIncrements.add(barLowIncrements));
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TradeBar;
                    break;
                }
                case 66: {
                    this.mState.BarCloseTime = this.getIncrementalTime(this.mState.BarCloseTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.BarStartTime = ChartFormat.getBarStartTime(this.mState.BarCloseTime, this.mState.TradeDateTicks, this.mDataType);
                    BigDecimal barOpenIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    BigDecimal barHighIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    BigDecimal barLowIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    BigDecimal barCloseIncrements = EncodingUtil.decodeDecimal(this.mIn);
                    this.mState.BarOpenPrice = Price.fromIncrements((IMarketConversion)this.mState, barOpenIncrements);
                    this.mState.BarHighPrice = Price.fromIncrements((IMarketConversion)this.mState, barHighIncrements);
                    this.mState.BarLowPrice = Price.fromIncrements((IMarketConversion)this.mState, barLowIncrements);
                    this.mState.BarClosePrice = Price.fromIncrements((IMarketConversion)this.mState, barCloseIncrements);
                    this.mState.BarVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarBidVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarOfferVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTrades = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.BarTradesAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.Change = ChartDataChange.TradeBar;
                    break;
                }
                case 30: {
                    this.mState.TPOStartTime = this.getIncrementalTime(this.mState.TPOStartTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.TPOBasePrice = this.mState.TPOBasePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.Change = ChartDataChange.None;
                    break;
                }
                case 31: {
                    this.mState.TPOStartTime = this.getIncrementalTime(this.mState.TPOStartTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.TPOBasePrice = this.mState.TPOBasePrice.subtract(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.Change = ChartDataChange.None;
                    break;
                }
                case 190: {
                    this.mState.TPOStartTime = this.getIncrementalTime(this.mState.TPOStartTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.LastTPOBasePriceIncrements = this.mState.LastTPOBasePriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn));
                    this.mState.TPOBasePrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastTPOBasePriceIncrements);
                    this.mState.Change = ChartDataChange.None;
                    break;
                }
                case 191: {
                    this.mState.TPOStartTime = this.getIncrementalTime(this.mState.TPOStartTime, EncodingUtil.decode7BitLong(this.mIn));
                    this.mState.TPOBasePrice = Price.fromIncrements((IMarketConversion)this.mState, EncodingUtil.decodeDecimal(this.mIn));
                    this.mState.Change = ChartDataChange.None;
                    break;
                }
                case 32: {
                    this.mState.TPOPrice = this.mState.TPOBasePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = false;
                    this.mState.TPOIsClosing = false;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 192: {
                    this.mState.TPOPrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastTPOBasePriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn)));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = false;
                    this.mState.TPOIsClosing = false;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 33: {
                    this.mState.TPOPrice = this.mState.TPOBasePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = true;
                    this.mState.TPOIsClosing = false;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 193: {
                    this.mState.TPOPrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastTPOBasePriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn)));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = true;
                    this.mState.TPOIsClosing = false;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 34: {
                    this.mState.TPOPrice = this.mState.TPOBasePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = false;
                    this.mState.TPOIsClosing = true;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 194: {
                    this.mState.TPOPrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastTPOBasePriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn)));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = false;
                    this.mState.TPOIsClosing = true;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 35: {
                    this.mState.TPOPrice = this.mState.TPOBasePrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = true;
                    this.mState.TPOIsClosing = true;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 195: {
                    this.mState.TPOPrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastTPOBasePriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn)));
                    this.mState.TPOVolume = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtBid = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOVolumeAtOffer = EncodingUtil.decode7BitInt(this.mIn);
                    this.mState.TPOIsOpening = true;
                    this.mState.TPOIsClosing = true;
                    this.mState.Change = ChartDataChange.TPO;
                    break;
                }
                case 50: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.BidPrice = this.mState.BidPrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.BidRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.BidImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferPrice = this.mState.BidPrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.OfferRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.Quote;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 51: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.BidPrice = this.mState.BidPrice.subtract(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.BidRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.BidImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferPrice = this.mState.BidPrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.OfferRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.Quote;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 53: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.LastBidPriceIncrements = this.mState.LastBidPriceIncrements.add(EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.BidPrice = Price.fromIncrements((IMarketConversion)this.mState, this.mState.LastBidPriceIncrements);
                        this.mState.BidRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.BidImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferPrice = this.mState.BidPrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.OfferRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.Quote;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 54: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.BidPrice = Price.fromIncrements((IMarketConversion)this.mState, EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.BidRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.BidImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferPrice = this.mState.BidPrice.add(Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator));
                        this.mState.OfferRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferImpliedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.Quote;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 52: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.BidRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.OfferRealVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.Quote;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 100: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.Mode = MarketMode.get(EncodingUtil.decode7BitInt(this.mIn));
                        this.mState.Change = ChartDataChange.MarketMode;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 101: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.SettlementPrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                        this.mState.Change = ChartDataChange.Settlement;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 107: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.SettlementPrice = Price.fromIncrements((IMarketConversion)this.mState, EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.Change = ChartDataChange.Settlement;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 102: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.SettlementHeldPrice = Price.fromTicks(this.mState, EncodingUtil.decode7BitInt(this.mIn) * this.mState.Numerator);
                        this.mState.Change = ChartDataChange.HeldSettlement;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 108: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.SettlementHeldPrice = Price.fromIncrements((IMarketConversion)this.mState, EncodingUtil.decodeDecimal(this.mIn));
                        this.mState.Change = ChartDataChange.HeldSettlement;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 103: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.ClearedVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.ClearedVolume;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 104: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        this.mState.OpenInterest = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.OpenInterest;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 105: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        int iPriceTicks = EncodingUtil.decode7BitInt(this.mIn);
                        if (!this.mState.MarketDefined) break;
                        this.mState.VWAP = Price.fromTicks(this.mState, iPriceTicks);
                        this.mState.Change = ChartDataChange.VWAP;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 109: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        BigDecimal iPriceIncrements = EncodingUtil.decodeDecimal(this.mIn);
                        if (!this.mState.MarketDefined) break;
                        this.mState.VWAP = Price.fromIncrements((IMarketConversion)this.mState, iPriceIncrements);
                        this.mState.Change = ChartDataChange.VWAP;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                case 106: {
                    if (this.incrementTimeTicks(EncodingUtil.decode7BitLong(this.mIn))) {
                        int attr = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.RFQBuySell = (attr & 2) != 0 ? BidOffer.Bid : ((attr & 4) != 0 ? BidOffer.Offer : BidOffer.Undefined);
                        this.mState.RFQVolume = EncodingUtil.decode7BitInt(this.mIn);
                        this.mState.Change = ChartDataChange.RFQ;
                        break;
                    }
                    this.mEOF = true;
                    break;
                }
                default: {
                    Log.v(TAG, "readT4Bin(), Unknown tag [" + tag + "]. Not supported.");
                    this.mState.Change = ChartDataChange.None;
                }
            }
        }
        if ((nRead = this.mIn.getCount()) < len) {
            this.mIn.skip(len - nRead);
        }
        return !this.mEOF;
    }

    private ChartDataState getMarketState(String marketID) {
        if (this.mState == null || !this.mState.MarketID.equals(marketID)) {
            this.mState = this.mMarketStates.get(marketID);
            if (this.mState == null) {
                this.mState = this.mMarketStates.get("");
                if (this.mState != null && !this.mIsConsolidated) {
                    this.mMarketStates.put(marketID, this.mState);
                } else if (this.mState == null) {
                    this.mState = new ChartDataState();
                    this.mState.MarketID = marketID;
                    this.mMarketStates.put(marketID, this.mState);
                } else {
                    this.mState.MarketID = marketID;
                    this.mMarketStates.put(marketID, this.mState);
                }
            }
        }
        return this.mState;
    }

    private boolean incrementTimeTicks(long ticks) {
        this.mState.LastTimeTicks = this.getIncrementalTime(this.mState.LastTimeTicks, ticks);
        return true;
    }

    private long getIncrementalTime(long baseTicks, long ticks) {
        if (ticks > 599266080000000000L) {
            return ticks;
        }
        return baseTicks + ticks;
    }
}

