/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.chartdata;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.chartdata.ChartDataChange;
import com.t4login.definitions.priceconversion.IMarketConversion;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.definitions.priceconversion.VPT;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ChartDataState
implements IMarketConversion {
    public static final ChartDataState empty = new ChartDataState();
    public ChartDataChange Change = ChartDataChange.None;
    public NDateTime TradeDate = NDateTime.MinValue;
    public long TradeDateTicks;
    public boolean MarketDefined = false;
    public String MarketID = "";
    public int Numerator = 0;
    public int Denominator = 0;
    public String PriceCode = "";
    public double TickValue = 0.0;
    public String VPT = "";
    public Price MinCabPrice = null;
    public Price MinPriceIncrement;
    public BigDecimal PointValue;
    public int LastTTV = 0;
    public long LastTimeTicks = 0L;
    public Price LastTradePrice = null;
    public BigDecimal LastPriceIncrements = BigDecimal.ZERO;
    public int TradeVolume = 0;
    public BidOffer AtBidOrOffer = BidOffer.Undefined;
    public int[] OrderVolumes = new int[0];
    public boolean DueToSpread = false;
    public int OrderVolumeIndex = 0;
    public long BarStartTime = 0L;
    public long BarCloseTime = 0L;
    public Price BarOpenPrice = Price.Zero;
    public Price BarHighPrice = Price.Zero;
    public Price BarLowPrice = Price.Zero;
    public Price BarClosePrice = Price.Zero;
    public int BarVolume = 0;
    public int BarBidVolume = 0;
    public int BarOfferVolume = 0;
    public int BarTrades = 0;
    public int BarTradesAtBid = 0;
    public int BarTradesAtOffer = 0;
    public long TPOStartTime = 0L;
    public Price TPOBasePrice = Price.Zero;
    public Price TPOPrice = null;
    public int TPOVolume = 0;
    public int TPOVolumeAtBid = 0;
    public int TPOVolumeAtOffer = 0;
    public boolean TPOIsOpening = false;
    public boolean TPOIsClosing = false;
    public Price BidPrice = null;
    public int BidRealVolume = 0;
    public int BidImpliedVolume = 0;
    public Price OfferPrice = null;
    public int OfferRealVolume = 0;
    public int OfferImpliedVolume = 0;
    public MarketMode Mode = MarketMode.Undefined;
    public Price SettlementPrice = null;
    public Price SettlementHeldPrice = null;
    public int ClearedVolume = 0;
    public int OpenInterest = 0;
    public Price VWAP = null;
    public BidOffer RFQBuySell = BidOffer.Undefined;
    public int RFQVolume = 0;
    public BigDecimal LastBarLowPriceIncrements = BigDecimal.ZERO;
    public BigDecimal LastTPOBasePriceIncrements = BigDecimal.ZERO;
    public BigDecimal LastBidPriceIncrements = BigDecimal.ZERO;

    @Override
    public String getMarketID() {
        return this.MarketID;
    }

    @Override
    public int getDenominator() {
        return this.Denominator;
    }

    @Override
    public String getPriceCode() {
        return this.PriceCode;
    }

    @Override
    public Price getMinPriceIncrement() {
        if (this.MinPriceIncrement == null || this.MinPriceIncrement.equals(Price.Zero)) {
            this.MinPriceIncrement = new Price(new BigDecimal(this.Numerator).divide(new BigDecimal(this.Denominator), 18, RoundingMode.HALF_EVEN));
        }
        return this.MinPriceIncrement;
    }

    @Override
    public VPT getVPT() {
        return null;
    }

    @Override
    public Price getMinCabPrice() {
        return null;
    }

    @Override
    public int getRealDecimals() {
        return 0;
    }

    @Override
    public int getClearingDecimals() {
        return 0;
    }

    @Override
    public BigDecimal getPointValue() {
        if (this.PointValue == null || this.PointValue.equals(BigDecimal.ZERO)) {
            this.PointValue = new BigDecimal(this.TickValue).divide(new BigDecimal(this.Numerator), 18, RoundingMode.HALF_EVEN).multiply(new BigDecimal(this.Denominator));
        }
        return this.PointValue;
    }

    @Override
    public Integer getYieldYears() {
        return null;
    }

    @Override
    public Double getYieldParValue() {
        return null;
    }

    @Override
    public Double getYieldRate() {
        return null;
    }

    @Override
    public Integer getYieldValueDenominator() {
        return null;
    }

    @Override
    public Double getYieldRedemption() {
        return null;
    }

    @Override
    public Double getYieldPaymentsPerYear() {
        return null;
    }

    @Override
    public Integer getYieldBasis() {
        return null;
    }
}

