/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions.chartdata;

import java.util.HashMap;
import java.util.Map;

public enum ChartDataChange {
    None(0),
    Trade(1),
    Quote(2),
    MarketMode(3),
    Settlement(4),
    TradeBar(5),
    TradeDate(6),
    TPO(7),
    TickChange(8),
    RFQ(9),
    HeldSettlement(10),
    ClearedVolume(11),
    OpenInterest(12),
    VWAP(13),
    MarketSwitch(14),
    MarketDefinition(15);

    private final int value;
    private static Map<Integer, ChartDataChange> map;

    private ChartDataChange(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ChartDataChange get(int value) {
        return map.get(value);
    }

    static {
        map = new HashMap<Integer, ChartDataChange>();
        for (ChartDataChange t : ChartDataChange.values()) {
            map.put(t.getValue(), t);
        }
    }
}

