/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class UDSStatus
implements Serializable {
    private static final String TAG = "UDSStatus";
    @Constant(value=0)
    public static final UDSStatus Unknown;
    @Constant(value=1)
    public static final UDSStatus Success;
    @Constant(value=2)
    public static final UDSStatus Failed;
    @Constant(value=3)
    public static final UDSStatus AlreadyExists;
    private final int value;
    private final String name;
    private static Map<Integer, UDSStatus> map;
    private static UDSStatus[] mValues;

    private UDSStatus(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static UDSStatus get(int value) {
        UDSStatus val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new UDSStatus(value, Integer.toString(value));
            map.put(value, val);
            ArrayList<UDSStatus> values = new ArrayList<UDSStatus>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new UDSStatus[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public UDSStatus[] values() {
        return mValues;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof UDSStatus && this.value == ((UDSStatus)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, UDSStatus>();
        ArrayList<UDSStatus> values = new ArrayList<UDSStatus>();
        Unknown = new UDSStatus(0, "Unknown");
        values.add(Unknown);
        Success = new UDSStatus(1, "Success");
        values.add(Success);
        Failed = new UDSStatus(2, "Failed");
        values.add(Failed);
        AlreadyExists = new UDSStatus(3, "AlreadyExists");
        values.add(AlreadyExists);
        for (UDSStatus t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new UDSStatus[values.size()];
        values.toArray(mValues);
    }
}

