/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class TwoFactorTokenRequestType {
    private static final String TAG = "TwoFactorTokenRequestType";
    @Constant(value=-1)
    public static final TwoFactorTokenRequestType WarnNotConfigured;
    @Constant(value=0)
    public static final TwoFactorTokenRequestType InitialRequest;
    @Constant(value=1)
    public static final TwoFactorTokenRequestType InvalidToken;
    @Constant(value=2)
    public static final TwoFactorTokenRequestType TokenExpired;
    @Constant(value=3)
    public static final TwoFactorTokenRequestType ResendRequest;
    private final int value;
    private final String name;
    private static Map<Integer, TwoFactorTokenRequestType> map;
    private static TwoFactorTokenRequestType[] mValues;

    private TwoFactorTokenRequestType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static TwoFactorTokenRequestType get(int value) {
        TwoFactorTokenRequestType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new TwoFactorTokenRequestType(value, "?" + Integer.toString(value));
            map.put(value, val);
            ArrayList<TwoFactorTokenRequestType> values = new ArrayList<TwoFactorTokenRequestType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new TwoFactorTokenRequestType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return "TwoFactorTokenRequestType." + this.name;
    }

    static {
        map = new HashMap<Integer, TwoFactorTokenRequestType>();
        ArrayList<TwoFactorTokenRequestType> values = new ArrayList<TwoFactorTokenRequestType>();
        WarnNotConfigured = new TwoFactorTokenRequestType(-1, "WarnNotConfigured");
        values.add(WarnNotConfigured);
        InitialRequest = new TwoFactorTokenRequestType(0, "InitialRequest");
        values.add(InitialRequest);
        InvalidToken = new TwoFactorTokenRequestType(1, "InvalidToken");
        values.add(InvalidToken);
        TokenExpired = new TwoFactorTokenRequestType(2, "TokenExpired");
        values.add(TokenExpired);
        ResendRequest = new TwoFactorTokenRequestType(3, "ResendRequest");
        values.add(ResendRequest);
        for (TwoFactorTokenRequestType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new TwoFactorTokenRequestType[values.size()];
        values.toArray(mValues);
    }
}

