/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class TwoFactorRequest {
    private static final String TAG = "TwoFactorRequest";
    @Constant(value=0)
    public static final TwoFactorRequest AccountVerificationRequest;
    @Constant(value=1)
    public static final TwoFactorRequest TwoFactorAuthenticationRequest;
    private final int value;
    private final String name;
    private static Map<Integer, TwoFactorRequest> map;
    private static TwoFactorRequest[] mValues;

    private TwoFactorRequest(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static TwoFactorRequest get(int value) {
        TwoFactorRequest val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new TwoFactorRequest(value, "?" + Integer.toString(value));
            map.put(value, val);
            ArrayList<TwoFactorRequest> values = new ArrayList<TwoFactorRequest>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new TwoFactorRequest[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return "TwoFactorRequest." + this.name;
    }

    static {
        map = new HashMap<Integer, TwoFactorRequest>();
        ArrayList<TwoFactorRequest> values = new ArrayList<TwoFactorRequest>();
        AccountVerificationRequest = new TwoFactorRequest(0, "AccountVerificationRequest");
        values.add(AccountVerificationRequest);
        TwoFactorAuthenticationRequest = new TwoFactorRequest(1, "TwoFactorAuthenticationRequest");
        values.add(TwoFactorAuthenticationRequest);
        for (TwoFactorRequest t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new TwoFactorRequest[values.size()];
        values.toArray(mValues);
    }
}

