/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class TwoFactorAuthorizationType {
    private static final String TAG = "TwoFactorAuthorizationType";
    @Constant(value=0)
    public static final TwoFactorAuthorizationType Forever;
    @Constant(value=1)
    public static final TwoFactorAuthorizationType ThirtyDays;
    @Constant(value=2)
    public static final TwoFactorAuthorizationType SessionOnly;
    @Constant(value=3)
    public static final TwoFactorAuthorizationType Banned;
    private final int value;
    private final String name;
    private static Map<Integer, TwoFactorAuthorizationType> map;
    private static TwoFactorAuthorizationType[] mValues;

    private TwoFactorAuthorizationType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static TwoFactorAuthorizationType get(int value) {
        TwoFactorAuthorizationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new TwoFactorAuthorizationType(value, "?" + Integer.toString(value));
            map.put(value, val);
            ArrayList<TwoFactorAuthorizationType> values = new ArrayList<TwoFactorAuthorizationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new TwoFactorAuthorizationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return "TwoFactorAuthorizationType." + this.name;
    }

    static {
        map = new HashMap<Integer, TwoFactorAuthorizationType>();
        ArrayList<TwoFactorAuthorizationType> values = new ArrayList<TwoFactorAuthorizationType>();
        Forever = new TwoFactorAuthorizationType(0, "Forever");
        values.add(Forever);
        ThirtyDays = new TwoFactorAuthorizationType(1, "ThirtyDays");
        values.add(ThirtyDays);
        SessionOnly = new TwoFactorAuthorizationType(2, "SessionOnly");
        values.add(SessionOnly);
        Banned = new TwoFactorAuthorizationType(3, "Banned");
        values.add(Banned);
        for (TwoFactorAuthorizationType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new TwoFactorAuthorizationType[values.size()];
        values.toArray(mValues);
    }
}

