/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.Log;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.MarketMode;
import com.t4login.util.TimeRange;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TradingSchedule {
    private static final String TAG = "TradingSchedule";
    public List<TradeDate> TradeDates;
    private List<TimeRange> AllOpenSessions = null;

    public static TradingSchedule fromPackedString(String packedString) {
        String[] parts = packedString.split("\\)");
        TradeDate first = null;
        TradeDate prev = null;
        ArrayList<TradeDate> tradeDates = new ArrayList<TradeDate>();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            prev = TradeDate.fromPackedString(part, first, prev);
            if (first == null) {
                first = prev;
            }
            tradeDates.add(prev);
        }
        return new TradingSchedule(tradeDates);
    }

    public TradingSchedule(List<TradeDate> tradeDates) {
        this.TradeDates = tradeDates;
        this.AllOpenSessions = new ArrayList<TimeRange>();
        Stream allSessionEvents = this.TradeDates.stream().flatMap(td -> td.sessionEvents.stream());
        SessionEvent openEvent = null;
        for (SessionEvent event : allSessionEvents.collect(Collectors.toList())) {
            if (event.mode == MarketMode.Open) {
                openEvent = event;
                continue;
            }
            if (openEvent == null) continue;
            this.AllOpenSessions.add(new TimeRange(openEvent.time, event.time));
            openEvent = null;
        }
    }

    public MarketMode getMarketMode(NDateTime time, NDateTime lastTradingDate) {
        if (this.TradeDates.size() > 0 && time.compareTo(lastTradingDate) >= 0) {
            return MarketMode.Expired;
        }
        MarketMode result = MarketMode.Undefined;
        if (this.TradeDates.size() > 0) {
            result = MarketMode.Closed;
        }
        for (TradeDate tradeDate : this.TradeDates) {
            for (SessionEvent event : tradeDate.sessionEvents) {
                if (time.compareTo(event.time) <= 0) continue;
                result = event.mode;
            }
        }
        return result;
    }

    public NDateTime getNextOpenTime(NDateTime time, NDateTime lastTradingDate) {
        SessionEvent event = this.getNextEvent(time, MarketMode.Open, lastTradingDate);
        if (event != null) {
            return event.time;
        }
        return null;
    }

    public NDateTime getNextClosedTime(NDateTime time, NDateTime lastTradingDate) {
        if (time.compareTo(lastTradingDate) > 0) {
            return null;
        }
        NDateTime nextClosed = this.getNextClosedTime(time);
        if (nextClosed != null && nextClosed.compareTo(lastTradingDate) >= 0) {
            return lastTradingDate;
        }
        return nextClosed;
    }

    public NDateTime getNextClosedTime(NDateTime time) {
        for (TradeDate td : this.TradeDates) {
            boolean before = false;
            boolean after = false;
            for (SessionEvent se : td.sessionEvents) {
                if (se.time.compareTo(time) < 0) {
                    before = true;
                }
                if (se.time.compareTo(time) <= 0) continue;
                after = true;
            }
            if (!before || !after) continue;
            SessionEvent endSession = null;
            for (SessionEvent se : td.sessionEvents) {
                if (se.mode.equals(MarketMode.Open)) {
                    endSession = null;
                }
                if (!se.mode.equals(MarketMode.Closed) && !se.mode.equals(MarketMode.Halted) || se.time.compareTo(time) <= 0 || endSession != null) continue;
                endSession = se;
            }
            if (endSession == null) continue;
            return endSession.time;
        }
        return null;
    }

    public SessionEvent getNextEvent(NDateTime time, NDateTime lastTradingDate) {
        return this.getNextEvent(time, new ArrayList<MarketMode>(), lastTradingDate);
    }

    public SessionEvent getNextEvent(NDateTime time, MarketMode mode, NDateTime lastTradingDate) {
        ArrayList<MarketMode> modes = new ArrayList<MarketMode>();
        modes.add(mode);
        return this.getNextEvent(time, modes, lastTradingDate);
    }

    public SessionEvent getNextEvent(NDateTime time, List<MarketMode> modes, NDateTime lastTradingDate) {
        if (time.compareTo(lastTradingDate) > 0) {
            return null;
        }
        for (TradeDate td : this.TradeDates) {
            for (SessionEvent se : td.sessionEvents) {
                if (modes != null && modes.size() != 0 && !modes.contains(se.mode) || se.time.compareTo(time) <= 0) continue;
                if (se.time.compareTo(lastTradingDate) >= 0) {
                    return new SessionEvent(MarketMode.Expired, lastTradingDate);
                }
                return se;
            }
        }
        return null;
    }

    public List<TimeRange> getOpenSessions() {
        return this.AllOpenSessions;
    }

    public List<TimeRange> getOpenSessions(NDateTime tradeDate) {
        return this.TradeDates.stream().filter(td -> td.tradeDate.equals(tradeDate)).flatMap(td -> {
            ArrayList<TimeRange> openSessions = new ArrayList<TimeRange>();
            SessionEvent openEvent = null;
            for (SessionEvent event : td.sessionEvents) {
                if (event.mode.equals(MarketMode.Open)) {
                    openEvent = event;
                    continue;
                }
                if (openEvent == null) continue;
                openSessions.add(new TimeRange(openEvent.time, event.time));
                openEvent = null;
            }
            return openSessions.stream();
        }).collect(Collectors.toList());
    }

    public NDateTime getLastTradingDate() {
        if (this.TradeDates.size() > 0) {
            return this.TradeDates.get((int)(this.TradeDates.size() - 1)).tradeDate;
        }
        return null;
    }

    public static class TradeDate {
        public final NDateTime tradeDate;
        public final List<SessionEvent> sessionEvents;
        public final String packedEvents;

        public static TradeDate fromPackedString(String packedString, TradeDate firstTradeDate, TradeDate prevTradeDate) {
            NDateTime tradeDate = NDateTime.MinValue;
            String[] parts = packedString.split("\\(");
            if (parts.length > 0) {
                tradeDate = parts[0].length() == 0 ? prevTradeDate.tradeDate.AddDays(1.0) : (parts[0].length() == 8 ? NDateTime.fromyyyyMMdd(parts[0]) : prevTradeDate.tradeDate.AddDays(Double.parseDouble(parts[0])));
            }
            ArrayList<SessionEvent> events = new ArrayList<SessionEvent>();
            String packedEvents = "";
            if (parts.length > 1) {
                String[] eventParts;
                String src = parts[1];
                if (parts[1].startsWith("f")) {
                    src = firstTradeDate.packedEvents;
                } else if (parts[1].startsWith("p")) {
                    src = prevTradeDate.packedEvents;
                }
                packedEvents = src;
                for (String eventPart : eventParts = src.split(",")) {
                    SessionEvent event = SessionEvent.fromPackedString(eventPart, tradeDate);
                    if (event == null) continue;
                    events.add(event);
                }
            }
            return new TradeDate(tradeDate, events, packedEvents);
        }

        public TradeDate(NDateTime tradeDate, List<SessionEvent> sessionEvents, String packedEvents) {
            this.tradeDate = tradeDate;
            this.sessionEvents = sessionEvents;
            this.packedEvents = packedEvents;
        }
    }

    public static class SessionEvent
    implements Comparable<SessionEvent> {
        private static final long tickMultiplier = 1000000000L;
        public final MarketMode mode;
        public final NDateTime time;

        public static SessionEvent fromPackedString(String packedString, NDateTime tradeDate) {
            String[] parts = packedString.split("=");
            if (parts.length > 1) {
                MarketMode mode = MarketMode.get(Integer.parseInt(parts[0]));
                if (mode != null) {
                    BigDecimal timeDelta = new BigDecimal(parts[1]);
                    long timeDeltaTicks = timeDelta.multiply(new BigDecimal(1000000000L)).longValue();
                    NDateTime time = tradeDate.AddTicks(timeDeltaTicks);
                    return new SessionEvent(mode, time);
                }
                Log.e(TradingSchedule.TAG, "fromPackedString(), '" + parts[0] + "' is not a valid market mode.");
            }
            return null;
        }

        public SessionEvent(MarketMode mode, NDateTime time) {
            this.mode = mode;
            this.time = time;
        }

        @Override
        public int compareTo(SessionEvent other) {
            return this.time.compareTo(other.time);
        }
    }
}

