/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class TimeType
implements Serializable {
    private static final String TAG = "TimeType";
    @Constant(value=-1)
    public static final TimeType Undefined;
    @Constant(value=0)
    public static final TimeType Normal;
    @Constant(value=1)
    public static final TimeType ImmediateAndCancel;
    @Constant(value=2)
    public static final TimeType GoodTillCancelled;
    @Constant(value=3)
    public static final TimeType CompleteVolume;
    @Constant(value=4)
    public static final TimeType MarketOnOpen;
    @Constant(value=5)
    public static final TimeType MarketOnClose;
    private final int value;
    private final String descr_loc;
    private static Map<Integer, TimeType> map;
    private static TimeType[] mValues;

    private TimeType(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static TimeType get(int value) {
        TimeType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new TimeType(value, null);
            map.put(value, val);
            ArrayList<TimeType> values = new ArrayList<TimeType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new TimeType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public TimeType[] values() {
        return mValues;
    }

    public String toString() {
        return "TimeType(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof TimeType && this.value == ((TimeType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, TimeType>();
        ArrayList<TimeType> values = new ArrayList<TimeType>();
        Undefined = new TimeType(-1, "timetype_undefined");
        values.add(Undefined);
        Normal = new TimeType(0, "timetype_normal");
        values.add(Normal);
        ImmediateAndCancel = new TimeType(1, "timetype_immediateandcancel");
        values.add(ImmediateAndCancel);
        GoodTillCancelled = new TimeType(2, "timetype_goodtillcancelled");
        values.add(GoodTillCancelled);
        CompleteVolume = new TimeType(3, "timetype_completevolume");
        values.add(CompleteVolume);
        MarketOnOpen = new TimeType(4, "timetype_marketonopen");
        values.add(MarketOnOpen);
        MarketOnClose = new TimeType(5, "timetype_marketonclose");
        values.add(MarketOnClose);
        for (TimeType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new TimeType[values.size()];
        values.toArray(mValues);
    }
}

