/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ThreeState
implements Serializable {
    private static final String TAG = "ThreeState";
    @Constant(value=-1)
    public static final ThreeState True;
    @Constant(value=0)
    public static final ThreeState False;
    @Constant(value=1)
    public static final ThreeState NotSpecified;
    private final int value;
    private static Map<Integer, ThreeState> map;
    private static ThreeState[] mValues;

    public static ThreeState valueOf(boolean value) {
        if (value) {
            return True;
        }
        return False;
    }

    private ThreeState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        switch (this.value) {
            case -1: {
                return "true";
            }
            case 0: {
                return "false";
            }
        }
        return "not specified";
    }

    public static ThreeState get(int value) {
        ThreeState val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new ThreeState(value);
            map.put(value, val);
            ArrayList<ThreeState> values = new ArrayList<ThreeState>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ThreeState[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ThreeState[] values() {
        return mValues;
    }

    public String toString() {
        return this.getDescription() + "(" + this.value + ")";
    }

    public boolean equals(Object o) {
        return o instanceof ThreeState && this.value == ((ThreeState)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, ThreeState>();
        ArrayList<ThreeState> values = new ArrayList<ThreeState>();
        True = new ThreeState(-1);
        values.add(True);
        False = new ThreeState(0);
        values.add(False);
        NotSpecified = new ThreeState(1);
        values.add(NotSpecified);
        for (ThreeState t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ThreeState[values.size()];
        values.toArray(mValues);
    }
}

