/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class StrikeConversionMethod {
    private static final String TAG = "StrikeConversionMethod";
    @Constant(value=-1)
    public static final StrikeConversionMethod NoConversion;
    @Constant(value=0)
    public static final StrikeConversionMethod FromDisplay;
    @Constant(value=1)
    public static final StrikeConversionMethod FromShortDecimalEighths;
    @Constant(value=2)
    public static final StrikeConversionMethod FromDecimal;
    @Constant(value=3)
    public static final StrikeConversionMethod FromRealDecimal;
    @Constant(value=4)
    public static final StrikeConversionMethod FromClearingDecimal;
    private final int value;
    private static final Map<Integer, StrikeConversionMethod> map;
    private static StrikeConversionMethod[] mValues;

    StrikeConversionMethod(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static StrikeConversionMethod get(int value) {
        StrikeConversionMethod val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new StrikeConversionMethod(value);
            map.put(value, val);
            ArrayList<StrikeConversionMethod> values = new ArrayList<StrikeConversionMethod>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new StrikeConversionMethod[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public StrikeConversionMethod[] values() {
        return mValues;
    }

    public String toString() {
        return "StrikeConversionMethod(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, StrikeConversionMethod>();
        ArrayList<StrikeConversionMethod> values = new ArrayList<StrikeConversionMethod>();
        NoConversion = new StrikeConversionMethod(-1);
        values.add(NoConversion);
        FromDisplay = new StrikeConversionMethod(0);
        values.add(FromDisplay);
        FromShortDecimalEighths = new StrikeConversionMethod(1);
        values.add(FromShortDecimalEighths);
        FromDecimal = new StrikeConversionMethod(2);
        values.add(FromDecimal);
        FromRealDecimal = new StrikeConversionMethod(3);
        values.add(FromRealDecimal);
        FromClearingDecimal = new StrikeConversionMethod(4);
        values.add(FromClearingDecimal);
        for (StrikeConversionMethod t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new StrikeConversionMethod[values.size()];
        values.toArray(mValues);
    }
}

