/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.util.SortUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class StrategyType
implements Comparable<StrategyType>,
Serializable {
    private static final String TAG = "StrategyType";
    @Constant(value=-1)
    public static final StrategyType Any;
    @Constant(value=0)
    public static final StrategyType None;
    @Constant(value=1)
    public static final StrategyType CalendarSpread;
    @Constant(value=2)
    public static final StrategyType RTCalendarSpread;
    @Constant(value=3)
    public static final StrategyType InterContractSpread;
    @Constant(value=4)
    public static final StrategyType Butterfly;
    @Constant(value=5)
    public static final StrategyType Condor;
    @Constant(value=6)
    public static final StrategyType DoubleButterfly;
    @Constant(value=7)
    public static final StrategyType Horizontal;
    @Constant(value=8)
    public static final StrategyType Bundle;
    @Constant(value=9)
    public static final StrategyType MonthVsPack;
    @Constant(value=10)
    public static final StrategyType Pack;
    @Constant(value=11)
    public static final StrategyType PackSpread;
    @Constant(value=12)
    public static final StrategyType PackButterfly;
    @Constant(value=13)
    public static final StrategyType BundleSpread;
    @Constant(value=14)
    public static final StrategyType Strip;
    @Constant(value=15)
    public static final StrategyType Crack;
    @Constant(value=16)
    public static final StrategyType TreasurySpread;
    @Constant(value=17)
    public static final StrategyType Crush;
    @Constant(value=19)
    public static final StrategyType ThreeWay;
    @Constant(value=20)
    public static final StrategyType ThreeWayStraddleVsCall;
    @Constant(value=21)
    public static final StrategyType ThreeWayStraddleVsPut;
    @Constant(value=22)
    public static final StrategyType Box;
    @Constant(value=23)
    public static final StrategyType XmasTree;
    @Constant(value=24)
    public static final StrategyType ConditionalCurve;
    @Constant(value=25)
    public static final StrategyType Double;
    @Constant(value=26)
    public static final StrategyType HorizontalStraddle;
    @Constant(value=27)
    public static final StrategyType IronCondor;
    @Constant(value=28)
    public static final StrategyType Ratio1x2;
    @Constant(value=29)
    public static final StrategyType Ratio1x3;
    @Constant(value=30)
    public static final StrategyType Ratio2x3;
    @Constant(value=31)
    public static final StrategyType RiskReversal;
    @Constant(value=32)
    public static final StrategyType StraddleStrip;
    @Constant(value=33)
    public static final StrategyType Straddle;
    @Constant(value=34)
    public static final StrategyType Strangle;
    @Constant(value=35)
    public static final StrategyType Vertical;
    @Constant(value=36)
    public static final StrategyType JellyRoll;
    @Constant(value=37)
    public static final StrategyType IronButterfly;
    @Constant(value=38)
    public static final StrategyType Guts;
    @Constant(value=39)
    public static final StrategyType Generic;
    @Constant(value=40)
    public static final StrategyType Diagonal;
    @Constant(value=41)
    public static final StrategyType CoveredThreeWay;
    @Constant(value=42)
    public static final StrategyType CoveredThreeWayStraddleVsCall;
    @Constant(value=43)
    public static final StrategyType CoveredThreeWayStraddleVsPut;
    @Constant(value=44)
    public static final StrategyType CoveredBox;
    @Constant(value=45)
    public static final StrategyType CoveredXmasTree;
    @Constant(value=46)
    public static final StrategyType CoveredConditionalCurve;
    @Constant(value=47)
    public static final StrategyType CoveredDouble;
    @Constant(value=48)
    public static final StrategyType CoveredHorizontalStraddle;
    @Constant(value=49)
    public static final StrategyType CoveredIronCondor;
    @Constant(value=50)
    public static final StrategyType CoveredRatio1x2;
    @Constant(value=51)
    public static final StrategyType CoveredRatio1x3;
    @Constant(value=52)
    public static final StrategyType CoveredRatio2x3;
    @Constant(value=53)
    public static final StrategyType CoveredRiskReversal;
    @Constant(value=54)
    public static final StrategyType CoveredStraddleStrip;
    @Constant(value=55)
    public static final StrategyType CoveredStraddle;
    @Constant(value=56)
    public static final StrategyType CoveredStrangle;
    @Constant(value=57)
    public static final StrategyType CoveredVertical;
    @Constant(value=58)
    public static final StrategyType CoveredJellyRoll;
    @Constant(value=59)
    public static final StrategyType CoveredIronButterfly;
    @Constant(value=60)
    public static final StrategyType CoveredGuts;
    @Constant(value=61)
    public static final StrategyType CoveredGeneric;
    @Constant(value=62)
    public static final StrategyType CoveredDiagonal;
    @Constant(value=63)
    public static final StrategyType CoveredButterfly;
    @Constant(value=64)
    public static final StrategyType CoveredCondor;
    @Constant(value=65)
    public static final StrategyType CoveredHorizontal;
    @Constant(value=66)
    public static final StrategyType CoveredStrip;
    @Constant(value=67)
    public static final StrategyType CoveredOption;
    @Constant(value=68)
    public static final StrategyType BalancedStrip;
    @Constant(value=69)
    public static final StrategyType UnbalancedStrip;
    @Constant(value=70)
    public static final StrategyType InterContractStrip;
    @Constant(value=71)
    public static final StrategyType InvoiceSwap;
    @Constant(value=72)
    public static final StrategyType InterestRateSwap;
    @Constant(value=73)
    public static final StrategyType AveragePriceStrip;
    @Constant(value=74)
    public static final StrategyType TreasuryTail;
    @Constant(value=75)
    public static final StrategyType AveragePriceStripSpread;
    @Constant(value=76)
    public static final StrategyType InvoiceSwapCalendar;
    @Constant(value=77)
    public static final StrategyType InvoiceSwapSwitches;
    @Constant(value=78)
    public static final StrategyType VolatilityQuotedOption;
    @Constant(value=79)
    public static final StrategyType FXSpot;
    @Constant(value=80)
    public static final StrategyType AveragePriceBundle;
    @Constant(value=81)
    public static final StrategyType FixedPriceRatioSpread;
    @Constant(value=82)
    public static final StrategyType SACBOTSoybeanSpread;
    private final int value;
    private final String name;
    private final String descr_loc;
    private final String abbr;
    private static Map<Integer, StrategyType> map;
    private static Map<String, StrategyType> names;
    private static StrategyType[] mValues;

    private StrategyType(int value, String name, String descr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
        this.abbr = name;
    }

    private StrategyType(int value, String name, String descr_loc, String abbreviation) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
        this.abbr = abbreviation;
    }

    public int getValue() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public String getAbbreviation() {
        return this.abbr;
    }

    public static StrategyType get(int value) {
        StrategyType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new StrategyType(value, Integer.toString(value), null);
            map.put(value, val);
            names.put(val.name, val);
            ArrayList<StrategyType> values = new ArrayList<StrategyType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new StrategyType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static StrategyType valueOf(String name) {
        return names.get(name);
    }

    public StrategyType[] values() {
        return mValues;
    }

    public String toString() {
        return "StrategyType(" + this.getValue() + ")";
    }

    @Override
    public int compareTo(StrategyType strategyType) {
        return SortUtil.compare(this.value, strategyType.value);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof StrategyType && this.value == ((StrategyType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, StrategyType>();
        names = new HashMap<String, StrategyType>();
        ArrayList<StrategyType> values = new ArrayList<StrategyType>();
        Any = new StrategyType(-1, "Any", "strategytype_any", "");
        values.add(Any);
        None = new StrategyType(0, "None", "strategytype_none", "");
        values.add(None);
        CalendarSpread = new StrategyType(1, "CalendarSpread", "strategytype_calendarspread", "");
        values.add(CalendarSpread);
        RTCalendarSpread = new StrategyType(2, "RTCalendarSpread", "strategytype_rtcalendarspread", "RT");
        values.add(RTCalendarSpread);
        InterContractSpread = new StrategyType(3, "InterContractSpread", "strategytype_intercontractspread", "IC");
        values.add(InterContractSpread);
        Butterfly = new StrategyType(4, "Butterfly", "strategytype_butterfly", "BF");
        values.add(Butterfly);
        Condor = new StrategyType(5, "Condor", "strategytype_condor", "CON");
        values.add(Condor);
        DoubleButterfly = new StrategyType(6, "DoubleButterfly", "strategytype_doublebutterfly", "DBF");
        values.add(DoubleButterfly);
        Horizontal = new StrategyType(7, "Horizontal", "strategytype_horizontal", "HZ");
        values.add(Horizontal);
        Bundle = new StrategyType(8, "Bundle", "strategytype_bundle", "BUN");
        values.add(Bundle);
        MonthVsPack = new StrategyType(9, "MonthVsPack", "strategytype_monthvspack", "MvP");
        values.add(MonthVsPack);
        Pack = new StrategyType(10, "Pack", "strategytype_pack", "PK");
        values.add(Pack);
        PackSpread = new StrategyType(11, "PackSpread", "strategytype_packspread", "PKS");
        values.add(PackSpread);
        PackButterfly = new StrategyType(12, "PackButterfly", "strategytype_packbutterfly", "PKB");
        values.add(PackButterfly);
        BundleSpread = new StrategyType(13, "BundleSpread", "strategytype_bundlespread", "BUNS");
        values.add(BundleSpread);
        Strip = new StrategyType(14, "Strip", "strategytype_strip", "STP");
        values.add(Strip);
        Crack = new StrategyType(15, "Crack", "strategytype_crack", "Crack");
        values.add(Crack);
        TreasurySpread = new StrategyType(16, "TreasurySpread", "strategytype_treasuryspread", "TSYS");
        values.add(TreasurySpread);
        Crush = new StrategyType(17, "Crush", "strategytype_crush", "Crush");
        values.add(Crush);
        ThreeWay = new StrategyType(19, "ThreeWay", "strategytype_threeway", "3W");
        values.add(ThreeWay);
        ThreeWayStraddleVsCall = new StrategyType(20, "ThreeWayStraddleVsCall", "strategytype_threewaystraddlevscall");
        values.add(ThreeWayStraddleVsCall);
        ThreeWayStraddleVsPut = new StrategyType(21, "ThreeWayStraddleVsPut", "strategytype_threewaystraddlevsput");
        values.add(ThreeWayStraddleVsPut);
        Box = new StrategyType(22, "Box", "strategytype_box");
        values.add(Box);
        XmasTree = new StrategyType(23, "XmasTree", "strategytype_xmastree", "XT");
        values.add(XmasTree);
        ConditionalCurve = new StrategyType(24, "ConditionalCurve", "strategytype_conditionalcurve");
        values.add(ConditionalCurve);
        Double = new StrategyType(25, "Double", "strategytype_double", "DBL");
        values.add(Double);
        HorizontalStraddle = new StrategyType(26, "HorizontalStraddle", "strategytype_horizontalstraddle");
        values.add(HorizontalStraddle);
        IronCondor = new StrategyType(27, "IronCondor", "strategytype_ironcondor");
        values.add(IronCondor);
        Ratio1x2 = new StrategyType(28, "Ratio1x2", "strategytype_ratio1x2", "R1x2");
        values.add(Ratio1x2);
        Ratio1x3 = new StrategyType(29, "Ratio1x3", "strategytype_ratio1x3", "R1x3");
        values.add(Ratio1x3);
        Ratio2x3 = new StrategyType(30, "Ratio2x3", "strategytype_ratio2x3", "R2x3");
        values.add(Ratio2x3);
        RiskReversal = new StrategyType(31, "RiskReversal", "strategytype_riskreversal", "RR");
        values.add(RiskReversal);
        StraddleStrip = new StrategyType(32, "StraddleStrip", "strategytype_straddlestrip");
        values.add(StraddleStrip);
        Straddle = new StrategyType(33, "Straddle", "strategytype_straddle", "STD");
        values.add(Straddle);
        Strangle = new StrategyType(34, "Strangle", "strategytype_strangle", "STG");
        values.add(Strangle);
        Vertical = new StrategyType(35, "Vertical", "strategytype_vertical", "VT");
        values.add(Vertical);
        JellyRoll = new StrategyType(36, "JellyRoll", "strategytype_jellyroll");
        values.add(JellyRoll);
        IronButterfly = new StrategyType(37, "IronButterfly", "strategytype_ironbutterfly");
        values.add(IronButterfly);
        Guts = new StrategyType(38, "Guts", "strategytype_guts");
        values.add(Guts);
        Generic = new StrategyType(39, "Generic", "strategytype_generic", "GEN");
        values.add(Generic);
        Diagonal = new StrategyType(40, "Diagonal", "strategytype_diagonal");
        values.add(Diagonal);
        CoveredThreeWay = new StrategyType(41, "CoveredThreeWay", "strategytype_coveredthreeway");
        values.add(CoveredThreeWay);
        CoveredThreeWayStraddleVsCall = new StrategyType(42, "CoveredThreeWayStraddleVsCall", "strategytype_coveredthreewaystraddlevscall");
        values.add(CoveredThreeWayStraddleVsCall);
        CoveredThreeWayStraddleVsPut = new StrategyType(43, "CoveredThreeWayStraddleVsPut", "strategytype_coveredthreewaystraddlevsput");
        values.add(CoveredThreeWayStraddleVsPut);
        CoveredBox = new StrategyType(44, "CoveredBox", "strategytype_coveredbox");
        values.add(CoveredBox);
        CoveredXmasTree = new StrategyType(45, "CoveredXmasTree", "strategytype_coveredxmastree");
        values.add(CoveredXmasTree);
        CoveredConditionalCurve = new StrategyType(46, "CoveredConditionalCurve", "strategytype_coveredconditionalcurve");
        values.add(CoveredConditionalCurve);
        CoveredDouble = new StrategyType(47, "CoveredDouble", "strategytype_covereddouble");
        values.add(CoveredDouble);
        CoveredHorizontalStraddle = new StrategyType(48, "CoveredHorizontalStraddle", "strategytype_coveredhorizontalstraddle");
        values.add(CoveredHorizontalStraddle);
        CoveredIronCondor = new StrategyType(49, "CoveredIronCondor", "strategytype_coveredironcondor");
        values.add(CoveredIronCondor);
        CoveredRatio1x2 = new StrategyType(50, "CoveredRatio1x2", "strategytype_coveredratio1x2");
        values.add(CoveredRatio1x2);
        CoveredRatio1x3 = new StrategyType(51, "CoveredRatio1x3", "strategytype_coveredratio1x3");
        values.add(CoveredRatio1x3);
        CoveredRatio2x3 = new StrategyType(52, "CoveredRatio2x3", "strategytype_coveredratio2x3");
        values.add(CoveredRatio2x3);
        CoveredRiskReversal = new StrategyType(53, "CoveredRiskReversal", "strategytype_coveredriskreversal");
        values.add(CoveredRiskReversal);
        CoveredStraddleStrip = new StrategyType(54, "CoveredStraddleStrip", "strategytype_coveredstraddlestrip");
        values.add(CoveredStraddleStrip);
        CoveredStraddle = new StrategyType(55, "CoveredStraddle", "strategytype_coveredstraddle");
        values.add(CoveredStraddle);
        CoveredStrangle = new StrategyType(56, "CoveredStrangle", "strategytype_coveredstrangle");
        values.add(CoveredStrangle);
        CoveredVertical = new StrategyType(57, "CoveredVertical", "strategytype_coveredvertical");
        values.add(CoveredVertical);
        CoveredJellyRoll = new StrategyType(58, "CoveredJellyRoll", "strategytype_coveredjellyroll");
        values.add(CoveredJellyRoll);
        CoveredIronButterfly = new StrategyType(59, "CoveredIronButterfly", "strategytype_coveredironbutterfly");
        values.add(CoveredIronButterfly);
        CoveredGuts = new StrategyType(60, "CoveredGuts", "strategytype_coveredguts");
        values.add(CoveredGuts);
        CoveredGeneric = new StrategyType(61, "CoveredGeneric", "strategytype_coveredgeneric");
        values.add(CoveredGeneric);
        CoveredDiagonal = new StrategyType(62, "CoveredDiagonal", "strategytype_covereddiagonal");
        values.add(CoveredDiagonal);
        CoveredButterfly = new StrategyType(63, "CoveredButterfly", "strategytype_coveredbutterfly");
        values.add(CoveredButterfly);
        CoveredCondor = new StrategyType(64, "CoveredCondor", "strategytype_coveredcondor");
        values.add(CoveredCondor);
        CoveredHorizontal = new StrategyType(65, "CoveredHorizontal", "strategytype_coveredhorizontal");
        values.add(CoveredHorizontal);
        CoveredStrip = new StrategyType(66, "CoveredStrip", "strategytype_coveredstrip");
        values.add(CoveredStrip);
        CoveredOption = new StrategyType(67, "CoveredOption", "strategytype_coveredoption", "COption");
        values.add(CoveredOption);
        BalancedStrip = new StrategyType(68, "BalancedStrip", "strategytype_balancedstrip");
        values.add(BalancedStrip);
        UnbalancedStrip = new StrategyType(69, "UnbalancedStrip", "strategytype_unbalancedstrip");
        values.add(UnbalancedStrip);
        InterContractStrip = new StrategyType(70, "InterContractStrip", "strategytype_intercontractstrip");
        values.add(InterContractStrip);
        InvoiceSwap = new StrategyType(71, "InvoiceSwap", "strategytype_invoiceswap");
        values.add(InvoiceSwap);
        InterestRateSwap = new StrategyType(72, "InterestRateSwap", "strategytype_interestrateswap");
        values.add(InterestRateSwap);
        AveragePriceStrip = new StrategyType(73, "AveragePriceStrip", "strategytype_averagepricestrip", "APS");
        values.add(AveragePriceStrip);
        TreasuryTail = new StrategyType(74, "TreasuryTail", "strategytype_treasurytail");
        values.add(TreasuryTail);
        AveragePriceStripSpread = new StrategyType(75, "AveragePriceStripSpread", "strategytype_averagepricestripspread", "APSS");
        values.add(AveragePriceStripSpread);
        InvoiceSwapCalendar = new StrategyType(76, "InvoiceSwapCalendar", "strategytype_invoiceswapcalendar");
        values.add(InvoiceSwapCalendar);
        InvoiceSwapSwitches = new StrategyType(77, "InvoiceSwapSwitches", "strategytype_invoiceswapswitches");
        values.add(InvoiceSwapSwitches);
        VolatilityQuotedOption = new StrategyType(78, "VolatilityQuotedOption", "strategytype_volatilityquotedoption");
        values.add(VolatilityQuotedOption);
        FXSpot = new StrategyType(79, "FXSpot", "strategytype_fxspot");
        values.add(FXSpot);
        AveragePriceBundle = new StrategyType(80, "AveragePriceBundle", "strategytype_averagepricebundle");
        values.add(AveragePriceBundle);
        FixedPriceRatioSpread = new StrategyType(81, "FixedPriceRatioSpread", "strategytype_fixedpriceratiospread");
        values.add(FixedPriceRatioSpread);
        SACBOTSoybeanSpread = new StrategyType(82, "SACBOTSoybeanSpread", "strategytype_sacbotsoybeanspread");
        values.add(SACBOTSoybeanSpread);
        for (StrategyType t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new StrategyType[values.size()];
        values.toArray(mValues);
    }
}

