/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AsEnum
public final class SimpleSignInMethod {
    private static final String TAG = "SimpleSignInMethod";
    @Constant(value=0)
    public static final SimpleSignInMethod None;
    @Constant(value=1)
    public static final SimpleSignInMethod PIN;
    @Constant(value=2)
    public static final SimpleSignInMethod Bio;
    private final int value;
    private final String name;
    private static Map<Integer, SimpleSignInMethod> map;
    private static SimpleSignInMethod[] mValues;

    private SimpleSignInMethod(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static SimpleSignInMethod get(int value) {
        SimpleSignInMethod val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new SimpleSignInMethod(value, "?" + Integer.toString(value));
            map.put(value, val);
            ArrayList<SimpleSignInMethod> values = new ArrayList<SimpleSignInMethod>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new SimpleSignInMethod[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return "SimpleSignInMethod." + this.name;
    }

    public static Set<SimpleSignInMethod> fromFlags(int flags) {
        HashSet<SimpleSignInMethod> ssiMethods = new HashSet<SimpleSignInMethod>();
        for (SimpleSignInMethod flag : mValues) {
            if (flag.getValue() == 0 || (flags & flag.getValue()) != flag.getValue()) continue;
            ssiMethods.add(flag);
        }
        return ssiMethods;
    }

    public static int toFlags(Set<SimpleSignInMethod> set) {
        int flags = 0;
        for (SimpleSignInMethod typ : set) {
            flags |= typ.getValue();
        }
        return flags;
    }

    static {
        map = new HashMap<Integer, SimpleSignInMethod>();
        ArrayList<SimpleSignInMethod> values = new ArrayList<SimpleSignInMethod>();
        None = new SimpleSignInMethod(0, "None");
        values.add(None);
        PIN = new SimpleSignInMethod(1, "Any");
        values.add(PIN);
        Bio = new SimpleSignInMethod(2, "Bio");
        values.add(Bio);
        for (SimpleSignInMethod t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new SimpleSignInMethod[values.size()];
        values.toArray(mValues);
    }
}

