/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ResponsePending {
    private static final String TAG = "ResponsePending";
    @Constant(value=0)
    public static final ResponsePending None;
    @Constant(value=1)
    public static final ResponsePending Submission;
    @Constant(value=2)
    public static final ResponsePending Revision;
    @Constant(value=3)
    public static final ResponsePending Pull;
    @Constant(value=4)
    public static final ResponsePending Status;
    @Constant(value=5)
    public static final ResponsePending NoChange;
    private final int value;
    private static Map<Integer, ResponsePending> map;
    private static ResponsePending[] mValues;

    ResponsePending(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ResponsePending get(int value) {
        ResponsePending val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ResponsePending(value);
            map.put(value, val);
            ArrayList<ResponsePending> values = new ArrayList<ResponsePending>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ResponsePending[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ResponsePending[] values() {
        return mValues;
    }

    public String toString() {
        return "ResponsePending(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ResponsePending>();
        ArrayList<ResponsePending> values = new ArrayList<ResponsePending>();
        None = new ResponsePending(0);
        values.add(None);
        Submission = new ResponsePending(1);
        values.add(Submission);
        Revision = new ResponsePending(2);
        values.add(Revision);
        Pull = new ResponsePending(3);
        values.add(Pull);
        Status = new ResponsePending(4);
        values.add(Status);
        NoChange = new ResponsePending(5);
        values.add(NoChange);
        for (ResponsePending t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ResponsePending[values.size()];
        values.toArray(mValues);
    }
}

