/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class PriceType
implements Serializable {
    private static final String TAG = "PriceType";
    @Constant(value=-1)
    public static final PriceType Undefined;
    @Constant(value=0)
    public static final PriceType Market;
    @Constant(value=1)
    public static final PriceType Limit;
    @Constant(value=2)
    public static final PriceType StopMarket;
    @Constant(value=3)
    public static final PriceType StopLimit;
    @Constant(value=4)
    public static final PriceType OvernightPosition;
    @Constant(value=5)
    public static final PriceType Pit;
    @Constant(value=6)
    public static final PriceType MarketIfTouched;
    @Constant(value=7)
    public static final PriceType StopSameLimit;
    @Constant(value=8)
    public static final PriceType Join;
    @Constant(value=9)
    public static final PriceType Hit;
    @Constant(value=10)
    public static final PriceType BackOfficePosition;
    @Constant(value=11)
    public static final PriceType SyntheticMarket;
    @Constant(value=12)
    public static final PriceType SyntheticLimit;
    @Constant(value=13)
    public static final PriceType SyntheticStopMarket;
    @Constant(value=14)
    public static final PriceType SyntheticStopLimit;
    @Constant(value=15)
    public static final PriceType RFQ;
    @Constant(value=16)
    public static final PriceType Flatten;
    @Constant(value=17)
    public static final PriceType Import;
    @Constant(value=18)
    public static final PriceType OptionsSettlement;
    private final int value;
    private final String name;
    private final String descr_loc;
    private static Map<Integer, PriceType> map;
    private static Map<String, PriceType> names;
    private static PriceType[] mValues;

    private PriceType(int value, String name, String descr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static PriceType get(int value) {
        PriceType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new PriceType(value, Integer.toString(value), null);
            map.put(value, val);
            ArrayList<PriceType> values = new ArrayList<PriceType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new PriceType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static PriceType valueOf(String name) {
        return names.get(name);
    }

    public PriceType[] values() {
        return mValues;
    }

    public boolean isLimit() {
        return this.value == PriceType.Limit.value || this.value == PriceType.MarketIfTouched.value;
    }

    public boolean isStop() {
        return this.value == PriceType.StopLimit.value || this.value == PriceType.StopMarket.value || this.value == PriceType.StopSameLimit.value;
    }

    public String toString() {
        return "PriceType(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof PriceType && this.value == ((PriceType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, PriceType>();
        names = new HashMap<String, PriceType>();
        ArrayList<PriceType> values = new ArrayList<PriceType>();
        Undefined = new PriceType(-1, "Undefined", "pricetype_undefined");
        values.add(Undefined);
        Market = new PriceType(0, "Market", "pricetype_market");
        values.add(Market);
        Limit = new PriceType(1, "Limit", "pricetype_limit");
        values.add(Limit);
        StopMarket = new PriceType(2, "StopMarket", "pricetype_stopmarket");
        values.add(StopMarket);
        StopLimit = new PriceType(3, "StopLimit", "pricetype_stoplimit");
        values.add(StopLimit);
        OvernightPosition = new PriceType(4, "OvernightPosition", "pricetype_overnightposition");
        values.add(OvernightPosition);
        Pit = new PriceType(5, "Pit", "pricetype_pit");
        values.add(Pit);
        MarketIfTouched = new PriceType(6, "MarketIfTouched", "pricetype_marketiftouched");
        values.add(MarketIfTouched);
        StopSameLimit = new PriceType(7, "StopSameLimit", "pricetype_stopsamelimit");
        values.add(StopSameLimit);
        Join = new PriceType(8, "Join", "pricetype_join");
        values.add(Join);
        Hit = new PriceType(9, "Hit", "pricetype_hit");
        values.add(Hit);
        BackOfficePosition = new PriceType(10, "BackOfficePosition", "pricetype_backofficeposition");
        values.add(BackOfficePosition);
        SyntheticMarket = new PriceType(11, "SyntheticMarket", "pricetype_syntheticmarket");
        values.add(SyntheticMarket);
        SyntheticLimit = new PriceType(12, "SyntheticLimit", "pricetype_syntheticlimit");
        values.add(SyntheticLimit);
        SyntheticStopMarket = new PriceType(13, "SyntheticStopMarket", "pricetype_syntheticstopmarket");
        values.add(SyntheticStopMarket);
        SyntheticStopLimit = new PriceType(14, "SyntheticStopLimit", "pricetype_syntheticstoplimit");
        values.add(SyntheticStopLimit);
        RFQ = new PriceType(15, "RFQ", "pricetype_rfq");
        values.add(RFQ);
        Flatten = new PriceType(16, "Flatten", "pricetype_flatten");
        values.add(Flatten);
        Import = new PriceType(17, "Import", "pricetype_import");
        values.add(Import);
        OptionsSettlement = new PriceType(18, "OptionsSettlement", "pricetype_options_settlement");
        values.add(OptionsSettlement);
        for (PriceType t : values) {
            map.put(t.getValue(), t);
            names.put(t.name(), t);
        }
        mValues = new PriceType[values.size()];
        values.toArray(mValues);
    }
}

