/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class PasswordResetResult {
    private static final String TAG = "PasswordResetResult";
    @Constant(value=0)
    public static final PasswordResetResult TokenSuccess;
    @Constant(value=1)
    public static final PasswordResetResult TokenIncorrect;
    @Constant(value=2)
    public static final PasswordResetResult TokenExpired;
    @Constant(value=3)
    public static final PasswordResetResult TokenFailedAttempts;
    @Constant(value=4)
    public static final PasswordResetResult TokenFailedOther;
    @Constant(value=10)
    public static final PasswordResetResult PasswordChanged;
    @Constant(value=11)
    public static final PasswordResetResult PasswordInvalid;
    @Constant(value=12)
    public static final PasswordResetResult PasswordAlreadyUsed;
    @Constant(value=13)
    public static final PasswordResetResult PasswordChangeFailedOther;
    private final int value;
    private final String name;
    private static final Map<Integer, PasswordResetResult> map;
    private static final Map<String, PasswordResetResult> nameMap;
    private static PasswordResetResult[] mValues;

    private PasswordResetResult(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static PasswordResetResult get(int value) {
        PasswordResetResult val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new PasswordResetResult(value, "?" + value);
            map.put(value, val);
            ArrayList<PasswordResetResult> values = new ArrayList<PasswordResetResult>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new PasswordResetResult[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static PasswordResetResult fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, PasswordResetResult>();
        nameMap = new HashMap<String, PasswordResetResult>();
        ArrayList<PasswordResetResult> values = new ArrayList<PasswordResetResult>();
        TokenSuccess = new PasswordResetResult(0, "TokenSuccess");
        values.add(TokenSuccess);
        TokenIncorrect = new PasswordResetResult(1, "TokenIncorrect");
        values.add(TokenIncorrect);
        TokenExpired = new PasswordResetResult(2, "TokenExpired");
        values.add(TokenExpired);
        TokenFailedAttempts = new PasswordResetResult(3, "TokenFailedAttempts");
        values.add(TokenFailedAttempts);
        TokenFailedOther = new PasswordResetResult(4, "TokenFailedOther");
        values.add(TokenFailedOther);
        PasswordChanged = new PasswordResetResult(10, "PasswordChanged");
        values.add(PasswordChanged);
        PasswordInvalid = new PasswordResetResult(11, "PasswordInvalid");
        values.add(PasswordInvalid);
        PasswordAlreadyUsed = new PasswordResetResult(12, "PasswordAlreadyUsed");
        values.add(PasswordAlreadyUsed);
        PasswordChangeFailedOther = new PasswordResetResult(13, "PasswordChangeFailedOther");
        values.add(PasswordChangeFailedOther);
        for (PasswordResetResult t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new PasswordResetResult[values.size()];
        values.toArray(mValues);
    }
}

