/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class Origin {
    private static final String TAG = "Origin";
    @Constant(value=0)
    public static final Origin Undefined;
    @Constant(value=1)
    public static final Origin Customer;
    @Constant(value=2)
    public static final Origin NonCustomer;
    @Constant(value=3)
    public static final Origin OtherMembers;
    @Constant(value=4)
    public static final Origin FloorBrokers;
    @Constant(value=5)
    public static final Origin PostingNone;
    @Constant(value=6)
    public static final Origin PostingManual;
    @Constant(value=7)
    public static final Origin PostingAutomatic;
    @Constant(value=8)
    public static final Origin PostingGiveUp;
    @Constant(value=9)
    public static final Origin PostingAutoAndActAuthorisation;
    @Constant(value=10)
    public static final Origin PostingManualAndActAuthorisation;
    @Constant(value=11)
    public static final Origin Principal;
    @Constant(value=12)
    public static final Origin MarketMaker;
    private final int value;
    private final String descr_loc;
    private static Map<Integer, Origin> map;
    private static Origin[] mValues;

    Origin(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static Origin get(int value) {
        Origin val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new Origin(value, null);
            map.put(value, val);
            ArrayList<Origin> values = new ArrayList<Origin>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new Origin[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public Origin[] values() {
        return mValues;
    }

    public String toString() {
        return "Origin(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, Origin>();
        ArrayList<Origin> values = new ArrayList<Origin>();
        Undefined = new Origin(0, "origin_undefined");
        values.add(Undefined);
        Customer = new Origin(1, "origin_customer");
        values.add(Customer);
        NonCustomer = new Origin(2, "origin_noncustomer");
        values.add(NonCustomer);
        OtherMembers = new Origin(3, "origin_othermembers");
        values.add(OtherMembers);
        FloorBrokers = new Origin(4, "origin_floorbrokers");
        values.add(FloorBrokers);
        PostingNone = new Origin(5, "origin_postingnone");
        values.add(PostingNone);
        PostingManual = new Origin(6, "origin_postingmanual");
        values.add(PostingManual);
        PostingAutomatic = new Origin(7, "origin_postingautomatic");
        values.add(PostingAutomatic);
        PostingGiveUp = new Origin(8, "origin_postinggiveup");
        values.add(PostingGiveUp);
        PostingAutoAndActAuthorisation = new Origin(9, "origin_postingautoandactauthorisation");
        values.add(PostingAutoAndActAuthorisation);
        PostingManualAndActAuthorisation = new Origin(10, "origin_postingmanualandactauthorisation");
        values.add(PostingManualAndActAuthorisation);
        Principal = new Origin(11, "origin_principal");
        values.add(Principal);
        MarketMaker = new Origin(12, "origin_marketmaker");
        values.add(MarketMaker);
        for (Origin t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new Origin[values.size()];
        values.toArray(mValues);
    }
}

