/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AsEnum
public class OrderType {
    private static final String TAG = "OrderType";
    @Constant(value=0)
    public static final OrderType None;
    @Constant(value=1)
    public static final OrderType Market;
    @Constant(value=2)
    public static final OrderType Limit;
    @Constant(value=4)
    public static final OrderType StopMarket;
    @Constant(value=8)
    public static final OrderType StopLimit;
    @Constant(value=16)
    public static final OrderType MarketOnOpen;
    @Constant(value=32)
    public static final OrderType ImmediateAndCancel;
    @Constant(value=64)
    public static final OrderType CompleteVolume;
    @Constant(value=128)
    public static final OrderType StatusRequest;
    @Constant(value=256)
    public static final OrderType StopSameLimit;
    @Constant(value=512)
    public static final OrderType GoodTillCancelled;
    @Constant(value=1024)
    public static final OrderType MarketOnClose;
    @Constant(value=2048)
    public static final OrderType MarketModeReliable;
    @Constant(value=4096)
    public static final OrderType ImpliedMatching;
    @Constant(value=8192)
    public static final OrderType MaxShow;
    @Constant(value=16384)
    public static final OrderType NoQuotes;
    @Constant(value=32768)
    public static final OrderType NoStrategyLegFills;
    @Constant(value=65536)
    public static final OrderType NoDayOrders;
    @Constant(value=131072)
    public static final OrderType RFQ;
    @Constant(value=262144)
    public static final OrderType NotReducible;
    @Constant(value=524288)
    public static final OrderType MarketPreClosed;
    private final int value;
    private static Map<Integer, OrderType> map;
    private static OrderType[] mValues;

    OrderType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static OrderType get(int value) {
        OrderType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new OrderType(value);
            map.put(value, val);
            ArrayList<OrderType> values = new ArrayList<OrderType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OrderType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public OrderType[] values() {
        return mValues;
    }

    public static Set<OrderType> fromFlags(int flags) {
        HashSet<OrderType> mktTypes = new HashSet<OrderType>();
        for (OrderType flag : mValues) {
            if ((flags & flag.getValue()) != flag.getValue()) continue;
            mktTypes.add(flag);
        }
        return mktTypes;
    }

    public static int toFlags(Set<OrderType> set) {
        int flags = 0;
        for (OrderType typ : set) {
            flags |= typ.getValue();
        }
        return flags;
    }

    static {
        map = new HashMap<Integer, OrderType>();
        ArrayList<OrderType> values = new ArrayList<OrderType>();
        None = new OrderType(0);
        values.add(None);
        Market = new OrderType(1);
        values.add(Market);
        Limit = new OrderType(2);
        values.add(Limit);
        StopMarket = new OrderType(4);
        values.add(StopMarket);
        StopLimit = new OrderType(8);
        values.add(StopLimit);
        MarketOnOpen = new OrderType(16);
        values.add(MarketOnOpen);
        ImmediateAndCancel = new OrderType(32);
        values.add(ImmediateAndCancel);
        CompleteVolume = new OrderType(64);
        values.add(CompleteVolume);
        StatusRequest = new OrderType(128);
        values.add(StatusRequest);
        StopSameLimit = new OrderType(256);
        values.add(StopSameLimit);
        GoodTillCancelled = new OrderType(512);
        values.add(GoodTillCancelled);
        MarketOnClose = new OrderType(1024);
        values.add(MarketOnClose);
        MarketModeReliable = new OrderType(2048);
        values.add(MarketModeReliable);
        ImpliedMatching = new OrderType(4096);
        values.add(ImpliedMatching);
        MaxShow = new OrderType(8192);
        values.add(MaxShow);
        NoQuotes = new OrderType(16384);
        values.add(NoQuotes);
        NoStrategyLegFills = new OrderType(32768);
        values.add(NoStrategyLegFills);
        NoDayOrders = new OrderType(65536);
        values.add(NoDayOrders);
        RFQ = new OrderType(131072);
        values.add(RFQ);
        NotReducible = new OrderType(262144);
        values.add(NotReducible);
        MarketPreClosed = new OrderType(524288);
        values.add(MarketPreClosed);
        for (OrderType val : values) {
            map.put(val.getValue(), val);
        }
        mValues = new OrderType[values.size()];
        values.toArray(mValues);
    }
}

