/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class OrderStatus {
    private static final String TAG = "OrderStatus";
    @Constant(value=0)
    public static final OrderStatus None;
    @Constant(value=1)
    public static final OrderStatus Working;
    @Constant(value=2)
    public static final OrderStatus Finished;
    @Constant(value=3)
    public static final OrderStatus Rejected;
    @Constant(value=4)
    public static final OrderStatus Held;
    @Constant(value=5)
    public static final OrderStatus NoChange;
    private final int value;
    private final String name;
    private final String descr_loc;
    private static Map<Integer, OrderStatus> map;
    private static OrderStatus[] mValues;

    OrderStatus(int value, String name, String descr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static OrderStatus get(int value) {
        OrderStatus val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new OrderStatus(value, Integer.toString(value), null);
            map.put(value, val);
            ArrayList<OrderStatus> values = new ArrayList<OrderStatus>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OrderStatus[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public OrderStatus[] values() {
        return mValues;
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, OrderStatus>();
        ArrayList<OrderStatus> values = new ArrayList<OrderStatus>();
        None = new OrderStatus(0, "None", "orderstatus_none");
        values.add(None);
        Working = new OrderStatus(1, "Working", "orderstatus_working");
        values.add(Working);
        Finished = new OrderStatus(2, "Finished", "orderstatus_finished");
        values.add(Finished);
        Rejected = new OrderStatus(3, "Rejected", "orderstatus_rejected");
        values.add(Rejected);
        Held = new OrderStatus(4, "Held", "orderstatus_held");
        values.add(Held);
        NoChange = new OrderStatus(5, "NoChange", "orderstatus_nochange");
        values.add(NoChange);
        for (OrderStatus t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new OrderStatus[values.size()];
        values.toArray(mValues);
    }
}

