/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class OrderSourceMethod
implements Serializable {
    private static final String TAG = "OrderSourceMethod";
    @Constant(value=0)
    public static final OrderSourceMethod Unknown;
    @Constant(value=1)
    public static final OrderSourceMethod Click;
    @Constant(value=2)
    public static final OrderSourceMethod Prompt;
    @Constant(value=3)
    public static final OrderSourceMethod PriceConfirm;
    @Constant(value=4)
    public static final OrderSourceMethod OrderTicket;
    @Constant(value=5)
    public static final OrderSourceMethod KeyEntry;
    @Constant(value=6)
    public static final OrderSourceMethod OrderLoadBar;
    @Constant(value=7)
    public static final OrderSourceMethod ContractTicket;
    @Constant(value=8)
    public static final OrderSourceMethod QueuedOrderTicket;
    @Constant(value=9)
    public static final OrderSourceMethod ClearingHouse;
    @Constant(value=10)
    public static final OrderSourceMethod Electronic;
    @Constant(value=11)
    public static final OrderSourceMethod OffFacilitySwap;
    @Constant(value=12)
    public static final OrderSourceMethod Pit;
    @Constant(value=13)
    public static final OrderSourceMethod RegisteredMarket;
    @Constant(value=14)
    public static final OrderSourceMethod ExPit;
    private final int value;
    private static Map<Integer, OrderSourceMethod> map;
    private static OrderSourceMethod[] mValues;

    private OrderSourceMethod(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static OrderSourceMethod get(int value) {
        OrderSourceMethod val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new OrderSourceMethod(value);
            map.put(value, val);
            ArrayList<OrderSourceMethod> values = new ArrayList<OrderSourceMethod>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OrderSourceMethod[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public OrderSourceMethod[] values() {
        return mValues;
    }

    public String toString() {
        return "OrderSourceMethod(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof OrderSourceMethod && this.value == ((OrderSourceMethod)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, OrderSourceMethod>();
        ArrayList<OrderSourceMethod> values = new ArrayList<OrderSourceMethod>();
        Unknown = new OrderSourceMethod(0);
        values.add(Unknown);
        Click = new OrderSourceMethod(1);
        values.add(Click);
        Prompt = new OrderSourceMethod(2);
        values.add(Prompt);
        PriceConfirm = new OrderSourceMethod(3);
        values.add(PriceConfirm);
        OrderTicket = new OrderSourceMethod(4);
        values.add(OrderTicket);
        KeyEntry = new OrderSourceMethod(5);
        values.add(KeyEntry);
        OrderLoadBar = new OrderSourceMethod(6);
        values.add(OrderLoadBar);
        ContractTicket = new OrderSourceMethod(7);
        values.add(ContractTicket);
        QueuedOrderTicket = new OrderSourceMethod(8);
        values.add(QueuedOrderTicket);
        ClearingHouse = new OrderSourceMethod(9);
        values.add(ClearingHouse);
        Electronic = new OrderSourceMethod(10);
        values.add(Electronic);
        OffFacilitySwap = new OrderSourceMethod(11);
        values.add(OffFacilitySwap);
        Pit = new OrderSourceMethod(12);
        values.add(Pit);
        RegisteredMarket = new OrderSourceMethod(13);
        values.add(RegisteredMarket);
        ExPit = new OrderSourceMethod(14);
        values.add(ExPit);
        for (OrderSourceMethod t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new OrderSourceMethod[values.size()];
        values.toArray(mValues);
    }
}

