/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class OrderSource
implements Serializable {
    private static final String TAG = "OrderSource";
    @Constant(value=0)
    public static final OrderSource Unknown;
    @Constant(value=1)
    public static final OrderSource API;
    @Constant(value=2)
    public static final OrderSource WebTrader;
    @Constant(value=3)
    public static final OrderSource Mobile;
    @Constant(value=4)
    public static final OrderSource DataImport;
    @Constant(value=5)
    public static final OrderSource AccountHandler;
    @Constant(value=20)
    public static final OrderSource StaticLadder;
    @Constant(value=21)
    public static final OrderSource ScrollingLadder;
    @Constant(value=22)
    public static final OrderSource CenteredLadder;
    @Constant(value=23)
    public static final OrderSource AutoRecenteredLadder;
    @Constant(value=24)
    public static final OrderSource Depth;
    @Constant(value=25)
    public static final OrderSource Quoteboard;
    @Constant(value=26)
    public static final OrderSource Optionboard;
    @Constant(value=27)
    public static final OrderSource AdvOptionboard;
    @Constant(value=28)
    public static final OrderSource Orderbook;
    @Constant(value=29)
    public static final OrderSource SpreadMatrix;
    @Constant(value=30)
    public static final OrderSource FIXAPI;
    @Constant(value=31)
    public static final OrderSource ClientSpreader;
    @Constant(value=32)
    public static final OrderSource ANTSOptionSheet;
    @Constant(value=33)
    public static final OrderSource ANTSOptionStrategySolver;
    @Constant(value=34)
    public static final OrderSource JavaAPI;
    @Constant(value=35)
    public static final OrderSource ANTSOptionStrategiesWindow;
    @Constant(value=36)
    public static final OrderSource Chart;
    @Constant(value=37)
    public static final OrderSource STP;
    @Constant(value=38)
    public static final OrderSource T4AndroidScrollingLadder;
    @Constant(value=39)
    public static final OrderSource T4AndroidCenteredLadder;
    @Constant(value=40)
    public static final OrderSource T4AndroidAutoRecenteredLadder;
    @Constant(value=41)
    public static final OrderSource T4AndroidDepth;
    @Constant(value=42)
    public static final OrderSource T4AndroidQuoteboard;
    @Constant(value=43)
    public static final OrderSource T4AndroidPositions;
    @Constant(value=44)
    public static final OrderSource T4AndroidOrders;
    @Constant(value=45)
    public static final OrderSource T4AndroidChart;
    @Constant(value=46)
    public static final OrderSource MQ;
    @Constant(value=47)
    public static final OrderSource iOSAPI;
    @Constant(value=48)
    public static final OrderSource T4iOSScrollingLadder;
    @Constant(value=49)
    public static final OrderSource T4iOSCenteredLadder;
    @Constant(value=50)
    public static final OrderSource T4iOSAutoRecenteredLadder;
    @Constant(value=51)
    public static final OrderSource T4iOSDepth;
    @Constant(value=52)
    public static final OrderSource T4iOSQuoteboard;
    @Constant(value=53)
    public static final OrderSource T4iOSPositions;
    @Constant(value=54)
    public static final OrderSource T4iOSOrders;
    @Constant(value=55)
    public static final OrderSource T4iOSChart;
    @Constant(value=56)
    public static final OrderSource Keyboard;
    private final int value;
    private static Map<Integer, OrderSource> map;
    private static OrderSource[] mValues;

    private OrderSource(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static OrderSource get(int value) {
        OrderSource val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new OrderSource(value);
            map.put(value, val);
            ArrayList<OrderSource> values = new ArrayList<OrderSource>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OrderSource[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public OrderSource[] values() {
        return mValues;
    }

    public String toString() {
        return "OrderSource(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof OrderSource && this.value == ((OrderSource)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, OrderSource>();
        ArrayList<OrderSource> values = new ArrayList<OrderSource>();
        Unknown = new OrderSource(0);
        values.add(Unknown);
        API = new OrderSource(1);
        values.add(API);
        WebTrader = new OrderSource(2);
        values.add(WebTrader);
        Mobile = new OrderSource(3);
        values.add(Mobile);
        DataImport = new OrderSource(4);
        values.add(DataImport);
        AccountHandler = new OrderSource(5);
        values.add(AccountHandler);
        StaticLadder = new OrderSource(20);
        values.add(StaticLadder);
        ScrollingLadder = new OrderSource(21);
        values.add(ScrollingLadder);
        CenteredLadder = new OrderSource(22);
        values.add(CenteredLadder);
        AutoRecenteredLadder = new OrderSource(23);
        values.add(AutoRecenteredLadder);
        Depth = new OrderSource(24);
        values.add(Depth);
        Quoteboard = new OrderSource(25);
        values.add(Quoteboard);
        Optionboard = new OrderSource(26);
        values.add(Optionboard);
        AdvOptionboard = new OrderSource(27);
        values.add(AdvOptionboard);
        Orderbook = new OrderSource(28);
        values.add(Orderbook);
        SpreadMatrix = new OrderSource(29);
        values.add(SpreadMatrix);
        FIXAPI = new OrderSource(30);
        values.add(FIXAPI);
        ClientSpreader = new OrderSource(31);
        values.add(ClientSpreader);
        ANTSOptionSheet = new OrderSource(32);
        values.add(ANTSOptionSheet);
        ANTSOptionStrategySolver = new OrderSource(33);
        values.add(ANTSOptionStrategySolver);
        JavaAPI = new OrderSource(34);
        values.add(JavaAPI);
        ANTSOptionStrategiesWindow = new OrderSource(35);
        values.add(ANTSOptionStrategiesWindow);
        Chart = new OrderSource(36);
        values.add(Chart);
        STP = new OrderSource(37);
        values.add(STP);
        T4AndroidScrollingLadder = new OrderSource(38);
        values.add(T4AndroidScrollingLadder);
        T4AndroidCenteredLadder = new OrderSource(39);
        values.add(T4AndroidCenteredLadder);
        T4AndroidAutoRecenteredLadder = new OrderSource(40);
        values.add(T4AndroidAutoRecenteredLadder);
        T4AndroidDepth = new OrderSource(41);
        values.add(T4AndroidDepth);
        T4AndroidQuoteboard = new OrderSource(42);
        values.add(T4AndroidQuoteboard);
        T4AndroidPositions = new OrderSource(43);
        values.add(T4AndroidPositions);
        T4AndroidOrders = new OrderSource(44);
        values.add(T4AndroidOrders);
        T4AndroidChart = new OrderSource(45);
        values.add(T4AndroidChart);
        MQ = new OrderSource(46);
        values.add(MQ);
        iOSAPI = new OrderSource(47);
        values.add(iOSAPI);
        T4iOSScrollingLadder = new OrderSource(48);
        values.add(T4iOSScrollingLadder);
        T4iOSCenteredLadder = new OrderSource(49);
        values.add(T4iOSCenteredLadder);
        T4iOSAutoRecenteredLadder = new OrderSource(50);
        values.add(T4iOSAutoRecenteredLadder);
        T4iOSDepth = new OrderSource(51);
        values.add(T4iOSDepth);
        T4iOSQuoteboard = new OrderSource(52);
        values.add(T4iOSQuoteboard);
        T4iOSPositions = new OrderSource(53);
        values.add(T4iOSPositions);
        T4iOSOrders = new OrderSource(54);
        values.add(T4iOSOrders);
        T4iOSChart = new OrderSource(55);
        values.add(T4iOSChart);
        Keyboard = new OrderSource(56);
        values.add(Keyboard);
        for (OrderSource t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new OrderSource[values.size()];
        values.toArray(mValues);
    }
}

