/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class OrderLink
implements Serializable {
    private static final String TAG = "OrderLink";
    @Constant(value=0)
    public static final OrderLink None;
    @Constant(value=1)
    public static final OrderLink OCO;
    @Constant(value=2)
    public static final OrderLink AutoOCO;
    @Constant(value=3)
    public static final OrderLink Spark;
    @Constant(value=4)
    public static final OrderLink ClientSynthetic;
    @Constant(value=5)
    public static final OrderLink Spark2;
    @Constant(value=6)
    public static final OrderLink Chain2;
    @Constant(value=7)
    public static final OrderLink AutoOCOp;
    @Constant(value=8)
    public static final OrderLink AutoOCOm;
    @Constant(value=9)
    public static final OrderLink AutoOCOmp;
    private final int value;
    private final String descr_log;
    private static Map<Integer, OrderLink> map;
    private static OrderLink[] mValues;

    private OrderLink(int value, String descr_log) {
        this.value = value;
        this.descr_log = descr_log;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_log != null) {
            return Resource.localizeString(this.descr_log);
        }
        return Integer.toString(this.value);
    }

    public static OrderLink get(int value) {
        OrderLink val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new OrderLink(value, null);
            map.put(value, val);
            ArrayList<OrderLink> values = new ArrayList<OrderLink>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OrderLink[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public OrderLink[] values() {
        return mValues;
    }

    public String toString() {
        return "OrderLink(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof OrderLink && this.value == ((OrderLink)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, OrderLink>();
        ArrayList<OrderLink> values = new ArrayList<OrderLink>();
        None = new OrderLink(0, "orderlink_none");
        values.add(None);
        OCO = new OrderLink(1, "orderlink_oco");
        values.add(OCO);
        AutoOCO = new OrderLink(2, "orderlink_autooco");
        values.add(AutoOCO);
        Spark = new OrderLink(3, "orderlink_spark");
        values.add(Spark);
        ClientSynthetic = new OrderLink(4, "orderlink_clientsynthetic");
        values.add(ClientSynthetic);
        Spark2 = new OrderLink(5, "orderlink_spark2");
        values.add(Spark2);
        Chain2 = new OrderLink(6, "orderlink_chain2");
        values.add(Chain2);
        AutoOCOp = new OrderLink(7, "orderlink_autoocop");
        values.add(AutoOCOp);
        AutoOCOm = new OrderLink(8, "orderlink_autoocom");
        values.add(AutoOCOm);
        AutoOCOmp = new OrderLink(9, "orderlink_autoocomp");
        values.add(AutoOCOmp);
        for (OrderLink t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new OrderLink[values.size()];
        values.toArray(mValues);
    }
}

