/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class OrderChange {
    private static final String TAG = "OrderChange";
    @Constant(value=0)
    public static final OrderChange None;
    @Constant(value=1)
    public static final OrderChange Failed;
    @Constant(value=2)
    public static final OrderChange SubmissionRiskSuccess;
    @Constant(value=3)
    public static final OrderChange SubmissionRiskRejected;
    @Constant(value=4)
    public static final OrderChange SubmissionSent;
    @Constant(value=5)
    public static final OrderChange SubmissionFailed;
    @Constant(value=6)
    public static final OrderChange SubmissionSuccess;
    @Constant(value=7)
    public static final OrderChange SubmissionRejected;
    @Constant(value=8)
    public static final OrderChange RevisionRiskSuccess;
    @Constant(value=9)
    public static final OrderChange RevisionRiskFailed;
    @Constant(value=10)
    public static final OrderChange RevisionSent;
    @Constant(value=11)
    public static final OrderChange RevisionFailed;
    @Constant(value=12)
    public static final OrderChange RevisionSuccess;
    @Constant(value=13)
    public static final OrderChange RevisionRejected;
    @Constant(value=14)
    public static final OrderChange PullRiskSuccess;
    @Constant(value=15)
    public static final OrderChange PullRiskFailed;
    @Constant(value=16)
    public static final OrderChange PullSent;
    @Constant(value=17)
    public static final OrderChange PullFailed;
    @Constant(value=18)
    public static final OrderChange PullSuccess;
    @Constant(value=19)
    public static final OrderChange PullRejected;
    @Constant(value=20)
    public static final OrderChange Trade;
    @Constant(value=21)
    public static final OrderChange TradeCompleted;
    @Constant(value=22)
    public static final OrderChange TradeBusted;
    @Constant(value=23)
    public static final OrderChange Handover;
    @Constant(value=24)
    public static final OrderChange StatusRequestRiskSuccess;
    @Constant(value=25)
    public static final OrderChange StatusRequestRiskFailed;
    @Constant(value=26)
    public static final OrderChange StatusRequestSent;
    @Constant(value=27)
    public static final OrderChange StatusRequestFailed;
    @Constant(value=28)
    public static final OrderChange StatusRequestSuccess;
    @Constant(value=29)
    public static final OrderChange StatusRequestRejected;
    @Constant(value=30)
    public static final OrderChange Rollover;
    @Constant(value=31)
    public static final OrderChange TagSuccess;
    @Constant(value=32)
    public static final OrderChange TagFailed;
    @Constant(value=33)
    public static final OrderChange AddPitTradeSuccess;
    @Constant(value=34)
    public static final OrderChange AddPitTradeFailed;
    @Constant(value=35)
    public static final OrderChange AddPitTradeRejected;
    private final int value;
    private final String name;
    private final String descr_loc;
    private final Boolean is_success;
    private static Map<Integer, OrderChange> map;
    private static OrderChange[] mValues;

    OrderChange(int value, String name, String descr_loc, Boolean isSuccess) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
        this.is_success = isSuccess;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public Boolean getIsSuccessChange() {
        return this.is_success;
    }

    public static OrderChange get(int value) {
        OrderChange val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new OrderChange(value, Integer.toString(value), null, false);
            map.put(value, val);
            ArrayList<OrderChange> values = new ArrayList<OrderChange>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OrderChange[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public OrderChange[] values() {
        return mValues;
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, OrderChange>();
        ArrayList<OrderChange> values = new ArrayList<OrderChange>();
        None = new OrderChange(0, "None", "orderchange_none", true);
        values.add(None);
        Failed = new OrderChange(1, "Failed", "orderchange_failed", false);
        values.add(Failed);
        SubmissionRiskSuccess = new OrderChange(2, "SubmissionRiskSuccess", "orderchange_submissionrisksuccess", true);
        values.add(SubmissionRiskSuccess);
        SubmissionRiskRejected = new OrderChange(3, "SubmissionRiskRejected", "orderchange_submissionriskrejected", false);
        values.add(SubmissionRiskRejected);
        SubmissionSent = new OrderChange(4, "SubmissionSent", "orderchange_submissionsent", true);
        values.add(SubmissionSent);
        SubmissionFailed = new OrderChange(5, "SubmissionFailed", "orderchange_submissionfailed", false);
        values.add(SubmissionFailed);
        SubmissionSuccess = new OrderChange(6, "SubmissionSuccess", "orderchange_submissionsuccess", true);
        values.add(SubmissionSuccess);
        SubmissionRejected = new OrderChange(7, "SubmissionRejected", "orderchange_submissionrejected", false);
        values.add(SubmissionRejected);
        RevisionRiskSuccess = new OrderChange(8, "RevisionRiskSuccess", "orderchange_revisionrisksuccess", true);
        values.add(RevisionRiskSuccess);
        RevisionRiskFailed = new OrderChange(9, "RevisionRiskFailed", "orderchange_revisionriskfailed", false);
        values.add(RevisionRiskFailed);
        RevisionSent = new OrderChange(10, "RevisionSent", "orderchange_revisionsent", true);
        values.add(RevisionSent);
        RevisionFailed = new OrderChange(11, "RevisionFailed", "orderchange_revisionfailed", false);
        values.add(RevisionFailed);
        RevisionSuccess = new OrderChange(12, "RevisionSuccess", "orderchange_revisionsuccess", true);
        values.add(RevisionSuccess);
        RevisionRejected = new OrderChange(13, "RevisionRejected", "orderchange_revisionrejected", false);
        values.add(RevisionRejected);
        PullRiskSuccess = new OrderChange(14, "PullRiskSuccess", "orderchange_pullrisksuccess", true);
        values.add(PullRiskSuccess);
        PullRiskFailed = new OrderChange(15, "PullRiskFailed", "orderchange_pullriskfailed", false);
        values.add(PullRiskFailed);
        PullSent = new OrderChange(16, "PullSent", "orderchange_pullsent", true);
        values.add(PullSent);
        PullFailed = new OrderChange(17, "PullFailed", "orderchange_pullfailed", false);
        values.add(PullFailed);
        PullSuccess = new OrderChange(18, "PullSuccess", "orderchange_pullsuccess", true);
        values.add(PullSuccess);
        PullRejected = new OrderChange(19, "PullRejected", "orderchange_pullrejected", false);
        values.add(PullRejected);
        Trade = new OrderChange(20, "Trade", "orderchange_trade", true);
        values.add(Trade);
        TradeCompleted = new OrderChange(21, "TradeCompleted", "orderchange_tradecompleted", true);
        values.add(TradeCompleted);
        TradeBusted = new OrderChange(22, "TradeBusted", "orderchange_tradebusted", false);
        values.add(TradeBusted);
        Handover = new OrderChange(23, "Handover", "orderchange_handover", true);
        values.add(Handover);
        StatusRequestRiskSuccess = new OrderChange(24, "StatusRequestRiskSuccess", "orderchange_statusrequestrisksuccess", true);
        values.add(StatusRequestRiskSuccess);
        StatusRequestRiskFailed = new OrderChange(25, "StatusRequestRiskFailed", "orderchange_statusrequestriskfailed", false);
        values.add(StatusRequestRiskFailed);
        StatusRequestSent = new OrderChange(26, "StatusRequestSent", "orderchange_statusrequestsent", true);
        values.add(StatusRequestSent);
        StatusRequestFailed = new OrderChange(27, "StatusRequestFailed", "orderchange_statusrequestfailed", false);
        values.add(StatusRequestFailed);
        StatusRequestSuccess = new OrderChange(28, "StatusRequestSuccess", "orderchange_statusrequestsuccess", true);
        values.add(StatusRequestSuccess);
        StatusRequestRejected = new OrderChange(29, "StatusRequestRejected", "orderchange_statusrequestrejected", false);
        values.add(StatusRequestRejected);
        Rollover = new OrderChange(30, "Rollover", "orderchange_rollover", true);
        values.add(Rollover);
        TagSuccess = new OrderChange(31, "TagSuccess", "orderchange_tagsuccess", true);
        values.add(TagSuccess);
        TagFailed = new OrderChange(32, "TagFailed", "orderchange_tagfailed", false);
        values.add(TagFailed);
        AddPitTradeSuccess = new OrderChange(33, "AddPitTradeSuccess", "orderchange_addpittradesuccess", true);
        values.add(AddPitTradeSuccess);
        AddPitTradeFailed = new OrderChange(34, "AddPitTradeFailed", "orderchange_addpittradefailed", false);
        values.add(AddPitTradeFailed);
        AddPitTradeRejected = new OrderChange(35, "AddPitTradeRejected", "orderchange_addpittraderejected", false);
        values.add(AddPitTradeRejected);
        for (OrderChange t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new OrderChange[values.size()];
        values.toArray(mValues);
    }
}

