/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OptionsSettlementPick {
    private static final String TAG = "OptionsSettlementPick";
    @Constant(value=0)
    public static final OptionsSettlementPick Yes;
    @Constant(value=1)
    public static final OptionsSettlementPick No;
    private final int value;
    private final String name;
    private static final Map<Integer, OptionsSettlementPick> map;
    private static final Map<String, OptionsSettlementPick> nameMap;
    private static OptionsSettlementPick[] mValues;

    private OptionsSettlementPick(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static OptionsSettlementPick get(int value) {
        OptionsSettlementPick val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new OptionsSettlementPick(value, "?" + value);
            map.put(value, val);
            ArrayList<OptionsSettlementPick> values = new ArrayList<OptionsSettlementPick>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OptionsSettlementPick[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static OptionsSettlementPick fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, OptionsSettlementPick>();
        nameMap = new HashMap<String, OptionsSettlementPick>();
        ArrayList<OptionsSettlementPick> values = new ArrayList<OptionsSettlementPick>();
        Yes = new OptionsSettlementPick(0, "Yes");
        values.add(Yes);
        No = new OptionsSettlementPick(1, "No");
        values.add(No);
        for (OptionsSettlementPick t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new OptionsSettlementPick[values.size()];
        values.toArray(mValues);
    }
}

