/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class OnboardingNotificationType {
    private static final String TAG = "OnboardingNotificationType";
    @Constant(value=0)
    public static final OnboardingNotificationType OnboardingPending;
    @Constant(value=1)
    public static final OnboardingNotificationType OnboardingCompleted;
    @Constant(value=2)
    public static final OnboardingNotificationType OnboardingPartial;
    @Constant(value=3)
    public static final OnboardingNotificationType OnboardingRejected;
    private final int value;
    private final String name;
    private static final Map<Integer, OnboardingNotificationType> map;
    private static final Map<String, OnboardingNotificationType> nameMap;
    private static OnboardingNotificationType[] mValues;

    private OnboardingNotificationType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static OnboardingNotificationType get(int value) {
        OnboardingNotificationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new OnboardingNotificationType(value, "?" + value);
            map.put(value, val);
            ArrayList<OnboardingNotificationType> values = new ArrayList<OnboardingNotificationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new OnboardingNotificationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static OnboardingNotificationType fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, OnboardingNotificationType>();
        nameMap = new HashMap<String, OnboardingNotificationType>();
        ArrayList<OnboardingNotificationType> values = new ArrayList<OnboardingNotificationType>();
        OnboardingPending = new OnboardingNotificationType(0, "OnboardingPending");
        values.add(OnboardingPending);
        OnboardingCompleted = new OnboardingNotificationType(1, "OnboardingCompleted");
        values.add(OnboardingCompleted);
        OnboardingPartial = new OnboardingNotificationType(2, "OnboardingPartial");
        values.add(OnboardingPartial);
        OnboardingRejected = new OnboardingNotificationType(3, "OnboardingRejected");
        values.add(OnboardingRejected);
        for (OnboardingNotificationType t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new OnboardingNotificationType[values.size()];
        values.toArray(mValues);
    }
}

