/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class NotificationAckType {
    private static final String TAG = "NotificationAckType";
    @Constant(value=0)
    public static final NotificationAckType Unknown;
    @Constant(value=1)
    public static final NotificationAckType DeviceNotificationDismiss;
    @Constant(value=2)
    public static final NotificationAckType DeviceNotificationTap;
    @Constant(value=3)
    public static final NotificationAckType InAppNotificationOpened;
    @Constant(value=4)
    public static final NotificationAckType SendGridWebhook;
    @Constant(value=5)
    public static final NotificationAckType TwilioWebhook;
    private final int value;
    private static Map<Integer, NotificationAckType> map;
    private static NotificationAckType[] mValues;

    NotificationAckType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static NotificationAckType get(int value) {
        NotificationAckType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new NotificationAckType(value);
            map.put(value, val);
            ArrayList<NotificationAckType> values = new ArrayList<NotificationAckType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new NotificationAckType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public NotificationAckType[] values() {
        return mValues;
    }

    public String toString() {
        return "NotificationAckType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, NotificationAckType>();
        ArrayList<NotificationAckType> values = new ArrayList<NotificationAckType>();
        Unknown = new NotificationAckType(0);
        values.add(Unknown);
        DeviceNotificationDismiss = new NotificationAckType(1);
        values.add(DeviceNotificationDismiss);
        DeviceNotificationTap = new NotificationAckType(2);
        values.add(DeviceNotificationTap);
        InAppNotificationOpened = new NotificationAckType(3);
        values.add(InAppNotificationOpened);
        SendGridWebhook = new NotificationAckType(4);
        values.add(SendGridWebhook);
        TwilioWebhook = new NotificationAckType(5);
        values.add(TwilioWebhook);
        for (NotificationAckType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new NotificationAckType[values.size()];
        values.toArray(mValues);
    }
}

