/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class NotificationAccountMode {
    private static final String TAG = "NotificationAccountMode";
    @Constant(value=0)
    public static final NotificationAccountMode User;
    @Constant(value=1)
    public static final NotificationAccountMode T500Demo;
    @Constant(value=2)
    public static final NotificationAccountMode T500;
    private final int value;
    private final String name;
    private static final Map<Integer, NotificationAccountMode> map;
    private static final Map<String, NotificationAccountMode> nameMap;
    private static NotificationAccountMode[] mValues;

    private NotificationAccountMode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static NotificationAccountMode get(int value) {
        NotificationAccountMode val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new NotificationAccountMode(value, "?" + value);
            map.put(value, val);
            ArrayList<NotificationAccountMode> values = new ArrayList<NotificationAccountMode>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new NotificationAccountMode[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static NotificationAccountMode fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, NotificationAccountMode>();
        nameMap = new HashMap<String, NotificationAccountMode>();
        ArrayList<NotificationAccountMode> values = new ArrayList<NotificationAccountMode>();
        User = new NotificationAccountMode(0, "User");
        values.add(User);
        T500Demo = new NotificationAccountMode(1, "T500Demo");
        values.add(T500Demo);
        T500 = new NotificationAccountMode(2, "T500");
        values.add(T500);
        for (NotificationAccountMode t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new NotificationAccountMode[values.size()];
        values.toArray(mValues);
    }
}

