/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ModelType {
    private static final String TAG = "ModelType";
    @Constant(value=0)
    public static final ModelType Undefined;
    @Constant(value=1)
    public static final ModelType CRRBinomial;
    @Constant(value=2)
    public static final ModelType Black;
    @Constant(value=3)
    public static final ModelType BlackScholes;
    @Constant(value=4)
    public static final ModelType GarmanKohlhagen;
    @Constant(value=5)
    public static final ModelType WhaleyQuadratic;
    @Constant(value=6)
    public static final ModelType BjerksundStensland93;
    @Constant(value=7)
    public static final ModelType EurodollarBlack;
    @Constant(value=8)
    public static final ModelType Bachelier;
    private final int value;
    private static final Map<Integer, ModelType> map;
    private static ModelType[] mValues;

    ModelType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ModelType get(int value) {
        ModelType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ModelType(value);
            map.put(value, val);
            ArrayList<ModelType> values = new ArrayList<ModelType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ModelType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ModelType[] values() {
        return mValues;
    }

    public String toString() {
        return "ModelType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ModelType>();
        ArrayList<ModelType> values = new ArrayList<ModelType>();
        Undefined = new ModelType(0);
        values.add(Undefined);
        CRRBinomial = new ModelType(1);
        values.add(CRRBinomial);
        Black = new ModelType(2);
        values.add(Black);
        BlackScholes = new ModelType(3);
        values.add(BlackScholes);
        GarmanKohlhagen = new ModelType(4);
        values.add(GarmanKohlhagen);
        WhaleyQuadratic = new ModelType(5);
        values.add(WhaleyQuadratic);
        BjerksundStensland93 = new ModelType(6);
        values.add(BjerksundStensland93);
        EurodollarBlack = new ModelType(7);
        values.add(EurodollarBlack);
        Bachelier = new ModelType(8);
        values.add(Bachelier);
        for (ModelType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ModelType[values.size()];
        values.toArray(mValues);
    }
}

