/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ModelRateType {
    private static final String TAG = "ModelRateType";
    @Constant(value=0)
    public static final ModelRateType Undefined;
    @Constant(value=1)
    public static final ModelRateType Continuous;
    @Constant(value=2)
    public static final ModelRateType Period;
    @Constant(value=3)
    public static final ModelRateType Annual;
    @Constant(value=4)
    public static final ModelRateType SemiAnnual;
    @Constant(value=5)
    public static final ModelRateType Quarterly;
    @Constant(value=6)
    public static final ModelRateType Monthly;
    private final int value;
    private static final Map<Integer, ModelRateType> map;
    private static ModelRateType[] mValues;

    ModelRateType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ModelRateType get(int value) {
        ModelRateType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ModelRateType(value);
            map.put(value, val);
            ArrayList<ModelRateType> values = new ArrayList<ModelRateType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ModelRateType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ModelRateType[] values() {
        return mValues;
    }

    public String toString() {
        return "ModelRateType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ModelRateType>();
        ArrayList<ModelRateType> values = new ArrayList<ModelRateType>();
        Undefined = new ModelRateType(0);
        values.add(Undefined);
        Continuous = new ModelRateType(1);
        values.add(Continuous);
        Period = new ModelRateType(2);
        values.add(Period);
        Annual = new ModelRateType(3);
        values.add(Annual);
        SemiAnnual = new ModelRateType(4);
        values.add(SemiAnnual);
        Quarterly = new ModelRateType(5);
        values.add(Quarterly);
        Monthly = new ModelRateType(6);
        values.add(Monthly);
        for (ModelRateType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ModelRateType[values.size()];
        values.toArray(mValues);
    }
}

