/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AsEnum
public class MarketFlags2 {
    private static final String TAG = "MarketFlags2";
    @Constant(value=0)
    public static final MarketFlags2 Undefined;
    @Constant(value=1)
    public static final MarketFlags2 Fast;
    @Constant(value=2)
    public static final MarketFlags2 PriceLimitsEnabled;
    @Constant(value=4)
    public static final MarketFlags2 NoCancel;
    @Constant(value=8)
    public static final MarketFlags2 ImpliedOff;
    @Constant(value=16)
    public static final MarketFlags2 NewPriceIndication;
    @Constant(value=32)
    public static final MarketFlags2 NotAvailableForTrading;
    @Constant(value=64)
    public static final MarketFlags2 PostClose;
    @Constant(value=128)
    public static final MarketFlags2 GroupSchedule;
    @Constant(value=256)
    public static final MarketFlags2 InstrumentActivation;
    @Constant(value=512)
    public static final MarketFlags2 InstrumentExpiration;
    @Constant(value=1024)
    public static final MarketFlags2 MarketEvent;
    @Constant(value=2048)
    public static final MarketFlags2 RecoveryInProcess;
    @Constant(value=4096)
    public static final MarketFlags2 SurveillanceIntervention;
    private final int value;
    private static Map<Integer, MarketFlags2> map;
    private static MarketFlags2[] mValues;

    MarketFlags2(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MarketFlags2 get(int value) {
        MarketFlags2 val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new MarketFlags2(value);
            map.put(value, val);
            ArrayList<MarketFlags2> values = new ArrayList<MarketFlags2>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new MarketFlags2[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public MarketFlags2[] values() {
        return mValues;
    }

    public String toString() {
        return "MarketFlags2(" + this.getValue() + ")";
    }

    public static Set<MarketFlags2> fromFlags(int flags) {
        HashSet<MarketFlags2> mktTypes = new HashSet<MarketFlags2>();
        for (MarketFlags2 flag : mValues) {
            if ((flags & flag.getValue()) != flag.getValue()) continue;
            mktTypes.add(flag);
        }
        return mktTypes;
    }

    public static int toFlags(Set<MarketFlags2> set) {
        int flags = 0;
        for (MarketFlags2 typ : set) {
            flags |= typ.getValue();
        }
        return flags;
    }

    static {
        map = new HashMap<Integer, MarketFlags2>();
        ArrayList<MarketFlags2> values = new ArrayList<MarketFlags2>();
        Undefined = new MarketFlags2(0);
        values.add(Undefined);
        Fast = new MarketFlags2(1);
        values.add(Fast);
        PriceLimitsEnabled = new MarketFlags2(2);
        values.add(PriceLimitsEnabled);
        NoCancel = new MarketFlags2(4);
        values.add(NoCancel);
        ImpliedOff = new MarketFlags2(8);
        values.add(ImpliedOff);
        NewPriceIndication = new MarketFlags2(16);
        values.add(NewPriceIndication);
        NotAvailableForTrading = new MarketFlags2(32);
        values.add(NotAvailableForTrading);
        PostClose = new MarketFlags2(64);
        values.add(PostClose);
        GroupSchedule = new MarketFlags2(128);
        values.add(GroupSchedule);
        InstrumentActivation = new MarketFlags2(256);
        values.add(InstrumentActivation);
        InstrumentExpiration = new MarketFlags2(512);
        values.add(InstrumentExpiration);
        MarketEvent = new MarketFlags2(1024);
        values.add(MarketEvent);
        RecoveryInProcess = new MarketFlags2(2048);
        values.add(RecoveryInProcess);
        SurveillanceIntervention = new MarketFlags2(4096);
        values.add(SurveillanceIntervention);
        for (MarketFlags2 val : values) {
            map.put(val.getValue(), val);
        }
        mValues = new MarketFlags2[values.size()];
        values.toArray(mValues);
    }
}

