/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AsEnum
public class MarketDataType
implements Serializable {
    private static final String TAG = "MarketDataType";
    @Constant(value=-1)
    public static final MarketDataType NotSet;
    @Constant(value=0)
    public static final MarketDataType None;
    @Constant(value=1)
    public static final MarketDataType TOB;
    @Constant(value=2)
    public static final MarketDataType Depth;
    @Constant(value=4)
    public static final MarketDataType EMini;
    @Constant(value=8)
    public static final MarketDataType Delayed;
    private final int value;
    private static Map<Integer, MarketDataType> map;
    private static MarketDataType[] mValues;

    private MarketDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MarketDataType get(int value) {
        MarketDataType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new MarketDataType(value);
            map.put(value, val);
            ArrayList<MarketDataType> values = new ArrayList<MarketDataType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new MarketDataType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public MarketDataType[] values() {
        return mValues;
    }

    public String toString() {
        return "MarketDataType(" + this.getValue() + ")";
    }

    public static Set<MarketDataType> fromFlags(int flags) {
        HashSet<MarketDataType> mktTypes = new HashSet<MarketDataType>();
        for (MarketDataType flag : mValues) {
            if ((flags & flag.getValue()) != flag.getValue()) continue;
            mktTypes.add(flag);
        }
        return mktTypes;
    }

    public static int toFlags(Set<MarketDataType> set) {
        int flags = 0;
        for (MarketDataType typ : set) {
            flags |= typ.getValue();
        }
        return flags;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof MarketDataType && this.value == ((MarketDataType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, MarketDataType>();
        ArrayList<MarketDataType> values = new ArrayList<MarketDataType>();
        NotSet = new MarketDataType(-1);
        values.add(NotSet);
        None = new MarketDataType(0);
        values.add(None);
        TOB = new MarketDataType(1);
        values.add(TOB);
        Depth = new MarketDataType(2);
        values.add(Depth);
        EMini = new MarketDataType(4);
        values.add(EMini);
        Delayed = new MarketDataType(8);
        values.add(Delayed);
        for (MarketDataType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new MarketDataType[values.size()];
        values.toArray(mValues);
    }
}

