/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class MarginWarningNotificationType {
    private static final String TAG = "MarginWarningNotificationType";
    @Constant(value=0)
    public static final MarginWarningNotificationType DayMaringWarning;
    @Constant(value=1)
    public static final MarginWarningNotificationType FullMarginWarning;
    @Constant(value=2)
    public static final MarginWarningNotificationType ExpiryWarning;
    private final int value;
    private final String name;
    private static final Map<Integer, MarginWarningNotificationType> map;
    private static final Map<String, MarginWarningNotificationType> nameMap;
    private static MarginWarningNotificationType[] mValues;

    private MarginWarningNotificationType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static MarginWarningNotificationType get(int value) {
        MarginWarningNotificationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new MarginWarningNotificationType(value, "?" + value);
            map.put(value, val);
            ArrayList<MarginWarningNotificationType> values = new ArrayList<MarginWarningNotificationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new MarginWarningNotificationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static MarginWarningNotificationType fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, MarginWarningNotificationType>();
        nameMap = new HashMap<String, MarginWarningNotificationType>();
        ArrayList<MarginWarningNotificationType> values = new ArrayList<MarginWarningNotificationType>();
        DayMaringWarning = new MarginWarningNotificationType(0, "DayMaringWarning");
        values.add(DayMaringWarning);
        FullMarginWarning = new MarginWarningNotificationType(1, "FullMarginWarning");
        values.add(FullMarginWarning);
        ExpiryWarning = new MarginWarningNotificationType(2, "ExpiryWarning");
        values.add(ExpiryWarning);
        for (MarginWarningNotificationType t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new MarginWarningNotificationType[values.size()];
        values.toArray(mValues);
    }
}

