/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class LoginResult {
    private static final String TAG = "LoginResult";
    @Constant(value=-1)
    public static final LoginResult Unknown;
    @Constant(value=0)
    public static final LoginResult Success;
    @Constant(value=1)
    public static final LoginResult Failed;
    @Constant(value=2)
    public static final LoginResult ApplicationNotValid;
    @Constant(value=3)
    public static final LoginResult FirmNotAllowed;
    @Constant(value=4)
    public static final LoginResult UserNotAllowed;
    @Constant(value=5)
    public static final LoginResult IncorrectVersion;
    @Constant(value=6)
    public static final LoginResult LoggedInElsewhere;
    @Constant(value=7)
    public static final LoginResult Logout;
    @Constant(value=8)
    public static final LoginResult UnexpectedDisconnect;
    @Constant(value=9)
    public static final LoginResult Unauthorized;
    @Constant(value=10)
    public static final LoginResult UnexpectedError;
    @Constant(value=11)
    public static final LoginResult RoleNotSupported;
    @Constant(value=12)
    public static final LoginResult APIMessageBacklog;
    @Constant(value=13)
    public static final LoginResult ServerMessageBacklog;
    @Constant(value=14)
    public static final LoginResult PasswordExpired;
    @Constant(value=16)
    public static final LoginResult PasswordChangeFailed;
    @Constant(value=17)
    public static final LoginResult PasswordAlreadyUsed;
    @Constant(value=18)
    public static final LoginResult LockedOut;
    @Constant(value=19)
    public static final LoginResult AdditionalUsersNotAllowed;
    @Constant(value=20)
    public static final LoginResult MarketDataNotSetup;
    @Constant(value=21)
    public static final LoginResult TwoFactorAuthenticationNotSetup;
    @Constant(value=22)
    public static final LoginResult TwoFactorAuthenticationFailed;
    @Constant(value=23)
    public static final LoginResult FIXSessionError;
    @Constant(value=24)
    public static final LoginResult TwoFactorAuthenticationRequired;
    @Constant(value=25)
    public static final LoginResult UserExists;
    private final int value;
    private final String name;
    private static Map<Integer, LoginResult> map;
    private static LoginResult[] mValues;

    LoginResult(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static LoginResult get(int value) {
        LoginResult val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new LoginResult(value, "?" + Integer.toString(value));
            map.put(value, val);
            ArrayList<LoginResult> values = new ArrayList<LoginResult>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new LoginResult[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, LoginResult>();
        ArrayList<LoginResult> values = new ArrayList<LoginResult>();
        Unknown = new LoginResult(-1, "Unknown");
        values.add(Unknown);
        Success = new LoginResult(0, "Success");
        values.add(Success);
        Failed = new LoginResult(1, "Failed");
        values.add(Failed);
        ApplicationNotValid = new LoginResult(2, "ApplicationNotValid");
        values.add(ApplicationNotValid);
        FirmNotAllowed = new LoginResult(3, "FirmNotAllowed");
        values.add(FirmNotAllowed);
        UserNotAllowed = new LoginResult(4, "UserNotAllowed");
        values.add(UserNotAllowed);
        IncorrectVersion = new LoginResult(5, "IncorrectVersion");
        values.add(IncorrectVersion);
        LoggedInElsewhere = new LoginResult(6, "LoggedInElsewhere");
        values.add(LoggedInElsewhere);
        Logout = new LoginResult(7, "Logout");
        values.add(Logout);
        UnexpectedDisconnect = new LoginResult(8, "UnexpectedDisconnect");
        values.add(UnexpectedDisconnect);
        Unauthorized = new LoginResult(9, "Unauthorized");
        values.add(Unauthorized);
        UnexpectedError = new LoginResult(10, "UnexpectedError");
        values.add(UnexpectedError);
        RoleNotSupported = new LoginResult(11, "RoleNotSupported");
        values.add(RoleNotSupported);
        APIMessageBacklog = new LoginResult(12, "APIMessageBacklog");
        values.add(APIMessageBacklog);
        ServerMessageBacklog = new LoginResult(13, "ServerMessageBacklog");
        values.add(ServerMessageBacklog);
        PasswordExpired = new LoginResult(14, "PasswordExpired");
        values.add(PasswordExpired);
        PasswordChangeFailed = new LoginResult(16, "PasswordChangeFailed");
        values.add(PasswordChangeFailed);
        PasswordAlreadyUsed = new LoginResult(17, "PasswordAlreadyUsed");
        values.add(PasswordAlreadyUsed);
        LockedOut = new LoginResult(18, "LockedOut");
        values.add(LockedOut);
        AdditionalUsersNotAllowed = new LoginResult(19, "AdditionalUsersNotAllowed");
        values.add(AdditionalUsersNotAllowed);
        MarketDataNotSetup = new LoginResult(20, "MarketDataNotSetup");
        values.add(MarketDataNotSetup);
        TwoFactorAuthenticationNotSetup = new LoginResult(21, "TwoFactorAuthenticationNotSetup");
        values.add(TwoFactorAuthenticationNotSetup);
        TwoFactorAuthenticationFailed = new LoginResult(22, "TwoFactorAuthenticationFailed");
        values.add(TwoFactorAuthenticationFailed);
        FIXSessionError = new LoginResult(23, "FIXSessionError");
        values.add(FIXSessionError);
        TwoFactorAuthenticationRequired = new LoginResult(24, "TwoFactorAuthenticationRequired");
        values.add(TwoFactorAuthenticationRequired);
        UserExists = new LoginResult(25, "UserExists");
        values.add(UserExists);
        for (LoginResult t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new LoginResult[values.size()];
        values.toArray(mValues);
    }
}

